###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###

try: import gpod
except : pass

import gtk
import gobject
import pango
import os
import threading

import config
from transcode import Transcoder
from song import Song
from misc_widget import WindowBase
from misc_widget import WindowMessage

class IPodTransfertManager:
    def __init__(self,media_organizer):
        self.media_organizer = media_organizer

        self.ipod_transfert_song_pending = []
        self.ipod_transfert_total_song = 0
        self.current_added = None
        self.ipod_is_in_transfer=False
        self.ipod_update_cover = False
        self.list_ipod_to_save  = []


    #Make the widget for ipod transfert
    def get_ipod_transfert_box(self):
        self.ipod_transfert_bar = gtk.ProgressBar()
        self.ipod_transfert_bar.set_fraction(0)
        self.ipod_transfert_bar.set_ellipsize(pango.ELLIPSIZE_START)
        self.ipod_transfert_bar.set_text("")

        self.ipod_transfert_box = gtk.VBox()


        self.ipod_encode_bar = gtk.ProgressBar()
        self.ipod_encode_bar.set_fraction(0)
        self.ipod_encode_bar.set_ellipsize(pango.ELLIPSIZE_START)
        self.ipod_encode_bar.set_text("")
        self.ipod_encode_bar.set_no_show_all(True)

        btn_annuler = gtk.Button()
        btn_annuler.connect("clicked",self.cancel_tranfert)
        #btn_annuler.set_alignment(1,1)
        image = gtk.image_new_from_stock(gtk.STOCK_CANCEL,  gtk.ICON_SIZE_MENU)
        #pixmap = image.get_pixbuf()
        btn_annuler.add(image)
        btn_annuler.set_size_request(24,24)
        box_btn = gtk.VBox()
        box_btn.pack_end(btn_annuler,False,False)

        hbox = gtk.HBox()
        hbox.pack_start(self.ipod_transfert_bar,True,True)
        hbox.pack_start(box_btn,False,False)
        hbox.set_spacing(6)

        self.ipod_transfert_box.pack_start(hbox,False,False)
        self.ipod_transfert_box.pack_start(self.ipod_encode_bar,False,False)
        self.ipod_transfert_box.set_spacing(6)

        self.ipod_transfert_box.set_no_show_all(True)
        return  self.ipod_transfert_box

    def start_refresh_cover(self,ipod):
            self.ipod_update_cover = True
            self.stop_thread = False
            self.ipod_transfert_bar.set_fraction(0)
            self.ipod_transfert_bar.set_text(_("Update cover"))
            self.ipod_transfert_box.set_no_show_all(False)
            self.ipod_transfert_box.show_all()
            thread = threading.Thread(target=self.refresh_cover, args = (ipod,))
            thread.start()

    def refresh_cover(self,ipod):
        list_art_to_skip = []
        self.list_ipod_to_save.append(ipod)
        i = 0
        for song in ipod.songs:
            if self.stop_thread:
                break
            if song.get_album_cover(True) in list_art_to_skip:
                continue
            art = song.get_album_cover(True)
            #check cover is not the default cover
            if art == song.get_album_cover_path():
                if os.path.exists(art):
                    if gpod.itdb_track_set_thumbnails(song.ipod_track,str(art)) == 0:
                        print "Failed to save image thumb for ",self.title
                    else:
                        pass
                        #print song.sprint("artist")+" - "+song.sprint("album")+ " - "+song.sprint("title")
            else:
                list_art_to_skip.append(song.get_album_cover_path())
            i += 1
            fraction = round(round(i) /len(ipod.songs),2)
            gobject.idle_add(self.ipod_transfert_bar.set_fraction,fraction)
            gobject.idle_add(self.ipod_transfert_bar.set_text,_("Update cover")+" %d/%d"%(i,len(ipod.songs)))
        self.ipod_update_cover = False
        self.stop_transfert()


    def add_transfert_queue(self,song,ipod,playlist):

        #Must be a local file # and exist in DB
        if song.get_protocol()!="file://":# song.id==None and
            return
        self.ipod_transfert_total_song += 1
        try: n = self.list_ipod_to_save.index(ipod)
        except ValueError: self.list_ipod_to_save.append(ipod)
        #print len(self.ipod_transfert_song_pending)
        self.ipod_transfert_song_pending.append({"song":song,"ipod":ipod,"playlist":playlist})


        if not self.ipod_is_in_transfer:
            self.ipod_is_in_transfer = True
            self.stop_thread = False
            self.ipod_transfert_bar.set_fraction(0)
            self.ipod_transfert_bar.set_text(_("Transfering"))
            self.ipod_transfert_box.set_no_show_all(False)
            self.ipod_transfert_box.show_all()
            thread = threading.Thread(target=self.thread_work_transfert)
            thread.setDaemon(True)
            thread.start()
            #gobject.idle_add(self.control_transfert)


    def thread_work_transfert(self):
        while not self.stop_thread and (len(self.ipod_transfert_song_pending)>0) :
            self.current_song_transfert = self.ipod_transfert_song_pending.pop(0)
            gobject.idle_add(self.refresh_progress)

            #Add song to ipod cache song if succesful copy to ipod
            #for function self.already_exist can work
            #Warning :
            #    album and artist will updated only at the end of transfert
            #    when the entire cache is regenered
            track = self.current_song_transfert["ipod"].add_song(self.current_song_transfert["song"],self.current_song_transfert["playlist"],self.ipod_encode_bar,self.refresh_progress)
            if track!=None:
                self.current_song_transfert["song"].ipod_track = track
                if self.current_song_transfert["song"].podcast:
                    self.current_song_transfert["ipod"].podcast_songs.append(self.current_song_transfert["song"])
                else:
                    self.current_song_transfert["ipod"].songs.append(self.current_song_transfert["song"])


        self.stop_transfert()

    def refresh_progress(self):
        total = round(self.ipod_transfert_total_song)
        if total>0:
            i = total - len(self.ipod_transfert_song_pending)
            fraction = round(round(i) /total,2)
            self.ipod_transfert_bar.set_fraction(fraction)
            self.ipod_transfert_bar.set_text(_("Transfering")+" %d/%d"%(i,self.ipod_transfert_total_song))


    def cancel_tranfert(self,*param):
        for ipod in self.list_ipod_to_save:
            ipod.stop_encode = True
        self.stop_thread=True


    def stop_transfert(self):
        self.ipod_is_in_transfer = False

        self.ipod_transfert_song_pending = []
        self.ipod_transfert_total_song = 0
        gobject.idle_add(self.ipod_transfert_bar.set_fraction,1.00)
        gobject.idle_add(self.ipod_transfert_bar.set_text,_("Save IPod database..."))
        #self.ipod_browser.refresh_cache,mount_point)
        for ipod in self.list_ipod_to_save:
            ipod.save_itdb()
        self.list_ipod_to_save = []
        gobject.idle_add(self.ipod_transfert_box.hide_all)
        gobject.idle_add(self.ipod_transfert_box.set_no_show_all,True)
        print "save db ok"
        from media_source import IPodSource
        for source in self.media_organizer.list_source:
            if isinstance(source,IPodSource):
                source.widget.refresh_song_cache()
                gobject.idle_add(source.widget.populate_view)




class IPod:
    def __init__(self,mount_point,udi,size):
        self.udi = udi
        self.size = size
        self.mount_point = mount_point
        self.stop_encode = False

    def read(self):
        self.songs=[]
        self.podcast_songs=[]
        self.artists = []
        self.albums = []
        self.playlists = []
        self.db = os.path.join(self.mount_point,"iPod_Control/iTunes/iTunesDB")
        self.sysinfo_path = os.path.join(self.mount_point, 'iPod_Control', 'Device', 'SysInfo')
        self.init_ipod_model_info()
        mount_point = str(self.mount_point)
        self.itdb = gpod.itdb_parse(mount_point, None)
        if not self.itdb:
            print "Failed to read %s" % self.db
            return self.create_ipod_structure()
        else:
            """ check podcast playlist exsist and create it if not """
            if self.check_ipod_structure():
                return True
            else:
                print "Failed create master and podcast playlist"
        return True

    def check_ipod_structure(self,itdb = None,ipod_name="iPod"):
        if itdb == None: itdb = self.itdb
        #Create main and podcast playlist
        mpl = gpod.itdb_playlist_mpl(itdb)
        if mpl==None:
            mpl = gpod.itdb_playlist_new(str(ipod_name),False)
            gpod.itdb_playlist_set_mpl(mpl)
            gpod.itdb_playlist_add(itdb,mpl,0)
        ppl = gpod.itdb_playlist_podcasts(itdb)
        if ppl==None:
            ppl = gpod.itdb_playlist_new("Podcasts",False)
            gpod.itdb_playlist_set_podcasts(ppl)
            gpod.itdb_playlist_add(itdb,ppl,1)
        return gpod.itdb_playlist_mpl(itdb)!= None and gpod.itdb_playlist_podcasts(itdb)!=None


    def create_ipod_structure(self):
        itdb = gpod.itdb_new()
        db_dir = self.mount_point+"/iPod_Control/iTunes/"
        dialog = WindowBase(_("New iPod detected, choose a name"),config.PIXMAP_DIR+"/ipod_big.png")
        hbox = gtk.HBox(0,6)
        hbox.pack_start(gtk.Label(_("Name")+" :"))
        self.entry= gtk.Entry()
        self.entry.set_activates_default(True)
        self.entry.grab_focus()
        hbox.pack_start(self.entry)
        dialog.add_widget(hbox)
        dialog.show_all()
        result = dialog.run()
        if result == gtk.RESPONSE_ACCEPT:
            ipod_name = self.entry.get_text()
            if ipod_name.strip() == "":
                dialog.destroy()
                return False
        else:
            dialog.destroy()
            return False
        dialog.destroy()
        if not os.path.exists(db_dir):
            os.makedirs(db_dir)
        if not os.path.exists(self.mount_point+"/iPod_Control/Artwork"):
            os.makedirs(self.mount_point+"/iPod_Control/Artwork")
        if not os.path.exists(self.mount_point+"/iPod_Control/Device"):
            os.makedirs(self.mount_point+"/iPod_Control/Device")
        for dir_number in range(0,20):
            if not os.path.exists(self.mount_point+"/iPod_Control/Music/F%02d"%dir_number):
                os.makedirs(self.mount_point+"/iPod_Control/Music/F%02d"%dir_number)

        """if self.artwork_support and not os.path.exists(self.sysinfo_path):
            WindowMessage(_("iPod system files are missing"),_("Some iPod system files are missing")+".\n"+\
                    _("You must disconnect the iPod, wait for it to initialize and reconnect it.")+"\n"+\
                    _("So the files will be created")+"\n"+\
                    _("if your iPod don't support this feature do not pay attention to this message"))
        """
        m = str(self.mount_point)
        gpod.itdb_set_mountpoint(itdb,m)
        self.check_ipod_structure(itdb,ipod_name)
        gpod.itdb_write_file(itdb,str(db_dir+"iTunesDB"),None)
        gpod.itdb_shuffle_write_file(itdb,str(db_dir+"iTunesSD"),None)
        self.read()
        return True



    def add_song(self,song,playlist,encode_bar,refresh_func_cb):

        if song.get_protocol()=="file://":
            ipod_song = self.get_song_on_ipod(song)
            if ipod_song!=None:
               print "Exist in ipod"
               if playlist!=None and not gpod.itdb_playlist_is_podcasts(playlist):
                   #verif if song is in playlist
                   if gpod.itdb_playlist_contains_track(playlist, ipod_song.ipod_track):
                       print "Exist in playlist"
                       pass
                   else: #Add it to the playlist
                        if gpod.itdb_playlist_add_track(playlist, ipod_song.ipod_track,-1)!=0:
                            print "Added in playlist"
                            pass
                        else:
                            print "Not added to playlist"
                            pass
               return None

            else :
                if song.get_ext()!=".mp3":
                    transcoder = Transcoder(song)
                    self.stop_encode = False
                    transcoder.start()
                    gobject.idle_add(encode_bar.set_fraction,0)
                    gobject.idle_add(encode_bar.set_text,_("Encode")+" 0%")
                    gobject.idle_add(encode_bar.show)
                    while not transcoder.is_finish():
                        percent = int(transcoder.get_progress())
                        i = round(float(percent)/100,2)
                        gobject.idle_add(encode_bar.set_fraction,i)
                        gobject.idle_add(encode_bar.set_text,_("Encode")+" %d%%"%percent)
                        gobject.idle_add(refresh_func_cb)
                        if self.stop_encode==True:
                            gobject.idle_add(encode_bar.hide)
                            self.stop_encode = False
                            transcoder.stop()
                            del transcoder
                            return None
                    gobject.idle_add(encode_bar.hide)

                    #get new song isinstance
                    song = transcoder.get_new_song()
                    del transcoder

                path = song.get_path()
                track = song.get_ipod_track()
                if track is None:
                    print "Error while preparing %s on iPod"%path
                else:
                    track.itdb = self.itdb
                    if  gpod.itdb_cp_track_to_ipod(track,str(path),None)==0:
                        print "Error while copying %s on iPod"%path
                    else:
                        if gpod.itdb_track_add(self.itdb,track,-1)==0:
                            print "Error while adding %s on the master playlist of the iPod"%path
                        else:
                            if song.podcast:
                                mpl = gpod.itdb_playlist_podcasts(self.itdb)
                            else:
                                mpl = gpod.itdb_playlist_mpl(self.itdb)

                            if gpod.itdb_playlist_add_track(mpl,track,-1)==0:
                                print "Error while attaching %s to the master playlist of the iPod"%path
                            else:
                                if playlist!=None and not gpod.itdb_playlist_is_podcasts(playlist):
                                    if gpod.itdb_playlist_add_track(playlist, track,-1)==0:
                                        print "Error while adding %s on a playlist of the iPod"%path
                                        return None

                                #print "Succes copy to IPOD",track.transferred
                                #self.save_itdb(mount_point)

                                #create a new song for the cache
                                #only for control duplicate entry
                                #after all file have been transfered
                                #entire cache will be regenered
                                new_song = Song()
                                new_song.read_from_song(song)
                                new_song.ipod_track = track
                                #Add new file to the cache
                                if song.podcast:
                                    self.podcast_songs.append(new_song)
                                else:
                                    self.songs.append(new_song)
                                return track
        else:
            print _("No support for this type of media")

        return None

    def refresh_cache(self):
        self.songs=[]
        self.podcast_songs=[]
        #print len(gpod.sw_get_tracks(self.itdb)),"Song on ipod"
        ppl = gpod.itdb_playlist_podcasts(self.itdb)
        for track in gpod.sw_get_tracks(self.itdb):
            #print track.charset
            song = Song()
            song.read_from_ipod_track(track,self.mount_point)
            if gpod.itdb_playlist_contains_track(ppl, track):
                song.podcast=True
                self.podcast_songs.append(song)
            else:
                self.songs.append(song)

        for playlist in gpod.sw_get_playlists(self.itdb):
            if not gpod.itdb_playlist_is_mpl(playlist) and \
                   not gpod.itdb_playlist_is_podcasts(playlist) :
                self.playlists.append(playlist)


    def get_song_from_playlist(self,playlist):
        list_song = []
        for song in self.songs:
            if gpod.itdb_playlist_contains_track(playlist, song.ipod_track):
                list_song.append(song)

        return list_song


    def save_itdb(self,refresh_now=True):
        #print "Write IPOD DB",mount_point
        if gpod.itdb_write(self.itdb, None)==0:
            print "Failed to save iPod database"
        else:
            #print "Write Shuffle IPOD DB",mount_point
            if gpod.itdb_shuffle_write(self.itdb, None)==0:
                print "Failed to save iPod database"
        #print "Refresh iPod db cache",mount_point
        if refresh_now:
            self.refresh_cache()
        else:
            gobject.idle_add(self.refresh_cache)

    def get_ipod_name(self):
        mpl = gpod.itdb_playlist_mpl(self.itdb)
        return mpl.name

    def set_ipod_name(self,name):
        mpl = gpod.itdb_playlist_mpl(self.itdb)
        mpl.name = name
        self.save_itdb()

    #Remove track don't update database on the iPod
    def remove_song(self,song):
        track = song.ipod_track
        #print "Removing track.."
        #print "..disk"
        file = gpod.itdb_filename_on_ipod(track)
        if file != None:
            os.unlink(file)
        for playlist in gpod.sw_get_playlists(self.itdb):
            if gpod.itdb_playlist_contains_track(playlist, track):
                #print u"..playlist %s" % playlist.name
                gpod.itdb_playlist_remove_track(playlist, track)
        #print "..db"
        gpod.itdb_track_unlink(track)
        #print "Track removed."
        return True

    def get_song_on_ipod(self,song):
        if song.podcast:
            songs = self.podcast_songs
        else:
            songs = self.songs
        for s in songs:
            if s.title != song.title:
                continue
            elif s.artist != song.artist:
                continue
            elif s.album != song.album:
                continue
            elif s.duration != song.duration:
                continue
            elif s.title != song.title:
                continue
            else:
                return s
        return None


    def get_all_playlist(self):

        list = []
        for playlist in gpod.sw_get_playlists(self.itdb):
            if not gpod.itdb_playlist_is_mpl(playlist):# and \
                   #not gpod.itdb_playlist_is_podcasts(playlist) :
                list.append(playlist)

        return list

    def create_playlist(self,name):
        playlist = gpod.itdb_playlist_new(name,False)
        gpod.itdb_playlist_add(self.itdb,playlist,-1)
        self.save_itdb()


    def rename_playlist(self,playlist,new_name):
        playlist.name = new_name
        self.save_itdb()

    def remove_playlist(self,playlist):
        gpod.itdb_playlist_remove(playlist)
        self.save_itdb()


    """ From gpixpod """
    def init_ipod_model_info(self):
        """ Get iPod model """

        if os.path.isfile(self.sysinfo_path):
            sysinfo_file = open(self.sysinfo_path)
            for sysinfo_line in sysinfo_file:
                if sysinfo_line.split(':')[0] == 'boardHwSwInterfaceRev':
                    ipod_mcode = sysinfo_line.split(' ')[1]
                    # Infos got from http://ipodlinux.org/Generations
                    if ipod_mcode == '0x00010000':
                        self.artwork_support = False
                        self.ipod_version = '1G'
                    elif ipod_mcode == '0x00020000':
                        self.artwork_support = False
                        self.ipod_version = '2G'
                    elif ipod_mcode == '0x00030001':
                        self.artwork_support = False
                        self.ipod_version = '3G'
                    elif ipod_mcode == '0x00040013':
                        self.artwork_support = False
                        self.ipod_version = '1G Mini'
                    elif ipod_mcode == '0x00050013':
                        self.artwork_support = False
                        self.ipod_version = '4G'
                    elif ipod_mcode == '0x00060000':
                        self.artwork_support = True
                        self.ipod_version = 'Photo'
                    elif ipod_mcode == '0x00060004':
                        self.artwork_support = True
                        self.ipod_version = 'Color'
                    elif ipod_mcode == '0x00070002':
                        self.artwork_support = False
                        self.ipod_version = '2G Mini'
                    elif ipod_mcode == '0x000B0005':
                        self.artwork_support = True
                        self.ipod_version = '5G'
                    elif ipod_mcode == '0x000C0005':
                        self.artwork_support = True
                        self.ipod_version = 'Nano'
                    elif ipod_mcode == '0x000C0006':
                        self.artwork_support = True
                        self.ipod_version = 'Nano'
                    else:
                        self.artwork_support = False
                        self.ipod_version = 'Unrecognized'
        else:
            self.artwork_support = False
            print "Problems opening %s. Does this file exist? If it doesn't exist, then it should be an iPod shuffle?" % self.sysinfo_path
