###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###


import os, sys
import gtk
import gobject
import pango
import gnome
import gnome.ui
from datetime import datetime
#import threading
#gnome.init("listen", "version")

import config
import stock
import utils
from misc_widget import VolumeSlider
from view_playlist_current import *
from song import Song
from misc_widget import WindowMessage
from gstplayer import *
from thread_queue import ThreadQueue

from audioscrobbler_manager import AudioScrobblerManager


class Player(gtk.VBox):
    __gsignals__ = {
        "player-action" : (gobject.SIGNAL_RUN_LAST,
                gobject.TYPE_NONE,
                (gobject.TYPE_STRING,))
    }
    def __init__(self,osd):
        self.osd = osd
        
        
        self.gst_player = GstPlayer(self)
        self.audioscrobbler = AudioScrobblerManager()

        gtk.VBox.__init__(self)

        self.btn_previous = gtk.Button()
        self.btn_previous.add(gtk.image_new_from_stock(gtk.STOCK_MEDIA_PREVIOUS, gtk.ICON_SIZE_LARGE_TOOLBAR))
        self.btn_previous.connect("clicked",self.__playlist_action,"previous")
        utils.set_tip(self.btn_previous,_("Previous"))

        self.btn_next = gtk.Button()
        self.btn_next.add(gtk.image_new_from_stock(gtk.STOCK_MEDIA_NEXT, gtk.ICON_SIZE_LARGE_TOOLBAR))
        self.btn_next.connect("clicked",self.__playlist_action,"next")
        utils.set_tip(self.btn_next,_("Next"))

        self.btn_play = gtk.Button()
        self.btn_play.add(gtk.image_new_from_stock(gtk.STOCK_MEDIA_PLAY, gtk.ICON_SIZE_LARGE_TOOLBAR))
        self.btn_play.connect("clicked",self.__playlist_action,"play")
        utils.set_tip(self.btn_play,_("Play"))

        self.btn_dyna = gtk.ToggleButton()
        self.btn_dyna.add(gtk.image_new_from_stock(stock.DYNAMIC, gtk.ICON_SIZE_LARGE_TOOLBAR))
        if config.get("player","dynamic")=="true":
            self.btn_dyna.set_active(True)
        self.btn_dyna.connect("clicked",self.on_dynamic_mode_change)
        utils.set_tip(self.btn_dyna,_("Dynamic Playlist Mode (Using last.fm)"))


        self.btn_volume = VolumeSlider(self.gst_player)
        utils.set_tip(self.btn_volume,_("Volume"))

        self.playlist_total_time = gtk.Label()
        self.playlist_total_time.set_alignment(0,1)

        self.time_box = SongTime(self)

        top_box = gtk.HBox()
        top_box.set_spacing(6)
        top_box.pack_start(self.btn_previous,False,False)
        top_box.pack_start(self.btn_play,False,False)
        top_box.pack_start(self.btn_next,False,False)
        top_box.pack_start(self.btn_volume,False,False)


        if self.gst_player.video_widget and config.get("player","enable_vis")=="true":
            self.frame_video = gtk.Frame()
            self.frame_video.set_shadow_type(gtk.SHADOW_IN)
            top_box.pack_end(self.frame_video)
            self.frame_video.add(self.gst_player.video_widget)

        self.current_song_widget = {}
        self.current_song_widget["title"] = gtk.Label(" ")
        self.current_song_widget["title"].set_use_markup(True)
        self.current_song_widget["title"].set_size_request(-1,26)
        self.current_song_widget["title"].show()
        self.current_song_widget["title"].set_alignment(0,0.5)
        self.current_song_widget["title"].set_ellipsize(pango.ELLIPSIZE_END)
        self.current_song_widget["artist"] = gtk.Label(" ")
        self.current_song_widget["artist"].set_use_markup(True)
        self.current_song_widget["artist"].set_alignment(0,0.5)
        self.current_song_widget["artist"].show()
        self.current_song_widget["artist"].set_ellipsize(pango.ELLIPSIZE_END)
        self.current_song_widget["album"] = gtk.Label(" ")
        self.current_song_widget["album"].set_use_markup(True)
        self.current_song_widget["album"].set_alignment(0,0.5)
        self.current_song_widget["album"].set_ellipsize(pango.ELLIPSIZE_END)
        self.current_song_widget["album"].show()

        btn_artist = gtk.Button()
        btn_artist.set_relief(gtk.RELIEF_NONE)
        btn_artist.add(gtk.image_new_from_stock(stock.LASTFM, gtk.ICON_SIZE_MENU))
        btn_artist.set_size_request(28,22)
        btn_artist.connect("clicked",self.lastfm_hook,"artist")
        utils.set_tip(btn_artist,_("See artist information at www.last.fm"))

        btn_album = gtk.Button()
        btn_album.set_relief(gtk.RELIEF_NONE)
        btn_album.add(gtk.image_new_from_stock(stock.LASTFM, gtk.ICON_SIZE_MENU))
        btn_album.set_size_request(28,22)
        btn_album.connect("clicked",self.lastfm_hook,"album")
        utils.set_tip(btn_album,_("See album information at www.last.fm"))

        self.box_artist = gtk.HBox(False,6)
        self.box_artist.pack_start(self.current_song_widget["artist"],True,True)
        self.box_artist.pack_start(btn_artist,False,False)
        self.box_artist.show_all()
        self.box_artist.set_no_show_all(True)
        self.box_artist.hide()

        self.box_album = gtk.HBox(False,6)
        self.box_album.pack_start(self.current_song_widget["album"],True,True)
        self.box_album.pack_start(btn_album,False,False)
        self.box_album.show_all()
        self.box_album.set_no_show_all(True)
        self.box_album.hide()

        song_information = gtk.VBox(False,0);#"<b><i>Stopped</i></b>");#"<b>Title</b>\n<i>Artist</i>\nAlbum")
        song_information.pack_start(self.current_song_widget["title"],True,True)
        song_information.pack_start(self.box_artist,True,True)
        song_information.pack_start(self.box_album,True,True)
        #self.song_information.set_property("ellipsize",pango.ELLIPSIZE_END)


        self.current_song = Song()
        self.album_cover = gtk.image_new_from_stock(stock.ALBUM_ART, gtk.icon_size_register("album_cover", 75, 75))

        self.album_cover.set_size_request(75,75)
        self.album_cover.set_alignment(0.5,0.5)

        self.btn_album_cover = gtk.Button()
        self.btn_album_cover.set_alignment(0.5,0.5)
        self.btn_album_cover.connect("clicked",self.on_change_album_cover)
        self.btn_album_cover.set_relief(gtk.RELIEF_NONE)
        album_frame = gtk.Frame()
        album_frame.add(self.album_cover)
        album_frame.set_shadow_type(gtk.SHADOW_IN)
        self.btn_album_cover.add(album_frame)
        utils.set_tip(self.btn_album_cover,_("Click to change album cover"))


        hbox_info2 = gtk.VBox(False,0)
        hbox_info2.pack_start(song_information,False,False)
        hbox_info2.pack_start(self.time_box,False,False)
        self.hbox_info = gtk.HBox()
        self.hbox_info.pack_start(self.btn_album_cover,False,False)
        self.hbox_info.pack_start(hbox_info2,True,True)
        self.hbox_info.set_spacing(6)
        self.hbox_info.set_size_request(300,-1)


        self.label_playlist = gtk.Label("<b>"+_("Playlist")+"</b>")
        self.label_playlist.set_use_markup(True)
        self.label_playlist.set_alignment(0,1)


        vbox1 = gtk.VBox()
        vbox1.pack_start(top_box,False,False)
        vbox1.pack_start(self.hbox_info,False,False)
        vbox1.set_spacing(6)





        self.btn_save= gtk.Button()
        self.btn_save.add(gtk.image_new_from_stock(gtk.STOCK_SAVE, gtk.ICON_SIZE_LARGE_TOOLBAR))
        self.btn_save.set_size_request(36,-1)
        utils.set_tip(self.btn_save,_("Save playlist"))

        self.btn_burn = gtk.Button()
        self.btn_burn.add(gtk.image_new_from_stock(gtk.STOCK_CDROM, gtk.ICON_SIZE_LARGE_TOOLBAR))
        self.btn_burn.set_size_request(36,-1)
        utils.set_tip(self.btn_burn,_("Burn playlist"))

        self.btn_clear = gtk.Button()
        self.btn_clear.add(gtk.image_new_from_stock(gtk.STOCK_CLEAR, gtk.ICON_SIZE_LARGE_TOOLBAR))
        self.btn_clear.set_size_request(36,-1)
        utils.set_tip(self.btn_clear,_("Clear playlist"))

        self.btn_shuffle = gtk.Button()
        self.btn_shuffle.add(gtk.image_new_from_icon_name("stock_shuffle", gtk.ICON_SIZE_LARGE_TOOLBAR))
        self.btn_shuffle.set_size_request(36,-1)
        utils.set_tip(self.btn_shuffle,_("Shuffle playlist"))
        #self.btn_shuffle.add(gtk.image_new_from_icon_name("stock_shuffle", gtk.ICON_SIZE_LARGE_TOOLBAR))

        self.btn_repeat = gtk.ToggleButton()
        self.btn_repeat.set_size_request(36,-1)
        utils.set_tip(self.btn_repeat,_("Repeat playlist mode"))

        self.btn_repeat.add(gtk.image_new_from_icon_name("stock_repeat", gtk.ICON_SIZE_LARGE_TOOLBAR))
        if config.get("setting","repeat_mode")=="true":
            self.btn_repeat.set_property("active",True)

        hbox3 = gtk.HBox()
        hbox3.pack_start(self.btn_save,False,False)
        hbox3.pack_start(self.btn_burn,False,False)
        hbox3.pack_start(self.btn_clear,False,False)
        hbox3.pack_start(self.btn_shuffle,False,False)
        hbox3.pack_start(self.btn_repeat,False,False)
        hbox3.pack_end(self.btn_dyna,False,False)


        self.playlist = Playlist(self)
        self.btn_clear.connect("clicked",self.playlist.clear)
        self.btn_burn.connect("clicked",self.burn)
        self.btn_save.connect("clicked",self.playlist.save_current_playlist)
        self.btn_shuffle.connect("clicked",self.playlist.shuffle)
        self.btn_repeat.connect("clicked",self.playlist.repeat)

        scroll = gtk.ScrolledWindow()
        scroll.add(self.playlist)
        scroll.set_shadow_type(gtk.SHADOW_IN)
        scroll.set_policy(gtk.POLICY_NEVER,gtk.POLICY_AUTOMATIC)
        scroll.set_size_request(-1,300)

        self.playlist_box = gtk.VBox()
        self.playlist_box.pack_start(self.playlist_total_time,False,False)
        self.playlist_box.pack_start(scroll,True,True)
        self.playlist_box.pack_start(hbox3,False,False)
        self.playlist_box.set_spacing(6)
        self.playlist_box.show_all()

        self.pack_start(vbox1,False,False)
        self.pack_start(self.playlist_box,True,True)
        self.set_spacing(12)
        self.set_size_request(300,-1)

        self.dbus_notify=None
        try:
            import dbus
            bus = dbus.SessionBus()
            obj = bus.get_object(
                "org.freedesktop.Notifications",
                "/org/freedesktop/Notifications")
            self.dbus_notify = dbus.Interface(obj, "org.freedesktop.Notifications")
        except: pass
        """self.keys = MmKeys({"mm_prev": self.__mm_previous,
                              "mm_next": self.__mm_next,
                              "mm_playpause": self.__mm_play})"""
        self.keys =MmKeys(self)
        self.playlist.connect("playlist-changed",self.on_playlist_changed_cb)

        self.current_song = None
        self.thread_album_cover = None

    def on_dynamic_mode_change(self,btn):
        if btn.get_active():
            config.set("player","dynamic","true")
        else:
            config.set("player","dynamic","false")


    def mm_previous(self,a,b):
        self.btn_previous.emit("clicked")
    def mm_next(self,a,b):
        self.btn_next.emit("clicked")
    def mm_play(self,a,b):
        self.btn_play.emit("clicked")

    def on_crossfade(self,btn=None):
        if btn.get_active():
            config.set("player","crossfade","true")
        else:
            config.set("player","crossfade","fade")

    def burn(self,btn=None):
        if not utils.iscommand("serpentine"):
            WindowMessage(_("Serpertine not found"),_("You must install serpentine to burn AudioCD"))

        list_song = []
        for row in self.playlist.model:
            list_song.append(row[0])
        utils.export_playlist("/tmp/listen_burn_list.m3u",list_song)
        os.spawnlp(os.P_NOWAIT, "serpentine","serpentine","-o","/tmp/listen_burn_list.m3u")
        return

        """ No needed question for now"""
        dialog = WindowBase(_("Would you like to burn this playlist ?"),config.PIXMAP_DIR+"playlist_burn.png",None)

        dialog.add_button(gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL)

        btn_pref = gtk.Button(gtk.STOCK_PREFERENCES)
        btn_pref.set_use_stock(True)
        dialog.add_action_widget(btn_pref,gtk.RESPONSE_NONE)

        btn_burn = gtk.Button(_("Burn"))
        btn_burn.set_image(gtk.image_new_from_stock(gtk.STOCK_CDROM, gtk.ICON_SIZE_LARGE_TOOLBAR))
        dialog.add_action_widget(btn_burn,gtk.RESPONSE_OK)

        label = gtk.Label(_("Tips : For more options configure serpentine"))
        label.set_alignment(0,0.5)

        dialog.add_widget(label)
        dialog.show_all()
        res = gtk.RESPONSE_NONE
        while res == gtk.RESPONSE_NONE:
            res = dialog.run()
            if res == gtk.RESPONSE_NONE:
                os.spawnlp(os.P_NOWAIT, "serpentine","serpentine","--preferences")

        if res == gtk.RESPONSE_OK:
            os.spawnlp(os.P_NOWAIT, "serpentine","serpentine","/tmp/listen_burn_list.m3u")

        dialog.destroy()


    def playlist_next_cb(self):
        self.__playlist_action(None, "next")

    def __playlist_action(self,btn, action):
        #print "playlist_action",action

        if action == "play":
            if not self.gst_player.paused:
                res = "pause"
                self.gst_player.pause()
                self.pause()
            else:
                if not self.gst_player.is_playable():
                    res = "play"
                    self.play(self.playlist.get_next_song())
                elif len(self.playlist.model)!=0 or self.gst_player.is_playable():
                    self.play()
                    res = "play"
                else:
                    self.pause()
                    return

        if action == "next":
            res = "next"
            song = self.playlist.get_next_song()
            if song!=None:
                self.play(song)
            else:
                self.pause()
                return

        if action == "previous":
            res = "previous"
            song = self.playlist.get_previous_song()
            if song!=None:
                self.play(song)
            else:
                self.pause()
                return

        gobject.idle_add(self.emit,"player-action",res)

    def pause(self):
        self.gst_player.pause()
        self.btn_play.child.set_from_stock(gtk.STOCK_MEDIA_PLAY,gtk.ICON_SIZE_LARGE_TOOLBAR)


    def play(self,song=None):
        if song!=None:
            self.gst_player.play_new(song)
            gobject.idle_add(self.update_metadata_db,song)
        else:
            self.gst_player.play()
        self.btn_play.child.set_from_stock(gtk.STOCK_MEDIA_PAUSE,gtk.ICON_SIZE_LARGE_TOOLBAR)


    def update_metadata_db(self,song):
        if song!=None:
            song.update_play_information()
            #Check song is in DB
            if song.id!=None:
                DBManager.update_song(song,["playcount","last_played"])




    def on_playlist_changed_cb(self,widget,info):
        gobject.idle_add(self.on_playlist_changed,info)

    def on_playlist_changed(self,song,show_osd=True):
        if song==None:
            print "Playlist change with no song !?"
            return

        self.time_box.audioscrobbler_report = True
        
        if song.iradio:
            self.time_box.hide()
        else:
            self.time_box.show()

        self.time_box.set_duration(song.get_property("duration"))
        self.current_song = song
        if song.get_property("id")!=None:
            config.set("player","last_played",song.get_property("id"))

        sep="\n"
        sep_title=" - "

        osd_verif_no_change_string= ""
        text=""
        title=""
        art=""
        osd_verif_no_change_string= ""

        title = song.sprint("title")
        text += "<b>"
        if song.sprint("tracknr")!="":
            text += song.sprint("tracknr")+" - "

        text += utils.xmlescape(song.sprint("title"))
        if song.get_property("duration"):
            text += " ("+utils.duration_to_string(song.get_property("duration"))+")"
        text += "</b>"
        self.current_song_widget["title"].set_markup("<span size=\"x-large\"><b>"+utils.xmlescape(song.sprint("title"))+"</b></span>")
        if song.get_property('podcast'):
            """ This is a podcast """
            if song.sprint("podcast_feed_title")!="":
                self.current_song_widget["artist"].set_markup("<span size=\"large\"><i>"+utils.xmlescape(song.sprint("podcast_feed_title"))+"</i>"+"</span>")
                self.box_artist.show()
                self.box_artist.get_children()[1].hide()
                text += sep+"<i>"+utils.xmlescape(song.sprint("podcast_feed_title"))+"</i>"
                title += sep_title+song.sprint("podcast_feed_title")
            else:
                self.box_artist.hide()

            if song.sprint("date")!="":
                self.current_song_widget["album"].set_markup("<span size=\"large\">"+utils.xmlescape(song.sprint("date"))+"</span>")
                self.box_album.show()
                self.box_album.get_children()[1].hide()
                text += sep+utils.xmlescape(song.sprint("album"))
                title += sep_title+song.sprint("album")
            else:
                self.box_album.hide()
        else:
            if song.sprint("artist")!="":
                l = self.current_song_widget["artist"]
                l.set_markup("<span size=\"large\"><i>"+utils.xmlescape(song.sprint("artist"))+"</i>"+"</span>")
                self.box_artist.show()
                if song.iradio:
                    self.box_artist.get_children()[1].hide()
                else:
                    self.box_artist.get_children()[1].show()
                text += sep+"<i>"+utils.xmlescape(song.sprint("artist"))+"</i>"
                title += sep_title+song.sprint("artist")
            else:
                self.box_artist.hide()


            if song.sprint("album")!="":
                l = self.current_song_widget["album"]
                l.set_markup("<span size=\"large\">"+utils.xmlescape(song.sprint("album"))+"</span>")
                self.box_album.show()
                if song.iradio:
                    self.box_album.get_children()[1].hide()
                else:
                    self.box_album.get_children()[1].show()
                text += sep+utils.xmlescape(song.sprint("album"))
                title += sep_title+song.sprint("album")
            else:
                self.box_album.hide()



        #Write current sont information in file for gaim 2.0 :)
        filename = os.path.join(os.path.expanduser("~"),".current-song")
        fileout = open(filename, "w")
        fileout.write(text)


        #Set the cover if exist
        self.set_album_current_cover(False)

        #Reset the cover but download it if not exist
        ThreadQueue.remove_task(self.thread_album_cover)
        self.thread_album_cover = ThreadQueue.add_task(self.set_album_current_cover)


        if config.get("osd","enable")=="true" and show_osd:
            self.osd.show_osd(self.current_song)

        title = "Listen  "+"\xe2\x99\xaa "+title+" "+" \xe2\x99\xaa "
        self.get_toplevel().set_title(title)

        if self.dbus_notify!=None and config.get("setting","notification")=="true" and show_osd:
            cover_path = song.get_album_cover_path()
            cover = ""
            if os.path.exists(cover_path):
                pixbuf = gtk.gdk.pixbuf_new_from_file_at_size(cover_path,40,40)

                w, h = pixbuf.get_width(), pixbuf.get_height()
                cover = gtk.gdk.Pixbuf(gtk.gdk.COLORSPACE_RGB, True, 8, w + 2, h + 2)
                cover.fill(0x000000ff)
                pixbuf.copy_area(0, 0, w, h, cover, 1, 1)
                try:
                    cover_path = os.path.join(config.TMP_PATH+"/cover.png")
                    cover.save(cover_path, "png", {})
                except:pass
            self.dbus_notify.Notify("Listen", 0, cover_path,"\xe2\x99\xaa "+_("Listen now playing")+" \xe2\x99\xaa", text,"", {}, 4000)



    """
    Set the album cover of the current played song
    Add show the OSD
    """
    def set_album_current_cover(self,try_amazon=True):
        filename = self.current_song.get_album_cover(try_amazon)
        pixbuf = gtk.gdk.pixbuf_new_from_file_at_size(filename,75,75)

        """ If try amazon the call is in thread then use of idle_add """
        if try_amazon:
            gobject.idle_add(self.album_cover.set_from_pixbuf,pixbuf)
        else:
            self.album_cover.set_from_pixbuf(pixbuf)
        del pixbuf


    """
    Open window to change the album cover of the current song
    """
    def on_change_album_cover(self,btn):
        if self.current_song==None:
            return
        from misc_widget import AmazonWindow
        AmazonWindow(self.current_song)
        self.refresh_album_cover()

    def refresh_album_cover(self):
        filename = self.current_song.get_album_cover()
        pixbuf = gtk.gdk.pixbuf_new_from_file_at_size(filename,75,75)
        self.album_cover.set_from_pixbuf(pixbuf)
        del pixbuf


    def lastfm_hook(self,widget,type):
        import urllib
        def prepare(str):
            return urllib.quote(utils.filter_info_song(str).encode("utf-8"))
        url = "http://www.last.fm/music/"
        if type=="artist":
            utils.website(url+prepare(self.current_song.sprint("artist")))
        if type=="album":
            utils.website(url+prepare(self.current_song.sprint("artist"))+"/"+prepare(self.current_song.sprint("album")))


class SongTime(gtk.HBox):
    def __init__(self,player):
        gtk.HBox.__init__(self,0,6)
        self.player = player

        self.label_time = gtk.Label("00:00 "+_("of")+" 00:00")
        self.label_time.set_alignment(0.2,0.5)

        self.bar_avancement = gtk.HScale()
        self.bar_avancement.set_draw_value(False)
        self.bar_avancement.set_range(0,1000)
        self.bar_avancement.set_value(0)
        self.bar_avancement.connect("button_press_event", self.on_bar_avancement_press_cb)
        self.bar_avancement.connect("button_release_event", self.on_bar_avancement_release_cb)
        #time_box = gtk.HBox(0,6)
        self.pack_start(self.label_time,False,False)
        self.pack_start(self.bar_avancement)
        self.update_bar_avancement = 1
        self.duration = 0
        self.delete = False
        self.audioscrobbler_report = False
        gobject.timeout_add(1000, self.on_timeout)

    def stop(self):
        self.delete = True

    def set_duration(self,value):
        self.duration = value
        self.set_current_time(0)

    def on_timeout(self, *args):
        if self.update_bar_avancement == 1:
            pos = self.player.gst_player.get_position()
            if pos>=0:
                self.set_current_time(pos)
        return not self.delete

    def set_current_time(self,value):
        duration = self.duration
        #print duration
        if self.update_bar_avancement == 1:
            if duration==0:
                self.bar_avancement.set_range(0,1000)
                self.bar_avancement.set_value(1000)
            else :
                if value>=duration:
                    duration=value+1000
                self.bar_avancement.set_range(0,duration/1000)
                self.bar_avancement.set_value(value/1000)

        text  = "%d:%02d "%(value/60000, (value/1000)%60)+_("of")+" %d:%02d" % (duration/60000, (duration/1000)%60)
        self.label_time.set_label(text)

        if self.audioscrobbler_report and value >= min(duration/2, 240*1000):
            self.audioscrobbler_report = False
            self.player.audioscrobbler.add(self.player.current_song)

    def on_bar_avancement_press_cb(self,widget,event):
        self.update_bar_avancement = 0
        self.audioscrobbler_report = False

    def on_bar_avancement_release_cb(self,widget,event):
        if self.player.current_song!=None and self.player.current_song.iradio:
            self.update_bar_avancement = 1
            return
        value = self.bar_avancement.get_value()

        self.player.gst_player.seek(value*1000)
        self.update_bar_avancement = 1



class MmKeys(object):
    def __init__(self, player):
        self.__sigs = []
        self.player = player
        try: import mmkeys
        except:
            class F(object):
                handler_block = handler_unblock = lambda s, a: False
            self.__keys = F()
        else:
            self.__keys = mmkeys.MmKeys()
            self.__keys.connect("mm_prev", self.player.mm_previous)
            self.__keys.connect("mm_next", self.player.mm_next)
            self.__keys.connect('mm_stop', self.player.mm_play)
            self.__keys.connect("mm_playpause", self.player.mm_play)

    def block(self): map(self.__keys.handler_block, self.__sigs)
    def unblock(self): map(self.__keys.handler_unblock, self.__sigs)
