###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###


import string
import shutil
import os,os.path,stat
import urllib,locale
import config
import sre
import time
import gtk
import struct
import stock

def stock_init():
    import gtk
    factory = gtk.IconFactory()
    for fn in dir(stock):
        if fn.rfind("__")==-1:
            fn = getattr(stock,fn)
            pb = gtk.gdk.pixbuf_new_from_file(config.PIXMAP_DIR+fn+".png")
            factory.add(fn, gtk.IconSet(pb))
    factory.add_default()


TIP = gtk.Tooltips()
def set_tip(widget,text):
    TIP.set_tip(widget,text,text)

#Remove it when i finish to clean other code
def normalize_song_dict(dict):
    if not dict.has_key("duration") or dict["duration"]==None:
        dict["duration"]=0
    if not dict.has_key("title") or dict["title"]==None:
        dict["title"]=get_filename(dict["uri"])
    if not dict.has_key("artist") or dict["artist"]==None:
        dict["artist"]=""
    if not dict.has_key("album") or dict["album"]==None:
        dict["album"]=""
    if not dict.has_key("tracknr") or dict["tracknr"]==None:
        dict["tracknr"]=0
    return dict
"""
SQLITE simple un/escape caracter
"""
def sqlescape(str ):
    return string.replace(str,"'","''")

def sqlunescape(str ):
    return string.replace(str,"''","'")

def xmlescape(str):
    """Escape a string in a manner suitable for XML/Pango."""
    return str.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;")

def xmlunescape(str):
    """Unescape a string in a manner suitable for XML/Pango."""
    return str.replace("&lt;", "<").replace("&gt;", ">").replace("&amp;", "&")



"""
filename manipulation
"""
def get_protocol(uri):
    if uri.rfind("://")==-1:
        return ""
    protocol = uri[:uri.index("://")+3]
    return protocol

def get_path(uri):
    if uri.rfind("://")==-1:
        return uri
    return uri[uri.index("://")+3:]

def get_ext(uri,complete=True):
    if uri.rfind(".")==-1:
        return ""
    if complete:
        return uri[uri.rindex("."):].lower()
    else:
        return uri[uri.rindex(".")+1:].lower()

def get_filename(uri):
    if uri.rfind(":/")==-1:
        return uri
    return uri[uri.rindex("/")+1:]

def uri_to_path(uri):
    return get_path(uri)

def convert_to_uri(uri):

    protocol = get_protocol(uri)
    uri = uri_to_path(uri)
    hote = ""
    if protocol!="file://":
        split_uri = uri.split('/')
        #print split_uri
        if len(split_uri)>0:
            hote = split_uri[0]
            del split_uri[0]
        uri = "/".join(split_uri)
    else:
        uri = uri_to_path(uri)
    uri = uri.encode('utf-8')
    uri = urllib.quote(uri)
    #print protocol," - ",hote," - ",uri
    uri = protocol+hote+"/"+uri
    return uri

""" Remove no need str for web service manipulation """
def filter_info_song(str):
    #FIXME: make preference dialog for this
    str = str.lower()
    filters = config.get("webservice","filter").split("<###>")
    for filter in filters:
        str = str.replace(filter.lower(),"")
        """import re
        p = re.compile(filter)
        str = p.subn("",str)[0]"""
    return str

def move_to_trash(path):
    path = os.path.realpath(os.path.expanduser(path))
    if not os.path.exists(path): return False
    #find the trash folder
    home_dir = os.path.realpath(os.path.expanduser("~"))
    dirs_name = path.split("/")
    dirs_name = filter(lambda name: name!="",dirs_name)
    trash_dir = None
    r = range(0,len(dirs_name))
    r.reverse()
    for i in r:
        tmp_path = os.path.realpath("/"+"/".join(dirs_name[:i]))
        if tmp_path == home_dir:
            trash_dir = home_dir+"/.Trash"
            break
        elif os.path.ismount(tmp_path):
            trash_dir = tmp_path+"/.Trash-"+os.environ.get("USER")
            break
        else: continue
    if not trash_dir:
        return False
    if not os.path.exists(trash_dir):
        try:os.makedirs(trash_dir,"0777")
        except: return False

    if path.rfind("/")!=-1:
        filename = path[path.rindex("/")+1:]
    try: shutil.move(path,trash_dir+"/"+filename)
    except: return False
    else: return True

def str_size(nb,average=0,base=1024):
    if average!=0:
        average +=1
    nb = float(nb)
    size_format = ""
    if base==1024:
        units = _("B KiB MiB GiB").split()
    else:
        units = _("B KB MB GB").split()
    for size_format in units:
        if len("%d"%int(nb))<=3:
            break
        nb = float(nb)/float(base)
    nb = "%f"%round(nb,1)
    nb = nb[:nb.rfind(".")+average]+size_format
    return nb

def duration_to_string(value):
    duration = "%02d:%02d" % ((value/60000)%60, (value/1000)%60)
    if value/60000/60>=1:
        duration = "%d:"%(value/60000/60)+duration
    return duration

""" Parse a date and return a time object """
""" Date like  Thu, 02 02 2005 10:25:21 ... """
def strdate_to_time(date):
    #removing timezone
    c = date[-5:-4]
    if (c == '+') or (c == '-'):
        date = date[:-6]

    #FIXME : don't remove use it in strptime
    c = date[-3:]
    if c in ["GMT","CST","EST","PST","EDT","PDT"]:
        date = date[:-3]

    #Remove day because some field have incorrect string
    c = date.rfind(",")
    if c!=-1:
        date = date [c+1:]
    date = date.strip()

    #trying multiple date formats
    new_date = None

    #Set locale to C to parse date
    locale.setlocale(locale.LC_TIME, "C")

    formats = ["%d %b %Y %H:%M:%S",#without day, short month
                "%d %B %Y %H:%M:%S",#without day, full month
                "%d %b %Y",#only date , short month
                "%d %B %Y",#only date , full month
                "%b %d %Y %H:%M:%S",#without day, short month
                "%B %d %Y %H:%M:%S",#without day, full month
                "%b %d %Y",#only date , short month
                "%B %d %Y",#only date , full month
                ]
    for format in formats:
        try:
            new_date = time.strptime(date,format)
        except ValueError:
            continue

    locale.setlocale(locale.LC_TIME, '')
    if new_date is None:
        return ""

    return time.mktime(new_date)

"""
Playlist manipulation
"""
def export_playlist(filename,list_song):
    m3u = "#EXTM3U\n"
    for song in list_song:
        m3u += "#EXTINF:%d,%s"%(song.get_property("duration")/1000,song.sprint("title"))+"\n"
        m3u += song.get_path()+"\n"

    fileout = open(filename, "w")
    fileout.write(m3u)

def import_playlist(filename,force_format=None):
    #FIXME: Use gnomevfs
    list_uri = []
    if get_protocol(filename)=="file://":
        array_line = file(get_path(filename)).readlines()
    else:
        opener = urllib.FancyURLopener()
        f = opener.open(filename)
        array_line = f.read()
        array_line = array_line.split("\n")

    if get_ext(filename) == ".m3u" or force_format==".m3u":
        for line in array_line:
            if not line.startswith("#"):
                list_uri.append(line.replace("\n",""))
    if get_ext(filename) == ".pls" or force_format==".pls":
        for line in array_line:
            if line.lower().startswith("file") and line.find("=")!=-1:
               list_uri.append(line[:line.find("=")].replace("\n",""))
    return list_uri



""" Convert apple timestamp for ipod """
def time_unix_to_mac(time):
    return time+2082844800
def time_mac_to_unix(time):
    return time-2082844800


""" Remove accents if unicodedata module is present """
#http://wikipython.flibuste.net/moin.py/JouerAvecUnicode
_reptable = {}
def _fill_reptable():
    _corresp = [
        (u"A",  [0x00C0,0x00C1,0x00C2,0x00C3,0x00C4,0x00C5,0x0100,0x0102,0x0104]),
        (u"AE", [0x00C6]),
        (u"a",  [0x00E0,0x00E1,0x00E2,0x00E3,0x00E4,0x00E5,0x0101,0x0103,0x0105]),
        (u"ae", [0x00E6]),
        (u"C",  [0x00C7,0x0106,0x0108,0x010A,0x010C]),
        (u"c",  [0x00E7,0x0107,0x0109,0x010B,0x010D]),
        (u"D",  [0x00D0,0x010E,0x0110]),
        (u"d",  [0x00F0,0x010F,0x0111]),
        (u"E",  [0x00C8,0x00C9,0x00CA,0x00CB,0x0112,0x0114,0x0116,0x0118,0x011A]),
        (u"e",  [0x00E8,0x00E9,0x00EA,0x00EB,0x0113,0x0115,0x0117,0x0119,0x011B]),
        (u"G",  [0x011C,0x011E,0x0120,0x0122]),
        (u"g",  [0x011D,0x011F,0x0121,0x0123]),
        (u"H",  [0x0124,0x0126]),
        (u"h",  [0x0125,0x0127]),
        (u"I",  [0x00CC,0x00CD,0x00CE,0x00CF,0x0128,0x012A,0x012C,0x012E,0x0130]),
        (u"i",  [0x00EC,0x00ED,0x00EE,0x00EF,0x0129,0x012B,0x012D,0x012F,0x0131]),
        (u"IJ", [0x0132]),
        (u"ij", [0x0133]),
        (u"J",  [0x0134]),
        (u"j",  [0x0135]),
        (u"K",  [0x0136]),
        (u"k",  [0x0137,0x0138]),
        (u"L",  [0x0139,0x013B,0x013D,0x013F,0x0141]),
        (u"l",  [0x013A,0x013C,0x013E,0x0140,0x0142]),
        (u"N",  [0x00D1,0x0143,0x0145,0x0147,0x014A]),
        (u"n",  [0x00F1,0x0144,0x0146,0x0148,0x0149,0x014B]),
        (u"O",  [0x00D2,0x00D3,0x00D4,0x00D5,0x00D6,0x00D8,0x014C,0x014E,0x0150]),
        (u"o",  [0x00F2,0x00F3,0x00F4,0x00F5,0x00F6,0x00F8,0x014D,0x014F,0x0151]),
        (u"OE", [0x0152]),
        (u"oe", [0x0153]),
        (u"R",  [0x0154,0x0156,0x0158]),
        (u"r",  [0x0155,0x0157,0x0159]),
        (u"S",  [0x015A,0x015C,0x015E,0x0160]),
        (u"s",  [0x015B,0x015D,0x015F,0x01610,0x017F]),
        (u"T",  [0x0162,0x0164,0x0166]),
        (u"t",  [0x0163,0x0165,0x0167]),
        (u"U",  [0x00D9,0x00DA,0x00DB,0x00DC,0x0168,0x016A,0x016C,0x016E,0x0170,0x172]),
        (u"u",  [0x00F9,0x00FA,0x00FB,0x00FC,0x0169,0x016B,0x016D,0x016F,0x0171]),
        (u"W",  [0x0174]),
        (u"w",  [0x0175]),
        (u"Y",  [0x00DD,0x0176,0x0178]),
        (u"y",  [0x00FD,0x00FF,0x0177]),
        (u"Z",  [0x0179,0x017B,0x017D]),
        (u"z",  [0x017A,0x017C,0x017E])
        ]
    global _reptable
    for repchar,codes in _corresp :
        for code in codes :
            _reptable[code] = repchar
_fill_reptable()
def remove_accents(s):
    """Suppression des accents et autres marques.
    @param s: le texte a nettoyer.
    @type s: str ou unicode
    @return: le texte nettoye de ses marques diacritiques.
    @rtype: unicode
    """
    if isinstance(s,str) :
        s = unicode(s,"utf8","replace")
    res = []
    for c in s :
        res.append(_reptable.get(ord(c),c))
    return u"".join(res)

""" du function in python """
def du(dir, files={}):
    S_IFMT = 0170000
    S_IFDIR = 0040000
    tsz = 0

    try: fns = os.listdir(dir)
    except: return 0

    if not files.has_key(dir): files[dir] = {}
    d = files[dir]

    for fn in fns:
        fn = "%%s%s%%s" % os.sep % (dir, fn)

        try:
            info = os.lstat(fn)
        except:
            continue

        if info[stat.ST_MODE] & S_IFMT == S_IFDIR:
            sz = du(fn, files) + long(info[stat.ST_SIZE])
        else:
            sz = info[stat.ST_SIZE]
        d[fn] = sz
        tsz = tsz + sz
    return tsz

###
#Code below grab from Quodlibet, Copyright 2004-2005 Joe Wreschnig, Michael Urman
###
def ctypes_init():
    try: import ctypes
    except ImportError: pass
    else:
        ctypes.c_int8 = ctypes.c_byte
        ctypes.c_uint8 = ctypes.c_ubyte
        from ctypes import c_short, c_int, c_long, c_longlong
        for kind in [c_short, c_int, c_long, c_longlong]:
            if ctypes.sizeof(kind) == 2: ctypes.c_int16 = kind
            elif ctypes.sizeof(kind) == 4: ctypes.c_int32 = kind
            elif ctypes.sizeof(kind) == 8: ctypes.c_int64 = kind
        from ctypes import c_ushort, c_uint, c_ulong, c_ulonglong
        for kind in [c_ushort, c_uint, c_ulong, c_ulonglong]:
            if ctypes.sizeof(kind) == 2: ctypes.c_uint16 = kind
            elif ctypes.sizeof(kind) == 4: ctypes.c_uint32 = kind
            elif ctypes.sizeof(kind) == 8: ctypes.c_uint64 = kind
def url_hook(widget,site):
    website(site)

def website(site):
    site = site.replace("\\", "\\\\").replace("\"", "\\\"")
    for s in (["gnome-open","sensible-browser"] +
              os.environ.get("BROWSER","").split(":")):
        if iscommand(s):
            if "%s" in s:
                s = s.replace("%s", '"' + site + '"')
                s = s.replace("%%", "%")
            else: s += " \"%s\"" % site
            if os.system(s + " &") == 0: return True
    else: return False

def iscommand(s):
    """True if 's' exists in the user's path, or is a fully-qualified
    existing path."""

    if s == "" or os.path.sep in s:
        return os.path.exists(s)
    else:
        s = s.split()[0]
        for p in os.environ["PATH"].split(os.path.pathsep):
            p2 = os.path.join(p, s)
            if os.path.exists(p2): return True
        else: return False

def re_esc(str):
    return "".join(map(
        lambda a: (a in "/.^$*+?{,}\\[]|()<>#=!:" and "\\" + a) or a, str))
sre.escape = re_esc

# http://developer.gnome.org/doc/API/2.0/glib/glib-running.html
if "G_FILENAME_ENCODING" in os.environ:
    fscoding = os.environ["G_FILENAME_ENCODING"].split(",")[0]
    if fscoding == "@locale": fscoding = locale.getpreferredencoding()
elif "G_BROKEN_FILENAMES" in os.environ:
    fscoding = locale.getpreferredencoding()
else: fscoding = "utf-8"

def fsdecode(s):
    """Decoding a string according to the filesystem encoding."""
    if isinstance(s, unicode): return s
    else: return decode(s, fscoding)

def fsencode(s):
    """Encode a string according to the filesystem encoding, replacing
    errors."""
    if isinstance(s, str): return s
    else: return s.encode(fscoding, 'replace')

def decode(s, charset="utf-8"):
    """Decode a string; if an error occurs, replace characters and append
    a note to the string."""
    try: return s.decode(charset)
    except UnicodeError:
        return s.decode(charset, "replace") + " " + _("[Invalid Encoding]")

def encode(s, charset="utf-8"):
    """Encode a string; if an error occurs, replace characters and append
    a note to the string."""
    try: return s.encode(charset)
    # FIXME: Can *this* happen?
    except UnicodeError:
        return (s + " " + _("[Invalid Encoding]")).encode(charset, "replace")


