# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###



import os,gtk

try:
    import dists    
except ImportError: 
    #Started from source directory
    DATA_DIR = os.getcwd()+"/../data/" 
    GETTEXT_DIR = os.getcwd()+"/../po/"
else:
    DATA_DIR = dists.DATA_DIR
    GETTEXT_DIR  = dists.LOCALE_DIR


VERSION = "0.5"

APPNAME = "Music Player Listen"
GETTEXT_APP="listen"

if False:
    CONFIG_DIR  = os.path.expanduser("~/.listen-test/")
else:
    CONFIG_DIR  = os.path.expanduser("~/.listen/")
if not os.path.isdir(CONFIG_DIR+"/cover"):
    os.makedirs(CONFIG_DIR+"/cover")
    
if not os.path.isdir(os.path.expanduser("~/.lyrics")):
    os.makedirs(os.path.expanduser("~/.lyrics"))
    
CONFIG_FILE  = os.path.join(CONFIG_DIR, "config")
TAG_COMPLETITION_FILE  = os.path.join(CONFIG_DIR, "tag_completition")

TMP_PATH = "/tmp/listen/"
if not os.path.isdir(TMP_PATH):
    os.makedirs(TMP_PATH)

PIXMAP_DIR = DATA_DIR+"/img/"


COVER_SIZE = {"x":70,"y":70}
COVER_SAVE_SIZE = {"x":240,"y":240}
BROWSER_COVER_SIZE = {"x":25,"y":25}

WEBSERVICE_CACHE_EXPIRATION = 1000*60*60*6 #6 hour

AUTOSAVE_TIMEOUT = 1000*60*5 # 5min

SHOW_EXT_ON_STARTUP = False

IMPORT_SUBMIT = 200
SONG_POPULATE = 500
BROWSER_POPULATE = 1000000000000000000000
CONTEXT_SONG_NUMBER = 20
TIMEOUT_SHOW_COVER = 1000

WIKIPEDIA_HISTORY_LEN = 20

DEFAULT_COVER = PIXMAP_DIR+"listen_cover.png"
DEFAULT_COVER_PIXBUF = gtk.gdk.pixbuf_new_from_file_at_size(DEFAULT_COVER,40,40)
DEFAULT_COVER_PIXBUF_BIG = gtk.gdk.pixbuf_new_from_file_at_size(DEFAULT_COVER,COVER_SIZE["x"],COVER_SIZE["y"])
DEFAULT_COVER_PIXBUF_BROWSER = gtk.gdk.pixbuf_new_from_file_at_size(DEFAULT_COVER,BROWSER_COVER_SIZE["x"],BROWSER_COVER_SIZE["y"])

AUTHORS = """
Mehdi Abaakouk <theli48@gmail.com>
Joe Wreschnig <piman@sacredchao.net>
Ed Catmur <ed@catmur.co.uk>
Michael Urman
Ton van den Heuvel
Flavio Gargiulo
Gustavo J. A. M. Carneiro
Eduardo Gonzalez
Joshua Kwan <joshk@triplehelix.org>
Micah Dowty <micah@navi.cx>
Lee Willis <lee@leewillis.co.uk>
Mark Pilgrim
"""
TRANSLATORS = """
Ahmad Farghal 
booxter 
Sayan Riju Chakrabarti 
Mehdi Abaakouk 
Toni Hermoso Pulido 
Martin Sourada 
Martin Hansen 
fabbaz 
conor 
conor 
Paul Williams 
Carlos 
Hendrik Luup 
Ilkka Tuohela 
Tao75 
Alex Vazquez 
Dösi
McKenzie 
Tetsuya 
Earthfall 
viuks 
Hans Cats 
JasperV 
Amanpreet Singh Alam 
kaito takahashi 
Hugo Doria 
Miguel GraÃ§a Oliveira 
Razvan T. Coloja 
Ravsh 
LukÃ¡Å¡ LalinskÃ½ 
Ð Ð°Ð´Ð¾Ð¼Ð¸Ñ ÐÐ°ÐºÐ¾Ð²ÑÐµÐ²Ð¸Ñ 
Daniel Nylander 
Osman KOCAK 
oleksandr korneta 
scubajeff 
"""

