# -*- coding: utf-8 -*-
# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
#
###

import stock

from widget.lastfm_station_view import LastfmWidget
from source import Source,SourceItem

class LastFmItem(SourceItem):
    stock = stock.SRC_LASTFM
    label = _("Last.fm Station")
    widget_klass = LastfmWidget
    config_code = "lastfmradio"

class LastFmRadioSource(Source):
    PLUGIN_NAME = "Lastfm Player"
    PLUGIN_DESC = _("Search and play music from the last.fm radio")

    display_index = 55
    def __init__(self):
        Source.__init__(self)
        self.items = [ LastFmItem() ]   

    def save(self):
        self.items[0].widget.save_config()
