# -*- coding: utf-8 -*-
# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
#
###


import gtk

from config import config

from helper import Dispatcher
from player import Player

class PlayerPlaylistControl(gtk.HBox):
    def __init__(self,playlist):
        super(PlayerPlaylistControl,self).__init__(False,3)

        def build_btn(label,func,stock=None,icon_name=None,type=gtk.Button):
            b = type()
            if stock:
                cont = gtk.image_new_from_stock(stock, gtk.ICON_SIZE_BUTTON)
            elif icon_name:
                cont = gtk.image_new_from_icon_name(icon_name, gtk.ICON_SIZE_BUTTON)
            else:
                cont = gtk.Label(label)
                cont.set_alignement(0,0.5)
            b.add(cont)
            b.id_click = b.connect("clicked",func)
            b.set_tooltip_text(label)
            b.set_size_request(36,-1)
            b.show_all()
            return b
        
        self.pack_start(build_btn(_("Save playlist"),playlist.save_to_library,stock=gtk.STOCK_SAVE),False,False)
        self.pack_start(build_btn(_("Clear playlist"),playlist.clear,stock=gtk.STOCK_CLEAR),False,False)
        self.pack_start(build_btn(_("Shuffle playlist"),playlist.random_reorder,icon_name="stock_shuffle"),False,False)
        self.pack_start(build_btn(_("Repeat playlist mode"),playlist.repeat,icon_name="stock_repeat",type=gtk.ToggleButton),False,False)

        self.btn_repeat = self.get_children()[3]
        if config.getboolean("setting","repeat_mode"):
            self.btn_repeat.set_active(True)
        
        config.connect("config-changed",self.__config_changed)
        
    def __config_changed(self, helper, section, option, value):
        if section=="setting":
            if option == "repeat_mode":
                self.btn_repeat.handler_block(self.btn_repeat.id_click)
                self.btn_repeat.set_active( value=="true" )
                self.btn_repeat.handler_unblock(self.btn_repeat.id_click)

class VolumeSlider(gtk.VolumeButton):
    def __init__(self):
        gtk.VolumeButton.__init__(self)
        self.set_property("size",gtk.ICON_SIZE_BUTTON)
        self.set_relief(gtk.RELIEF_NORMAL)
        self.connect("value-changed",self.__volume_changed)
        volume = float(config.get("player","volume"))
        self.change_volume(None,volume)
        Dispatcher.connect("volume",self.change_volume)
        self.show_all()

    def change_volume(self,helper,value):
        self.set_value(value)
        self.__volume_changed()


    def __volume_changed(self,*args):
        val = self.get_value()
        val = (2 ** val) - 1
        config.set("player","volume","%f"%val)
        Player.volume = val







