# -*- coding: utf-8 -*-
# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
#
###

import gtk
import stock
from config import config
 
from widget.misc import SimpleMenu,SimpleFontDialog

class HeaderMenu(SimpleMenu):
    def __init__(self,conf_prefix,visible_column=True,configure=True,font=True,font_append=""):
        super(HeaderMenu,self).__init__()
        self.conf_prefix = conf_prefix  
        self.font_append = font_append
        self.visible_column = visible_column
        self.font = font

        self.set_take_focus(False)

        #if visible_column:
        #    self.insert_item(self.visible_column,stock.VISIBLE_COLUMN)

        #if configure:
        #    self.insert_item(self.configure,stock.CONFIGURE)


        self.show_all()

    def configure(self,w):
        pass

    def open_font_dialog(self,*args,**kwargs):
        SimpleFontDialog(self.conf_prefix+self.font_append)        

    def popup(self,tree):
        for child in self.get_children():
            self.remove(child)

        def save_check(widget,sect,attr):
            if widget.get_property("active"):
                config.set(sect,attr,"true")
            elif len([ col for col in tree.get_columns() if col.get_visible() ]) >= 2:
                config.set(sect,attr,"false")
        

        for _pos, tag, label in tree.get_columns_info():
            try: config.get("song_view",self.conf_prefix+"_"+tag)
            except: 
                visible = tree.get_default_visibility(tag)
                if visible: visible = "true"
                else: visible = "false"
                config.set("song_view",self.conf_prefix+"_"+tag,visible)
                config.set("song_view",self.conf_prefix+"_"+tag+"_width",tree.get_default_width(tag))
                config.set("song_view",self.conf_prefix+"_"+tag+"_order",tree.get_default_position("order"))

            item = gtk.CheckMenuItem(label)
            item.set_active(config.getboolean("song_view",self.conf_prefix+"_"+tag))
            item.connect("toggled",save_check,"song_view",self.conf_prefix+"_"+tag)
            self.append(item)

        self.append_sep()
        self.insert_item(None,self.open_font_dialog,stock.CHANGE_FONT)
        self.show_all()
        super(HeaderMenu,self).popup(None,None,None,0,gtk.get_current_event_time())       
        
    
