# -*- coding: utf-8 -*-
# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
#
###


import gtk
import random

from config import config
from misc import Label, SimpleVBox, SimpleHBox
from lastfm_service import lastfm_info
from library import ListenDB
from player import Player

class SpinHBox(SimpleHBox):
    def __init__(self,*args,**kargs):
        super(SpinHBox,self).__init__(*args,**kargs)
        self.set_child_packing(self.get_children()[0],True,True,0,gtk.PACK_START)

class DynamicPlaylist(object):
    def __init__(self,playlist):
        self.playlist = playlist
        
        
        
        self.widget = gtk.VBox()
        
        self.btnpopulate = gtk.Button(_("Repopulate"))
        self.btnpopulate.connect("clicked",self.populate)
        active = gtk.CheckButton(_("Enable dynamic mode"))
        clear = gtk.CheckButton(_("Remove played track"))
        clear.set_active(config.get("dynamic_mode","remove_played")=="true")
        
        hbox = gtk.HBox(False,6)
        hbox.pack_start(active,True,True)
        hbox.pack_start(self.btnpopulate,False,False)

        upcoming = gtk.SpinButton(gtk.Adjustment(float(config.get("dynamic_mode","track_upcoming")),0,100,1),1.0)
        upcoming.connect("value-changed",self.spin_change,"dynamic_mode","track_upcoming")
        keep = gtk.SpinButton(gtk.Adjustment(float(config.get("dynamic_mode","played_show")),0,1000,1),1.0)
        keep.connect("value-changed",self.spin_change,"dynamic_mode","played_show")
        append = gtk.SpinButton(gtk.Adjustment(float(config.get("dynamic_mode","track_append")),0,100,1),1.0)
        append.connect("value-changed",self.spin_change,"dynamic_mode","track_append")
        
        self.play_show_spin = SpinHBox(Label(_("Played track to show:"),align=(0,0.5)),keep,spacing=6)
        self.play_show_spin.set_sensitive(config.get("dynamic_mode","remove_played")=="true")
        
        s2 = SpinHBox(Label(_("Upcoming track:"),align=(0,0.5)),upcoming,spacing=6)
        s3 = SpinHBox(Label(_("Track to append:"),align=(0,0.5)),append,spacing=6)
        box = SimpleVBox(clear,self.play_show_spin,s2,s3)
        self.align = gtk.Alignment()
        self.align.add(box)
        self.align.set_padding(0,0,24,0)
        
        self.widget.pack_start(hbox,False,False)
        self.widget.pack_start(self.align,False,False)
        
        title = _("Dynamic:")+" "
        if config.get("dynamic_mode","enable")=="true":
            title = "<b>"+title+_("On")+"</b>"
            active.set_active(True)
            self.align.set_sensitive(True)
        else:
            title += _("Off")
            active.set_active(False)
            self.align.set_sensitive(False)
            
        self.widget.show_all()
        self.widget.set_no_show_all(True)
        if config.get("dynamic_mode","expanded")!="true" :
            self.widget.hide()
            
        self.expander = gtk.Expander(title)
        self.expander.set_expanded(config.get("dynamic_mode","expanded")=="true")
        self.expander.connect("button_press_event",self.on_expand_clic,active)
        self.expander.set_use_markup(True)
        self.align_expander = gtk.Alignment(0,1,0,0) 
        self.align_expander.add(self.expander)
        
        
        #Connect signal
        self.expander.connect("notify::expanded",self.expand) 
        active.connect("clicked",self.activate)   
        clear.connect("clicked",self.clear)
        
        Player.connect("new_song",self.on_new_song)
        
        
        self.blacklist_songs = []
        
    def populate(self,*args,**kwargs):
        self.on_new_song(Player,Player.song,True)

    def spin_change(self,spin,section,attribut):
            config.set(section,attribut,spin.get_value())    
            
    def clear(self,w):
        if w.get_active():
            config.set("dynamic_mode","remove_played","true")
            self.play_show_spin.set_sensitive(True)
        else:
            config.set("dynamic_mode","remove_played","false")
            self.play_show_spin.set_sensitive(False)

    def on_expand_clic(self,w,event,active):
        if event.button == 3:
            active.clicked()
            
    def activate(self,w):
        title = _("Dynamic:")+" "    
        if w.get_active():
            config.set("dynamic_mode","enable","true")
            title = "<b>"+title+_("On")+"</b>"
            self.align.set_sensitive(True)
            self.btnpopulate.set_sensitive(True)
        else:
            config.set("dynamic_mode","enable","false")
            title += _("Off")
            self.align.set_sensitive(False)
            self.btnpopulate.set_sensitive(False)
        self.expander.set_label(title)
            
    def expand(self,expander,*param):
        if expander.get_expanded():
            config.set("dynamic_mode","expanded","true") 
            self.widget.show()
        else:
            config.set("dynamic_mode","expanded","False")
            self.widget.hide()    
        
    def get_widget(self):
        return self.widget
    
    def get_expander(self):
        return self.align_expander
    
        
    def on_new_song(self,player,song,forced=False):
        if config.get("dynamic_mode","enable")=="true":
            self.btnpopulate.set_sensitive(False)
            if config.get("setting","offline") == "true" :
                self.whitemagic_playlist_fill([],song,forced)
            else:
                lastfm_info.get_related(song.get_str("artist"),self.whitemagic_playlist_fill,song,forced,func_fail=self.whitemagic_playlist_fill,func_fail_args=([],song,forced))
        
    def whitemagic_playlist_fill(self,items,song,forced=False):
        if config.get("dynamic_mode","enable")=="false": return
        
        artists = [ i["name"].strip().lower() for i in items[:20] ]
        songs = ListenDB.get_songs("local")
        if len(artists)>0:
            songs = filter(lambda song : song.get_str("artist").strip().lower() in artists,songs)
        current_song = [row[0].get("uri") for row in self.playlist.get_model()]
        
        def get_random_song(songs,nb):
            songs = filter(lambda song : song.get("uri") not in current_song,songs)
            songs = filter(lambda song : song.get("uri") not in self.blacklist_songs,songs)
    
            random.shuffle(songs)
    
            artists = {}
            for song in songs:
                artists[song.get("artist")]=song
    
            songs = [( song.get("#playcount",0) - song.get("#skipcount",0), song) for _artist ,song in artists.iteritems()]
            
            songs = songs[:max(200,len(songs)*10/100)]
            songs.sort()
            
            songs = songs[:nb]
            songs = [song[1] for song in songs]
            return songs
        
        
        nb_track_append = int(float(config.get("dynamic_mode","track_append")))
        songs = get_random_song(songs,nb_track_append)
        while len(songs)<nb_track_append:
            tmp_songs = get_random_song(ListenDB.get_songs("local"),nb_track_append-len(songs))
            songs.extend(tmp_songs)

        if len(songs)>0:
            nb_played_show = int(float(config.get("dynamic_mode","played_show")))
            if config.get("dynamic_mode","remove_played")=="true" and self.playlist.current_item >= nb_played_show:
                for i in range(0,self.playlist.current_item-nb_played_show):
                    self.playlist.remove((0,))
            nb = 0
            if forced:
                nb_track_upcoming = int(100000)
            else:
                nb_track_upcoming = int(float(config.get("dynamic_mode","track_upcoming")))
            length_model = len(self.playlist.get_model())
            if length_model:
                reste = (length_model-self.playlist.current_item)+1
            else:
                reste = 0
            if reste < nb_track_upcoming:
                nb = nb_track_upcoming - reste
                if nb > nb_track_append : nb=nb_track_append
                if nb > 0:
                    if nb > len(songs): nb = len(songs)
                    for i in range(0,nb):
                        self.blacklist_songs.append(songs[i].get("uri"))
                        self.playlist.add_song(songs[i])
    
                    while len(self.blacklist_songs)>150:
                        self.blacklist_songs.pop(0)
        self.btnpopulate.set_sensitive(self.align.get_property("sensitive"))
        
