# -*- coding: utf-8 -*-
# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
#
###

import gtk
 
class ColumnBase(gtk.TreeViewColumn):
    def __init__(self, r, tag, title, width):
        self.tag = tag
        self.title = title
        if width<10:
            width = 10
 
        super(ColumnBase,self).__init__(None,r)
        self.set_sizing(gtk.TREE_VIEW_COLUMN_FIXED)
        self.set_fixed_width(width)
        self.set_resizable(True)
        self.set_clickable(True)
        self.set_max_width(400)
        self.set_min_width(10)
        label = gtk.Label(title)
        self.set_widget(label)
        label.show()
    
    def get_current_width(self):
        if self.get_width() >= 10:
            return self.get_width()
        else:
            return self.get_fixed_width()

    def get_button(self):
        return self.get_widget().get_ancestor(gtk.Button)

    def set_font(self,new_font=None):
        pass


class TextColumn(ColumnBase):
    def __init__(self, tag, title, width):
        self.r = gtk.CellRendererText()
        self.set_font()
        
        super(TextColumn,self).__init__(self.r, tag, title, width)
        self.set_cell_data_func(self.r, self.__set_text)

    def set_font(self,new_font=None):
        self.r.set_property("font",new_font) 

    def __set_text(self,column, cell, model, iter):
        song = model[iter][0]
        text = song.get_str(self.tag).replace("<###>",", ")
        cell.set_property("text",text)

class ProgressColumn(ColumnBase):
    def __init__(self, tag, title, width):
        r = gtk.CellRendererProgress()
        super(ProgressColumn,self).__init__(r, tag, title, width)
        self.set_cell_data_func(r, self.__set_text)

    def __set_text(self, column, cell, model, iter):
        value = model[iter][0].get(self.tag)
        if value == 100:
            text = _("Downloaded")
        elif value == -1:
            text = _("Queueing")
        elif value == -2:
            text = _("Not downloaded")
        else:
            text = str(value)+"%"
        if value < 0:
            value = 0
        cell.set_property("text",text)
        cell.set_property("value",value)

TAG_COLUMNS = {
        "#progress":ProgressColumn
        }
