// generated by Fast Light User Interface Designer (fluid) version 1.0300

#include "ADnoteUI.h"
//Copyright (c) 2002-2005 Nasca Octavian Paul
//License: GNU GPL version 2 or later
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

void ADvoicelistitem::cb_voicevolume_i(Fl_Value_Slider* o, void*) {
  pars->VoicePar[nvoice].PVolume=(int)o->value();
}
void ADvoicelistitem::cb_voicevolume(Fl_Value_Slider* o, void* v) {
  ((ADvoicelistitem*)(o->parent()->parent()->user_data()))->cb_voicevolume_i(o,v);
}

void ADvoicelistitem::cb_voiceresonanceenabled_i(Fl_Check_Button* o, void*) {
  pars->VoicePar[nvoice].Presonance=(int)o->value();
}
void ADvoicelistitem::cb_voiceresonanceenabled(Fl_Check_Button* o, void* v) {
  ((ADvoicelistitem*)(o->parent()->parent()->user_data()))->cb_voiceresonanceenabled_i(o,v);
}

void ADvoicelistitem::cb_voicelfofreq_i(Fl_Value_Slider* o, void*) {
  pars->VoicePar[nvoice].FreqLfo->Pintensity=(int)o->value();
}
void ADvoicelistitem::cb_voicelfofreq(Fl_Value_Slider* o, void* v) {
  ((ADvoicelistitem*)(o->parent()->parent()->user_data()))->cb_voicelfofreq_i(o,v);
}

void ADvoicelistitem::cb_voicepanning_i(WidgetPDial* o, void*) {
  pars->VoicePar[nvoice].PPanning=(int) o->value();
}
void ADvoicelistitem::cb_voicepanning(WidgetPDial* o, void* v) {
  ((ADvoicelistitem*)(o->parent()->parent()->user_data()))->cb_voicepanning_i(o,v);
}

void ADvoicelistitem::cb_detunevalueoutput_i(Fl_Value_Output* o, void*) {
  o->value(getdetune((pars->VoicePar[nvoice].PDetuneType==0)?(pars->GlobalPar.PDetuneType) : (pars->VoicePar[nvoice].PDetuneType),0,pars->VoicePar[nvoice].PDetune)*pars->getBandwidthDetuneMultiplier());
}
void ADvoicelistitem::cb_detunevalueoutput(Fl_Value_Output* o, void* v) {
  ((ADvoicelistitem*)(o->parent()->parent()->user_data()))->cb_detunevalueoutput_i(o,v);
}

void ADvoicelistitem::cb_voicedetune_i(Fl_Slider* o, void*) {
  pars->VoicePar[nvoice].PDetune=(int)o->value()+8192;
detunevalueoutput->do_callback();
}
void ADvoicelistitem::cb_voicedetune(Fl_Slider* o, void* v) {
  ((ADvoicelistitem*)(o->parent()->parent()->user_data()))->cb_voicedetune_i(o,v);
}

void ADvoicelistitem::cb_noiselabel_i(Fl_Box* o, void*) {
  if (pars->VoicePar[nvoice].Type==0) {
  o->hide();
  voiceresonanceenabled->activate();
  detunevalueoutput->activate();
  voicedetune->activate();
  voicelfofreq->activate();
  voiceoscil->activate();
} else {
  o->show();
  voiceresonanceenabled->deactivate();
  detunevalueoutput->deactivate();
  voicedetune->deactivate();
  voicelfofreq->deactivate();
  voiceoscil->deactivate();
};
}
void ADvoicelistitem::cb_noiselabel(Fl_Box* o, void* v) {
  ((ADvoicelistitem*)(o->parent()->parent()->user_data()))->cb_noiselabel_i(o,v);
}

void ADvoicelistitem::cb_voiceenabled_i(Fl_Check_Button* o, void*) {
  pars->VoicePar[nvoice].Enabled=(int)o->value();
if (o->value()==0) voicelistitemgroup->deactivate();
else voicelistitemgroup->activate();
o->redraw();
}
void ADvoicelistitem::cb_voiceenabled(Fl_Check_Button* o, void* v) {
  ((ADvoicelistitem*)(o->parent()->user_data()))->cb_voiceenabled_i(o,v);
}

Fl_Group* ADvoicelistitem::make_window() {
  { ADnoteVoiceListItem = new Fl_Group(0, 0, 615, 30);
    ADnoteVoiceListItem->box(FL_FLAT_BOX);
    ADnoteVoiceListItem->color(FL_BACKGROUND_COLOR);
    ADnoteVoiceListItem->selection_color(FL_BACKGROUND_COLOR);
    ADnoteVoiceListItem->labeltype(FL_NO_LABEL);
    ADnoteVoiceListItem->labelfont(0);
    ADnoteVoiceListItem->labelsize(14);
    ADnoteVoiceListItem->labelcolor(FL_FOREGROUND_COLOR);
    ADnoteVoiceListItem->user_data((void*)(this));
    ADnoteVoiceListItem->align(Fl_Align(FL_ALIGN_TOP));
    ADnoteVoiceListItem->when(FL_WHEN_RELEASE);
    { Fl_Group* o = voicelistitemgroup = new Fl_Group(50, 0, 570, 25);
      voicelistitemgroup->box(FL_FLAT_BOX);
      { Fl_Value_Slider* o = voicevolume = new Fl_Value_Slider(90, 5, 115, 20);
        voicevolume->tooltip("Volume");
        voicevolume->type(5);
        voicevolume->box(FL_FLAT_BOX);
        voicevolume->labelsize(8);
        voicevolume->maximum(127);
        voicevolume->step(1);
        voicevolume->callback((Fl_Callback*)cb_voicevolume);
        voicevolume->align(Fl_Align(FL_ALIGN_TOP_LEFT));
        o->value(pars->VoicePar[nvoice].PVolume);
      } // Fl_Value_Slider* voicevolume
      { Fl_Check_Button* o = voiceresonanceenabled = new Fl_Check_Button(245, 7, 15, 17);
        voiceresonanceenabled->tooltip("Resonance On/Off");
        voiceresonanceenabled->down_box(FL_DOWN_BOX);
        voiceresonanceenabled->labeltype(FL_EMBOSSED_LABEL);
        voiceresonanceenabled->labelfont(1);
        voiceresonanceenabled->labelsize(11);
        voiceresonanceenabled->callback((Fl_Callback*)cb_voiceresonanceenabled);
        voiceresonanceenabled->align(Fl_Align(FL_ALIGN_LEFT));
        o->value(pars->VoicePar[nvoice].Presonance);
      } // Fl_Check_Button* voiceresonanceenabled
      { Fl_Value_Slider* o = voicelfofreq = new Fl_Value_Slider(500, 5, 115, 20);
        voicelfofreq->tooltip("Frequency LFO amount");
        voicelfofreq->type(5);
        voicelfofreq->box(FL_FLAT_BOX);
        voicelfofreq->labelsize(8);
        voicelfofreq->maximum(127);
        voicelfofreq->step(1);
        voicelfofreq->callback((Fl_Callback*)cb_voicelfofreq);
        voicelfofreq->align(Fl_Align(FL_ALIGN_TOP_LEFT));
        o->value(pars->VoicePar[nvoice].FreqLfo->Pintensity);
      } // Fl_Value_Slider* voicelfofreq
      { WidgetPDial* o = voicepanning = new WidgetPDial(215, 5, 20, 20);
        voicepanning->tooltip("Panning (leftmost is Random)");
        voicepanning->box(FL_ROUND_UP_BOX);
        voicepanning->color(FL_BACKGROUND_COLOR);
        voicepanning->selection_color(FL_INACTIVE_COLOR);
        voicepanning->labeltype(FL_NORMAL_LABEL);
        voicepanning->labelfont(0);
        voicepanning->labelsize(10);
        voicepanning->labelcolor(FL_FOREGROUND_COLOR);
        voicepanning->maximum(127);
        voicepanning->step(1);
        voicepanning->callback((Fl_Callback*)cb_voicepanning);
        voicepanning->align(Fl_Align(FL_ALIGN_LEFT));
        voicepanning->when(FL_WHEN_CHANGED);
        o->value(pars->VoicePar[nvoice].PPanning);
      } // WidgetPDial* voicepanning
      { Fl_Group* o = voiceoscil = new Fl_Group(60, 5, 30, 20);
        voiceoscil->box(FL_THIN_DOWN_BOX);
        voiceoscil->color(FL_GRAY0);
        voiceoscil->selection_color((Fl_Color)71);
        voiceoscil->labelcolor((Fl_Color)179);
        osc=new Oscilloscope(o->x(),o->y(),o->w(),o->h(),"");
        osc->init(pars->VoicePar[nvoice].OscilSmp,0,pars->VoicePar[nvoice].Poscilphase,master);
        if (pars->VoicePar[nvoice].Pextoscil != -1) {osc->init(pars->VoicePar[pars->VoicePar[nvoice].Pextoscil].OscilSmp,master);}
        voiceoscil->end();
      } // Fl_Group* voiceoscil
      { Fl_Value_Output* o = detunevalueoutput = new Fl_Value_Output(265, 5, 45, 20);
        detunevalueoutput->labelsize(10);
        detunevalueoutput->minimum(-5000);
        detunevalueoutput->maximum(5000);
        detunevalueoutput->step(0.01);
        detunevalueoutput->textfont(1);
        detunevalueoutput->textsize(10);
        detunevalueoutput->callback((Fl_Callback*)cb_detunevalueoutput);
        detunevalueoutput->align(Fl_Align(FL_ALIGN_TOP_LEFT));
        o->value(getdetune(pars->VoicePar[nvoice].PDetuneType,0,pars->VoicePar[nvoice].PDetune)*pars->getBandwidthDetuneMultiplier());
      } // Fl_Value_Output* detunevalueoutput
      { Fl_Slider* o = voicedetune = new Fl_Slider(315, 5, 185, 20);
        voicedetune->tooltip("Fine Detune (cents)");
        voicedetune->type(5);
        voicedetune->box(FL_FLAT_BOX);
        voicedetune->minimum(-8192);
        voicedetune->maximum(8191);
        voicedetune->step(1);
        voicedetune->callback((Fl_Callback*)cb_voicedetune);
        o->value(pars->VoicePar[nvoice].PDetune-8192);
      } // Fl_Slider* voicedetune
      { Fl_Box* o = noiselabel = new Fl_Box(65, 5, 20, 20, "N");
        noiselabel->labelfont(1);
        noiselabel->labelsize(13);
        noiselabel->labelcolor(FL_BACKGROUND2_COLOR);
        noiselabel->callback((Fl_Callback*)cb_noiselabel);
        if (pars->VoicePar[nvoice].Type==0) o->hide();
      } // Fl_Box* noiselabel
      if (pars->VoicePar[nvoice].Enabled==0) o->deactivate();
      voicelistitemgroup->end();
    } // Fl_Group* voicelistitemgroup
    { Fl_Check_Button* o = voiceenabled = new Fl_Check_Button(30, 5, 20, 20, "01");
      voiceenabled->down_box(FL_DOWN_BOX);
      voiceenabled->labeltype(FL_EMBOSSED_LABEL);
      voiceenabled->labelfont(1);
      voiceenabled->labelsize(13);
      voiceenabled->callback((Fl_Callback*)cb_voiceenabled);
      voiceenabled->align(Fl_Align(FL_ALIGN_LEFT));
      char tmp[10];snprintf(tmp,10,"%d",nvoice+1);o->label(strdup(tmp));
      o->value(pars->VoicePar[nvoice].Enabled);
    } // Fl_Check_Button* voiceenabled
    ADnoteVoiceListItem->end();
  } // Fl_Group* ADnoteVoiceListItem
  return ADnoteVoiceListItem;
}

ADvoicelistitem::ADvoicelistitem(int x,int y, int w, int h, const char *label):Fl_Group(x,y,w,h,label) {
  nvoice=0;
pars=NULL;
}

void ADvoicelistitem::init(ADnoteParameters *parameters,int nvoice_,Master *master_) {
  pars=parameters;
nvoice=nvoice_;
master=master_;
make_window();
ADnoteVoiceListItem->show();
end();
}

void ADvoicelistitem::refreshlist() {
  voiceenabled->value(pars->VoicePar[nvoice].Enabled);
voiceresonanceenabled->value(pars->VoicePar[nvoice].Presonance);
voicevolume->value(pars->VoicePar[nvoice].PVolume);
voicedetune->value(pars->VoicePar[nvoice].PDetune-8192);
voicepanning->value(pars->VoicePar[nvoice].PPanning);
voicelfofreq->value(pars->VoicePar[nvoice].FreqLfo->Pintensity);
if (pars->VoicePar[nvoice].Pextoscil != -1) {
  osc->init(pars->VoicePar[pars->VoicePar[nvoice].Pextoscil].OscilSmp,0,pars->VoicePar[nvoice].Poscilphase,master);
} else 
  osc->init(pars->VoicePar[nvoice].OscilSmp,0,pars->VoicePar[nvoice].Poscilphase,master);
if (pars->VoicePar[nvoice].Enabled==0) voicelistitemgroup->deactivate();
    else voicelistitemgroup->activate();
detunevalueoutput->do_callback();
noiselabel->do_callback();
ADnoteVoiceListItem->redraw();
}

ADvoicelistitem::~ADvoicelistitem() {
  ADnoteVoiceListItem->hide();
//delete(ADnoteVoiceListItem);
}

void ADvoiceUI::cb_Enable_i(Fl_Check_Button* o, void*) {
  pars->VoicePar[nvoice].PFMFreqEnvelopeEnabled=(int)o->value();
if (o->value()==0) voiceFMfreqenvgroup->deactivate();
else voiceFMfreqenvgroup->activate();
o->redraw();
}
void ADvoiceUI::cb_Enable(Fl_Check_Button* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->parent()->parent()->user_data()))->cb_Enable_i(o,v);
}

void ADvoiceUI::cb_Coarse_i(Fl_Counter* o, void*) {
  int k=(int) o->value();
if (k<0) k+=1024;
pars->VoicePar[nvoice].PFMCoarseDetune = k+
   (pars->VoicePar[nvoice].PFMCoarseDetune/1024)*1024;
}
void ADvoiceUI::cb_Coarse(Fl_Counter* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->parent()->parent()->user_data()))->cb_Coarse_i(o,v);
}

void ADvoiceUI::cb_Octave_i(Fl_Counter* o, void*) {
  int k=(int) o->value();
if (k<0) k+=16;
pars->VoicePar[nvoice].PFMCoarseDetune = k*1024+
   pars->VoicePar[nvoice].PFMCoarseDetune%1024;
}
void ADvoiceUI::cb_Octave(Fl_Counter* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->parent()->parent()->user_data()))->cb_Octave_i(o,v);
}

void ADvoiceUI::cb__i(Fl_Slider* o, void*) {
  pars->VoicePar[nvoice].PFMDetune=(int)o->value()+8192;
fmdetunevalueoutput->do_callback();
}
void ADvoiceUI::cb_(Fl_Slider* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->parent()->parent()->user_data()))->cb__i(o,v);
}

void ADvoiceUI::cb_fmdetunevalueoutput_i(Fl_Value_Output* o, void*) {
  o->value(getdetune((pars->VoicePar[nvoice].PFMDetuneType==0)?(pars->GlobalPar.PDetuneType) : (pars->VoicePar[nvoice].PFMDetuneType),0,pars->VoicePar[nvoice].PFMDetune));
}
void ADvoiceUI::cb_fmdetunevalueoutput(Fl_Value_Output* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->parent()->parent()->user_data()))->cb_fmdetunevalueoutput_i(o,v);
}

void ADvoiceUI::cb_Detune_i(Fl_Choice* o, void*) {
  pars->VoicePar[nvoice].PFMDetuneType=(int) o->value();
fmdetunevalueoutput->do_callback();
}
void ADvoiceUI::cb_Detune(Fl_Choice* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->parent()->parent()->user_data()))->cb_Detune_i(o,v);
}

void ADvoiceUI::cb_Vol_i(Fl_Value_Slider* o, void*) {
  pars->VoicePar[nvoice].PFMVolume=(int)o->value();
}
void ADvoiceUI::cb_Vol(Fl_Value_Slider* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->parent()->parent()->user_data()))->cb_Vol_i(o,v);
}

void ADvoiceUI::cb_V_i(Fl_Value_Slider* o, void*) {
  pars->VoicePar[nvoice].PFMVelocityScaleFunction=(int) o->value();
}
void ADvoiceUI::cb_V(Fl_Value_Slider* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->parent()->parent()->user_data()))->cb_V_i(o,v);
}

void ADvoiceUI::cb_Enable1_i(Fl_Check_Button* o, void*) {
  pars->VoicePar[nvoice].PFMAmpEnvelopeEnabled=(int)o->value();
if (o->value()==0) voiceFMampenvgroup->deactivate();
else voiceFMampenvgroup->activate();
o->redraw();
}
void ADvoiceUI::cb_Enable1(Fl_Check_Button* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->parent()->parent()->user_data()))->cb_Enable1_i(o,v);
}

void ADvoiceUI::cb_F_i(Fl_Value_Slider* o, void*) {
  pars->VoicePar[nvoice].PFMVolumeDamp=(int) o->value()+64;
}
void ADvoiceUI::cb_F(Fl_Value_Slider* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->parent()->parent()->user_data()))->cb_F_i(o,v);
}

void ADvoiceUI::cb_changeFMoscilbutton_i(Fl_Button*, void*) {
  if (oscedit!=NULL) delete(oscedit);

int nv=nvoice;
if (pars->VoicePar[nvoice].PextFMoscil>=0) nv=pars->VoicePar[nvoice].PextFMoscil;

oscedit=new OscilEditor(pars->VoicePar[nv].FMSmp,fmoscil,NULL,NULL,master);
}
void ADvoiceUI::cb_changeFMoscilbutton(Fl_Button* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->parent()->parent()->user_data()))->cb_changeFMoscilbutton_i(o,v);
}

void ADvoiceUI::cb_Phase_i(Fl_Slider* o, void*) {
  pars->VoicePar[nvoice].PFMoscilphase=64-(int)o->value();
oscFM->phase=64-(int) o->value();
fmoscil->redraw();
}
void ADvoiceUI::cb_Phase(Fl_Slider* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->parent()->parent()->user_data()))->cb_Phase_i(o,v);
}

void ADvoiceUI::cb_Use_i(Fl_Choice* o, void*) {
  pars->VoicePar[nvoice].PextFMoscil=(int)o->value()-1;
if ((int) o->value() != 0) {
    oscFM->init(pars->VoicePar[(int) o->value()-1].FMSmp,master);
    changeFMoscilbutton->labelcolor(FL_BLUE);
} else { 
    oscFM->init(pars->VoicePar[nvoice].FMSmp,master);
    changeFMoscilbutton->labelcolor(FL_BLACK);
};
voiceFMparametersgroup->redraw();
}
void ADvoiceUI::cb_Use(Fl_Choice* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->parent()->parent()->user_data()))->cb_Use_i(o,v);
}

void ADvoiceUI::cb_External_i(Fl_Choice* o, void*) {
  pars->VoicePar[nvoice].PFMVoice=(int)o->value()-1;
if ((int) o->value() != 0) {
    modoscil->deactivate();
    modfrequency->deactivate();
} else { 
    modoscil->activate();
    modfrequency->activate();
};
voiceFMparametersgroup->redraw();
}
void ADvoiceUI::cb_External(Fl_Choice* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_External_i(o,v);
}

void ADvoiceUI::cb_Type_i(Fl_Choice* o, void*) {
  pars->VoicePar[nvoice].PFMEnabled=(int)o->value();
if (o->value()==0) voiceFMparametersgroup->deactivate();
else voiceFMparametersgroup->activate();
o->redraw();
}
void ADvoiceUI::cb_Type(Fl_Choice* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->user_data()))->cb_Type_i(o,v);
}

Fl_Menu_Item ADvoiceUI::menu_Type[] = {
 {"OFF", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 14, 0},
 {"MORPH", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 14, 0},
 {"RING", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 14, 0},
 {"PM", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 14, 0},
 {"FM", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 14, 0},
 {"PITCH", 0,  0, 0, 1, FL_NORMAL_LABEL, 1, 14, 0},
 {0,0,0,0,0,0,0,0,0}
};

void ADvoiceUI::cb_Enable2_i(Fl_Check_Button* o, void*) {
  pars->VoicePar[nvoice].PFreqEnvelopeEnabled=(int)o->value();
if (o->value()==0) voicefreqenvgroup->deactivate();
else voicefreqenvgroup->activate();
o->redraw();
}
void ADvoiceUI::cb_Enable2(Fl_Check_Button* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_Enable2_i(o,v);
}

void ADvoiceUI::cb_Enable3_i(Fl_Check_Button* o, void*) {
  pars->VoicePar[nvoice].PFreqLfoEnabled=(int)o->value();
if (o->value()==0) voicefreqlfogroup->deactivate();
else voicefreqlfogroup->activate();
o->redraw();
}
void ADvoiceUI::cb_Enable3(Fl_Check_Button* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_Enable3_i(o,v);
}

void ADvoiceUI::cb_Octave1_i(Fl_Counter* o, void*) {
  int k=(int) o->value();
if (k<0) k+=16;
pars->VoicePar[nvoice].PCoarseDetune = k*1024+
   pars->VoicePar[nvoice].PCoarseDetune%1024;
}
void ADvoiceUI::cb_Octave1(Fl_Counter* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_Octave1_i(o,v);
}

void ADvoiceUI::cb_Coarse1_i(Fl_Counter* o, void*) {
  int k=(int) o->value();
if (k<0) k+=1024;
pars->VoicePar[nvoice].PCoarseDetune = k+
   (pars->VoicePar[nvoice].PCoarseDetune/1024)*1024;
}
void ADvoiceUI::cb_Coarse1(Fl_Counter* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_Coarse1_i(o,v);
}

void ADvoiceUI::cb_1_i(Fl_Slider* o, void*) {
  pars->VoicePar[nvoice].PDetune=(int)o->value()+8192;
detunevalueoutput->do_callback();
}
void ADvoiceUI::cb_1(Fl_Slider* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_1_i(o,v);
}

void ADvoiceUI::cb_detunevalueoutput1_i(Fl_Value_Output* o, void*) {
  o->value(getdetune((pars->VoicePar[nvoice].PDetuneType==0)?(pars->GlobalPar.PDetuneType) : (pars->VoicePar[nvoice].PDetuneType),0,pars->VoicePar[nvoice].PDetune)*pars->getBandwidthDetuneMultiplier());
}
void ADvoiceUI::cb_detunevalueoutput1(Fl_Value_Output* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_detunevalueoutput1_i(o,v);
}

void ADvoiceUI::cb_440Hz_i(Fl_Check_Button* o, void*) {
  int x=(int) o->value();
pars->VoicePar[nvoice].Pfixedfreq=x;
if (x==0) fixedfreqetdial->deactivate();
    else fixedfreqetdial->activate();
}
void ADvoiceUI::cb_440Hz(Fl_Check_Button* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_440Hz_i(o,v);
}

void ADvoiceUI::cb_fixedfreqetdial_i(WidgetPDial* o, void*) {
  pars->VoicePar[nvoice].PfixedfreqET=(int) o->value();
}
void ADvoiceUI::cb_fixedfreqetdial(WidgetPDial* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_fixedfreqetdial_i(o,v);
}

void ADvoiceUI::cb_Detune1_i(Fl_Choice* o, void*) {
  pars->VoicePar[nvoice].PDetuneType=(int) o->value();
detunevalueoutput->do_callback();
}
void ADvoiceUI::cb_Detune1(Fl_Choice* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_Detune1_i(o,v);
}

void ADvoiceUI::cb_changevoiceoscilbutton_i(Fl_Button*, void*) {
  if (oscedit!=NULL) delete(oscedit);

int nv=nvoice;
if (pars->VoicePar[nvoice].Pextoscil>=0) nv=pars->VoicePar[nvoice].Pextoscil;

oscedit=new OscilEditor(pars->VoicePar[nv].OscilSmp,voiceoscil,NULL,NULL,master);
}
void ADvoiceUI::cb_changevoiceoscilbutton(Fl_Button* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->user_data()))->cb_changevoiceoscilbutton_i(o,v);
}

void ADvoiceUI::cb_Phase1_i(Fl_Slider* o, void*) {
  pars->VoicePar[nvoice].Poscilphase=64-(int)o->value();
osc->phase=64-(int) o->value();
voiceoscil->redraw();
}
void ADvoiceUI::cb_Phase1(Fl_Slider* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->user_data()))->cb_Phase1_i(o,v);
}

void ADvoiceUI::cb_R_i(Fl_Check_Button* o, void*) {
  pars->VoicePar[nvoice].Presonance=(int) o->value();
}
void ADvoiceUI::cb_R(Fl_Check_Button* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->user_data()))->cb_R_i(o,v);
}

void ADvoiceUI::cb_Use1_i(Fl_Choice* o, void*) {
  pars->VoicePar[nvoice].Pextoscil=(int)o->value()-1;
if ((int) o->value() != 0) {
    osc->init(pars->VoicePar[(int) o->value()-1].OscilSmp,master);
    changevoiceoscilbutton->labelcolor(FL_BLUE);
} else { 
    osc->init(pars->VoicePar[nvoice].OscilSmp,master);
    changevoiceoscilbutton->labelcolor(FL_BLACK);
};

voiceparametersgroup->redraw();
voiceonbutton->redraw();
}
void ADvoiceUI::cb_Use1(Fl_Choice* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->user_data()))->cb_Use1_i(o,v);
}

void ADvoiceUI::cb_Stereo_i(WidgetPDial* o, void*) {
  pars->VoicePar[nvoice].Unison_stereo_spread=(int)o->value();
}
void ADvoiceUI::cb_Stereo(WidgetPDial* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_Stereo_i(o,v);
}

void ADvoiceUI::cb_Unison_i(Fl_Choice* o, void*) {
  pars->set_unison_size_index(nvoice,(int) o->value());
}
void ADvoiceUI::cb_Unison(Fl_Choice* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_Unison_i(o,v);
}

void ADvoiceUI::cb_Vibratto_i(WidgetPDial* o, void*) {
  pars->VoicePar[nvoice].Unison_vibratto=(int)o->value();
}
void ADvoiceUI::cb_Vibratto(WidgetPDial* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_Vibratto_i(o,v);
}

void ADvoiceUI::cb_Invert_i(Fl_Choice* o, void*) {
  pars->VoicePar[nvoice].Unison_invert_phase=(int) o->value();
}
void ADvoiceUI::cb_Invert(Fl_Choice* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_Invert_i(o,v);
}

void ADvoiceUI::cb_Frequency_i(Fl_Slider* o, void*) {
  pars->VoicePar[nvoice].Unison_frequency_spread=(int)o->value();
unisonspreadoutput->do_callback();
}
void ADvoiceUI::cb_Frequency(Fl_Slider* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_Frequency_i(o,v);
}

void ADvoiceUI::cb_unisonspreadoutput_i(Fl_Value_Output* o, void*) {
  o->value(pars->getUnisonFrequencySpreadCents(nvoice));
}
void ADvoiceUI::cb_unisonspreadoutput(Fl_Value_Output* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_unisonspreadoutput_i(o,v);
}

void ADvoiceUI::cb_Vib_i(WidgetPDial* o, void*) {
  pars->VoicePar[nvoice].Unison_vibratto_speed=(int)o->value();
}
void ADvoiceUI::cb_Vib(WidgetPDial* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_Vib_i(o,v);
}

void ADvoiceUI::cb_Vol1_i(Fl_Value_Slider* o, void*) {
  pars->VoicePar[nvoice].PVolume=(int)o->value();
}
void ADvoiceUI::cb_Vol1(Fl_Value_Slider* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->user_data()))->cb_Vol1_i(o,v);
}

void ADvoiceUI::cb_V1_i(Fl_Value_Slider* o, void*) {
  pars->VoicePar[nvoice].PAmpVelocityScaleFunction=(int) o->value();
}
void ADvoiceUI::cb_V1(Fl_Value_Slider* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->user_data()))->cb_V1_i(o,v);
}

void ADvoiceUI::cb_Pan_i(WidgetPDial* o, void*) {
  pars->VoicePar[nvoice].PPanning=(int) o->value();
}
void ADvoiceUI::cb_Pan(WidgetPDial* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->user_data()))->cb_Pan_i(o,v);
}

void ADvoiceUI::cb_Enable4_i(Fl_Check_Button* o, void*) {
  pars->VoicePar[nvoice].PAmpEnvelopeEnabled=(int)o->value();
if (o->value()==0) voiceampenvgroup->deactivate();
else voiceampenvgroup->activate();
o->redraw();
}
void ADvoiceUI::cb_Enable4(Fl_Check_Button* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->user_data()))->cb_Enable4_i(o,v);
}

void ADvoiceUI::cb_Enable5_i(Fl_Check_Button* o, void*) {
  pars->VoicePar[nvoice].PAmpLfoEnabled=(int)o->value();
if (o->value()==0) voiceamplfogroup->deactivate();
else voiceamplfogroup->activate();
o->redraw();
}
void ADvoiceUI::cb_Enable5(Fl_Check_Button* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->user_data()))->cb_Enable5_i(o,v);
}

void ADvoiceUI::cb_Minus_i(Fl_Check_Button* o, void*) {
  pars->VoicePar[nvoice].PVolumeminus=(int)o->value();
}
void ADvoiceUI::cb_Minus(Fl_Check_Button* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->user_data()))->cb_Minus_i(o,v);
}

void ADvoiceUI::cb_Enable6_i(Fl_Check_Button* o, void*) {
  pars->VoicePar[nvoice].PFilterEnvelopeEnabled=(int)o->value();
if (o->value()==0) voicefilterenvgroup->deactivate();
else voicefilterenvgroup->activate();
o->redraw();
}
void ADvoiceUI::cb_Enable6(Fl_Check_Button* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->user_data()))->cb_Enable6_i(o,v);
}

void ADvoiceUI::cb_Enable7_i(Fl_Check_Button* o, void*) {
  pars->VoicePar[nvoice].PFilterLfoEnabled=(int)o->value();
if (o->value()==0) voicefilterlfogroup->deactivate();
else voicefilterlfogroup->activate();
o->redraw();
}
void ADvoiceUI::cb_Enable7(Fl_Check_Button* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->user_data()))->cb_Enable7_i(o,v);
}

void ADvoiceUI::cb_2_i(Fl_Choice* o, void*) {
  int x=(int) o->value();
pars->VoicePar[nvoice].Type=x;
if (x==0) voicemodegroup->activate();
  else voicemodegroup->deactivate();
noiselabel->do_callback();
}
void ADvoiceUI::cb_2(Fl_Choice* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->user_data()))->cb_2_i(o,v);
}

Fl_Menu_Item ADvoiceUI::menu_[] = {
 {"Sound", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 11, 0},
 {"NOISE", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 11, 1},
 {0,0,0,0,0,0,0,0,0}
};

void ADvoiceUI::cb_bypassfiltercheckbutton_i(Fl_Check_Button* o, void*) {
  pars->VoicePar[nvoice].Pfilterbypass=(int)o->value();
}
void ADvoiceUI::cb_bypassfiltercheckbutton(Fl_Check_Button* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->user_data()))->cb_bypassfiltercheckbutton_i(o,v);
}

void ADvoiceUI::cb_Delay_i(Fl_Value_Slider* o, void*) {
  pars->VoicePar[nvoice].PDelay=(int)o->value();
}
void ADvoiceUI::cb_Delay(Fl_Value_Slider* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->user_data()))->cb_Delay_i(o,v);
}

void ADvoiceUI::cb_Enable8_i(Fl_Check_Button* o, void*) {
  pars->VoicePar[nvoice].PFilterEnabled=(int)o->value();
if (o->value()==0) voicefiltergroup->deactivate();
else voicefiltergroup->activate();
o->redraw();
bypassfiltercheckbutton->redraw();
}
void ADvoiceUI::cb_Enable8(Fl_Check_Button* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->user_data()))->cb_Enable8_i(o,v);
}

void ADvoiceUI::cb_noiselabel1_i(Fl_Box* o, void*) {
  if (pars->VoicePar[nvoice].Type==0) o->hide(); else o->show();
}
void ADvoiceUI::cb_noiselabel1(Fl_Box* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->user_data()))->cb_noiselabel1_i(o,v);
}

void ADvoiceUI::cb_voiceonbutton_i(Fl_Check_Button* o, void*) {
  pars->VoicePar[nvoice].Enabled=(int)o->value();
if (o->value()==0) voiceparametersgroup->deactivate();
else voiceparametersgroup->activate();
o->redraw();
}
void ADvoiceUI::cb_voiceonbutton(Fl_Check_Button* o, void* v) {
  ((ADvoiceUI*)(o->parent()->user_data()))->cb_voiceonbutton_i(o,v);
}

Fl_Group* ADvoiceUI::make_window() {
  { ADnoteVoiceParameters = new Fl_Group(0, 0, 765, 575, "Voice");
    ADnoteVoiceParameters->box(FL_FLAT_BOX);
    ADnoteVoiceParameters->color(FL_BACKGROUND_COLOR);
    ADnoteVoiceParameters->selection_color(FL_BACKGROUND_COLOR);
    ADnoteVoiceParameters->labeltype(FL_NO_LABEL);
    ADnoteVoiceParameters->labelfont(0);
    ADnoteVoiceParameters->labelsize(14);
    ADnoteVoiceParameters->labelcolor(FL_FOREGROUND_COLOR);
    ADnoteVoiceParameters->user_data((void*)(this));
    ADnoteVoiceParameters->align(Fl_Align(FL_ALIGN_TOP));
    ADnoteVoiceParameters->when(FL_WHEN_RELEASE);
    { Fl_Group* o = voiceparametersgroup = new Fl_Group(0, 0, 765, 580);
      voiceparametersgroup->box(FL_THIN_UP_BOX);
      voiceparametersgroup->color((Fl_Color)48);
      { voicemodegroup = new Fl_Group(0, 5, 760, 575);
        { Fl_Group* o = voiceFMparametersgroup = new Fl_Group(530, 5, 230, 565, "MODULATOR");
          voiceFMparametersgroup->box(FL_THIN_UP_FRAME);
          voiceFMparametersgroup->color((Fl_Color)48);
          voiceFMparametersgroup->labeltype(FL_EMBOSSED_LABEL);
          voiceFMparametersgroup->labelfont(1);
          voiceFMparametersgroup->labelsize(13);
          voiceFMparametersgroup->align(Fl_Align(FL_ALIGN_TOP|FL_ALIGN_INSIDE));
          { modfrequency = new Fl_Group(535, 220, 220, 145, "Mod.FREQUENCY");
            modfrequency->box(FL_THIN_UP_BOX);
            modfrequency->labeltype(FL_EMBOSSED_LABEL);
            modfrequency->labelfont(1);
            modfrequency->labelsize(13);
            modfrequency->align(Fl_Align(FL_ALIGN_TOP|FL_ALIGN_INSIDE));
            { EnvelopeUI* o = voiceFMfreqenvgroup = new EnvelopeUI(540, 290, 205, 70, "ADSynth Modulator - Frequency Envelope");
              voiceFMfreqenvgroup->box(FL_FLAT_BOX);
              voiceFMfreqenvgroup->color((Fl_Color)51);
              voiceFMfreqenvgroup->selection_color(FL_BACKGROUND_COLOR);
              voiceFMfreqenvgroup->labeltype(FL_NORMAL_LABEL);
              voiceFMfreqenvgroup->labelfont(0);
              voiceFMfreqenvgroup->labelsize(14);
              voiceFMfreqenvgroup->labelcolor(FL_FOREGROUND_COLOR);
              voiceFMfreqenvgroup->align(Fl_Align(FL_ALIGN_WRAP|FL_ALIGN_INSIDE));
              voiceFMfreqenvgroup->when(FL_WHEN_RELEASE);
              o->init(pars->VoicePar[nvoice].FMFreqEnvelope);
              if (pars->VoicePar[nvoice].PFMFreqEnvelopeEnabled==0) o->deactivate();
              voiceFMfreqenvgroup->end();
            } // EnvelopeUI* voiceFMfreqenvgroup
            { Fl_Check_Button* o = new Fl_Check_Button(545, 295, 50, 10, "Enable");
              o->tooltip("Forced Relase");
              o->down_box(FL_DOWN_BOX);
              o->labelfont(1);
              o->labelsize(10);
              o->callback((Fl_Callback*)cb_Enable);
              o->value(pars->VoicePar[nvoice].PFMFreqEnvelopeEnabled);
            } // Fl_Check_Button* o
            { Fl_Counter* o = new Fl_Counter(685, 270, 60, 15, "Coarse Det.");
              o->tooltip("Coarse Detune");
              o->labelsize(10);
              o->minimum(-64);
              o->maximum(63);
              o->step(1);
              o->textfont(1);
              o->textsize(11);
              o->callback((Fl_Callback*)cb_Coarse);
              o->align(Fl_Align(FL_ALIGN_TOP));
              int k=pars->VoicePar[nvoice].PFMCoarseDetune%1024;
              if (k>=512) k-=1024;
              o->value(k);
              o->lstep(10);
            } // Fl_Counter* o
            { Fl_Counter* o = new Fl_Counter(625, 270, 45, 15, "Octave");
              o->tooltip("Octave");
              o->type(1);
              o->labelsize(10);
              o->minimum(-8);
              o->maximum(7);
              o->step(1);
              o->textfont(1);
              o->textsize(11);
              o->callback((Fl_Callback*)cb_Octave);
              o->align(Fl_Align(FL_ALIGN_TOP));
              int k=pars->VoicePar[nvoice].PFMCoarseDetune/1024;
              if (k>=8) k-=16;
              o->value(k);
            } // Fl_Counter* o
            { Fl_Slider* o = new Fl_Slider(590, 245, 160, 10);
              o->tooltip("Fine Detune (cents)");
              o->type(5);
              o->box(FL_FLAT_BOX);
              o->minimum(-8192);
              o->maximum(8191);
              o->step(1);
              o->callback((Fl_Callback*)cb_);
              o->value(pars->VoicePar[nvoice].PFMDetune-8192);
            } // Fl_Slider* o
            { Fl_Value_Output* o = fmdetunevalueoutput = new Fl_Value_Output(540, 245, 45, 13, "Detune");
              fmdetunevalueoutput->labelsize(8);
              fmdetunevalueoutput->minimum(-5000);
              fmdetunevalueoutput->maximum(5000);
              fmdetunevalueoutput->step(0.01);
              fmdetunevalueoutput->textfont(1);
              fmdetunevalueoutput->textsize(8);
              fmdetunevalueoutput->callback((Fl_Callback*)cb_fmdetunevalueoutput);
              fmdetunevalueoutput->align(Fl_Align(FL_ALIGN_TOP_LEFT));
              o->value(getdetune((pars->VoicePar[nvoice].PFMDetuneType==0)?(pars->GlobalPar.PDetuneType) : (pars->VoicePar[nvoice].PFMDetuneType),0,pars->VoicePar[nvoice].PFMDetune));
              //o->value(getdetune(pars->VoicePar[nvoice].PFMDetuneType,0,pars->VoicePar[nvoice].PFMDetune));
            } // Fl_Value_Output* fmdetunevalueoutput
            { Fl_Choice* o = new Fl_Choice(540, 270, 75, 15, "Detune Type");
              o->down_box(FL_BORDER_BOX);
              o->labelsize(10);
              o->textfont(1);
              o->textsize(10);
              o->callback((Fl_Callback*)cb_Detune);
              o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
              o->add("Default");o->add("L35cents");o->add("L10cents");o->add("E100cents");o->add("E1200cents");
              o->value(pars->VoicePar[nvoice].PFMDetuneType);
            } // Fl_Choice* o
            modfrequency->end();
          } // Fl_Group* modfrequency
          { Fl_Group* o = new Fl_Group(535, 60, 220, 160, "Mod.AMPLITUDE");
            o->box(FL_THIN_UP_BOX);
            o->labeltype(FL_EMBOSSED_LABEL);
            o->labelfont(1);
            o->labelsize(13);
            o->align(Fl_Align(FL_ALIGN_TOP|FL_ALIGN_INSIDE));
            { Fl_Value_Slider* o = new Fl_Value_Slider(540, 80, 160, 15, "Vol");
              o->tooltip("Volume");
              o->type(5);
              o->box(FL_FLAT_BOX);
              o->labelsize(11);
              o->maximum(127);
              o->step(1);
              o->callback((Fl_Callback*)cb_Vol);
              o->align(Fl_Align(FL_ALIGN_RIGHT));
              o->value(pars->VoicePar[nvoice].PFMVolume);
            } // Fl_Value_Slider* o
            { Fl_Value_Slider* o = new Fl_Value_Slider(540, 100, 160, 15, "V.Sns");
              o->tooltip("Velocity Sensing Function (rightmost to disable)");
              o->type(5);
              o->box(FL_FLAT_BOX);
              o->labelsize(11);
              o->maximum(127);
              o->step(1);
              o->callback((Fl_Callback*)cb_V);
              o->align(Fl_Align(FL_ALIGN_RIGHT));
              o->value(pars->VoicePar[nvoice].PFMVelocityScaleFunction);
            } // Fl_Value_Slider* o
            { EnvelopeUI* o = voiceFMampenvgroup = new EnvelopeUI(540, 145, 205, 70, "ADSynth Modulator - Amplitude Envelope");
              voiceFMampenvgroup->box(FL_FLAT_BOX);
              voiceFMampenvgroup->color((Fl_Color)51);
              voiceFMampenvgroup->selection_color(FL_BACKGROUND_COLOR);
              voiceFMampenvgroup->labeltype(FL_NORMAL_LABEL);
              voiceFMampenvgroup->labelfont(0);
              voiceFMampenvgroup->labelsize(14);
              voiceFMampenvgroup->labelcolor(FL_FOREGROUND_COLOR);
              voiceFMampenvgroup->align(Fl_Align(FL_ALIGN_WRAP|FL_ALIGN_INSIDE));
              voiceFMampenvgroup->when(FL_WHEN_RELEASE);
              o->init(pars->VoicePar[nvoice].FMAmpEnvelope);
              if (pars->VoicePar[nvoice].PFMAmpEnvelopeEnabled==0) o->deactivate();
              voiceFMampenvgroup->end();
            } // EnvelopeUI* voiceFMampenvgroup
            { Fl_Check_Button* o = new Fl_Check_Button(545, 150, 50, 10, "Enable");
              o->tooltip("Forced Relase");
              o->down_box(FL_DOWN_BOX);
              o->labelfont(1);
              o->labelsize(10);
              o->callback((Fl_Callback*)cb_Enable1);
              o->value(pars->VoicePar[nvoice].PFMAmpEnvelopeEnabled);
            } // Fl_Check_Button* o
            { Fl_Value_Slider* o = new Fl_Value_Slider(540, 120, 160, 15, "F.Damp");
              o->tooltip("Modulator Damp at Higher frequency");
              o->type(5);
              o->box(FL_FLAT_BOX);
              o->labelsize(11);
              o->minimum(-64);
              o->maximum(63);
              o->step(1);
              o->callback((Fl_Callback*)cb_F);
              o->align(Fl_Align(FL_ALIGN_RIGHT));
              o->value(pars->VoicePar[nvoice].PFMVolumeDamp-64);
            } // Fl_Value_Slider* o
            o->end();
          } // Fl_Group* o
          { modoscil = new Fl_Group(535, 365, 220, 200);
            { Fl_Group* o = fmoscil = new Fl_Group(535, 425, 220, 140);
              fmoscil->box(FL_THIN_DOWN_BOX);
              fmoscil->color(FL_GRAY0);
              fmoscil->selection_color((Fl_Color)71);
              fmoscil->labelcolor((Fl_Color)179);
              oscFM=new Oscilloscope(o->x(),o->y(),o->w(),o->h(),"");
              int nv=nvoice; if (pars->VoicePar[nvoice].PextFMoscil>=0) nv=pars->VoicePar[nvoice].PextFMoscil;
              oscFM->init(pars->VoicePar[nv].FMSmp,0,pars->VoicePar[nvoice].PFMoscilphase,master);
              fmoscil->end();
            } // Fl_Group* fmoscil
            { Fl_Box* o = new Fl_Box(535, 365, 155, 20, "Mod.Oscillator");
              o->labelfont(1);
              o->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
            } // Fl_Box* o
            { Fl_Button* o = changeFMoscilbutton = new Fl_Button(700, 370, 55, 15, "Change");
              changeFMoscilbutton->box(FL_THIN_UP_BOX);
              changeFMoscilbutton->labelfont(1);
              changeFMoscilbutton->labelsize(11);
              changeFMoscilbutton->callback((Fl_Callback*)cb_changeFMoscilbutton);
              if (pars->VoicePar[nvoice].PextFMoscil>=0) o->labelcolor(FL_BLUE);
            } // Fl_Button* changeFMoscilbutton
            { Fl_Slider* o = new Fl_Slider(665, 400, 65, 10, "Phase");
              o->type(5);
              o->box(FL_FLAT_BOX);
              o->labelsize(10);
              o->minimum(-64);
              o->maximum(63);
              o->step(1);
              o->callback((Fl_Callback*)cb_Phase);
              o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
              o->value(64-pars->VoicePar[nvoice].PFMoscilphase);
            } // Fl_Slider* o
            { Fl_Choice* o = new Fl_Choice(560, 395, 75, 15, "Use");
              o->down_box(FL_BORDER_BOX);
              o->labelsize(10);
              o->textfont(1);
              o->textsize(10);
              o->callback((Fl_Callback*)cb_Use);
              o->add("Internal");
              char tmp[50]; for (int i=0;i<nvoice;i++) {sprintf(tmp,"ExtM.%2d",i+1);o->add(tmp);};
              o->value(pars->VoicePar[nvoice].PextFMoscil+1);
            } // Fl_Choice* o
            modoscil->end();
          } // Fl_Group* modoscil
          { Fl_Choice* o = new Fl_Choice(635, 40, 85, 20, "External Mod.");
            o->down_box(FL_BORDER_BOX);
            o->labelsize(10);
            o->textfont(1);
            o->textsize(10);
            o->callback((Fl_Callback*)cb_External);
            o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
            o->add("OFF");
            char tmp[50]; for (int i=0;i<nvoice;i++) {sprintf(tmp,"ExtMod.%2d",i+1);o->add(tmp);};
            o->value(pars->VoicePar[nvoice].PFMVoice+1);
            if ((int) o->value() != 0) {modoscil->deactivate();modfrequency->deactivate();}
          } // Fl_Choice* o
          if (pars->VoicePar[nvoice].PFMEnabled==0) o->deactivate();
          voiceFMparametersgroup->end();
        } // Fl_Group* voiceFMparametersgroup
        { Fl_Choice* o = new Fl_Choice(535, 40, 80, 20, "Type:");
          o->down_box(FL_BORDER_BOX);
          o->callback((Fl_Callback*)cb_Type);
          o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
          o->menu(menu_Type);
          o->value(pars->VoicePar[nvoice].PFMEnabled);
        } // Fl_Choice* o
        { Fl_Group* o = new Fl_Group(5, 250, 525, 120, "FREQUENCY");
          o->box(FL_THIN_UP_BOX);
          o->labeltype(FL_EMBOSSED_LABEL);
          o->labelfont(1);
          o->labelsize(13);
          o->align(Fl_Align(FL_ALIGN_TOP|FL_ALIGN_INSIDE));
          { EnvelopeUI* o = voicefreqenvgroup = new EnvelopeUI(10, 290, 205, 70, "ADSynth Voice - Frequency Envelope");
            voicefreqenvgroup->box(FL_FLAT_BOX);
            voicefreqenvgroup->color((Fl_Color)51);
            voicefreqenvgroup->selection_color(FL_BACKGROUND_COLOR);
            voicefreqenvgroup->labeltype(FL_NORMAL_LABEL);
            voicefreqenvgroup->labelfont(0);
            voicefreqenvgroup->labelsize(14);
            voicefreqenvgroup->labelcolor(FL_FOREGROUND_COLOR);
            voicefreqenvgroup->align(Fl_Align(FL_ALIGN_WRAP|FL_ALIGN_INSIDE));
            voicefreqenvgroup->when(FL_WHEN_RELEASE);
            o->init(pars->VoicePar[nvoice].FreqEnvelope);
            if (pars->VoicePar[nvoice].PFreqEnvelopeEnabled==0) o->deactivate();
            voicefreqenvgroup->end();
          } // EnvelopeUI* voicefreqenvgroup
          { Fl_Check_Button* o = new Fl_Check_Button(15, 295, 50, 10, "Enable");
            o->tooltip("Forced Relase");
            o->down_box(FL_DOWN_BOX);
            o->labelfont(1);
            o->labelsize(10);
            o->callback((Fl_Callback*)cb_Enable2);
            o->value(pars->VoicePar[nvoice].PFreqEnvelopeEnabled);
          } // Fl_Check_Button* o
          { LFOUI* o = voicefreqlfogroup = new LFOUI(215, 290, 230, 70, "Frequency LFO     ");
            voicefreqlfogroup->box(FL_FLAT_BOX);
            voicefreqlfogroup->color(FL_DARK1);
            voicefreqlfogroup->selection_color(FL_BACKGROUND_COLOR);
            voicefreqlfogroup->labeltype(FL_NORMAL_LABEL);
            voicefreqlfogroup->labelfont(0);
            voicefreqlfogroup->labelsize(14);
            voicefreqlfogroup->labelcolor(FL_FOREGROUND_COLOR);
            voicefreqlfogroup->align(Fl_Align(FL_ALIGN_WRAP|FL_ALIGN_INSIDE));
            voicefreqlfogroup->when(FL_WHEN_RELEASE);
            o->init(pars->VoicePar[nvoice].FreqLfo);
            if (pars->VoicePar[nvoice].PFreqLfoEnabled==0) o->deactivate();
            voicefreqlfogroup->end();
          } // LFOUI* voicefreqlfogroup
          { Fl_Check_Button* o = new Fl_Check_Button(220, 295, 55, 10, "Enable");
            o->tooltip("Forced Relase");
            o->down_box(FL_DOWN_BOX);
            o->labelfont(1);
            o->labelsize(10);
            o->callback((Fl_Callback*)cb_Enable3);
            o->value(pars->VoicePar[nvoice].PFreqLfoEnabled);
          } // Fl_Check_Button* o
          { Fl_Counter* o = new Fl_Counter(470, 270, 45, 15, "Octave");
            o->tooltip("Octave");
            o->type(1);
            o->labelsize(10);
            o->minimum(-8);
            o->maximum(7);
            o->step(1);
            o->textfont(1);
            o->textsize(11);
            o->callback((Fl_Callback*)cb_Octave1);
            o->align(Fl_Align(FL_ALIGN_TOP));
            int k=pars->VoicePar[nvoice].PCoarseDetune/1024;
            if (k>=8) k-=16;
            o->value(k);
          } // Fl_Counter* o
          { Fl_Counter* o = new Fl_Counter(455, 340, 60, 20, "Coarse Det.");
            o->tooltip("Coarse Detune");
            o->labelsize(10);
            o->minimum(-64);
            o->maximum(63);
            o->step(1);
            o->textfont(1);
            o->textsize(11);
            o->callback((Fl_Callback*)cb_Coarse1);
            o->align(Fl_Align(FL_ALIGN_TOP));
            int k=pars->VoicePar[nvoice].PCoarseDetune%1024;
            if (k>=512) k-=1024;
            o->value(k);
            o->lstep(10);
          } // Fl_Counter* o
          { Fl_Slider* o = new Fl_Slider(58, 272, 392, 13);
            o->tooltip("Fine Detune (cents)");
            o->type(5);
            o->box(FL_FLAT_BOX);
            o->minimum(-8192);
            o->maximum(8191);
            o->step(1);
            o->callback((Fl_Callback*)cb_1);
            o->value(pars->VoicePar[nvoice].PDetune-8192);
          } // Fl_Slider* o
          { Fl_Value_Output* o = detunevalueoutput = new Fl_Value_Output(10, 272, 45, 15, "Detune");
            detunevalueoutput->labelsize(10);
            detunevalueoutput->minimum(-5000);
            detunevalueoutput->maximum(5000);
            detunevalueoutput->step(0.01);
            detunevalueoutput->textfont(1);
            detunevalueoutput->textsize(10);
            detunevalueoutput->callback((Fl_Callback*)cb_detunevalueoutput1);
            detunevalueoutput->align(Fl_Align(FL_ALIGN_TOP_LEFT));
            o->value(getdetune((pars->VoicePar[nvoice].PDetuneType==0)?(pars->GlobalPar.PDetuneType) : (pars->VoicePar[nvoice].PDetuneType),0,pars->VoicePar[nvoice].PDetune)*pars->getBandwidthDetuneMultiplier());
          } // Fl_Value_Output* detunevalueoutput
          { Fl_Check_Button* o = new Fl_Check_Button(345, 253, 55, 15, "440Hz");
            o->tooltip("Set the voice base frequency to 440Hz");
            o->down_box(FL_DOWN_BOX);
            o->labelfont(1);
            o->labelsize(11);
            o->callback((Fl_Callback*)cb_440Hz);
            o->value(pars->VoicePar[nvoice].Pfixedfreq);
          } // Fl_Check_Button* o
          { WidgetPDial* o = fixedfreqetdial = new WidgetPDial(405, 255, 15, 15, "Eq.T.");
            fixedfreqetdial->tooltip("How the frequency varies acording to the keyboard (leftmost for fixed frequen\
cy)");
            fixedfreqetdial->box(FL_ROUND_UP_BOX);
            fixedfreqetdial->color(FL_BACKGROUND_COLOR);
            fixedfreqetdial->selection_color(FL_INACTIVE_COLOR);
            fixedfreqetdial->labeltype(FL_NORMAL_LABEL);
            fixedfreqetdial->labelfont(0);
            fixedfreqetdial->labelsize(10);
            fixedfreqetdial->labelcolor(FL_FOREGROUND_COLOR);
            fixedfreqetdial->maximum(127);
            fixedfreqetdial->step(1);
            fixedfreqetdial->callback((Fl_Callback*)cb_fixedfreqetdial);
            fixedfreqetdial->align(Fl_Align(FL_ALIGN_RIGHT));
            fixedfreqetdial->when(FL_WHEN_CHANGED);
            o->value(pars->VoicePar[nvoice].PfixedfreqET);
            if (pars->VoicePar[nvoice].Pfixedfreq==0) o->deactivate();
          } // WidgetPDial* fixedfreqetdial
          { Fl_Choice* o = new Fl_Choice(450, 305, 75, 15, "Detune Type");
            o->down_box(FL_BORDER_BOX);
            o->labelsize(10);
            o->textfont(1);
            o->textsize(10);
            o->callback((Fl_Callback*)cb_Detune1);
            o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
            o->add("Default");o->add("L35cents");o->add("L10cents");o->add("E100cents");o->add("E1200cents");
            o->value(pars->VoicePar[nvoice].PDetuneType);
          } // Fl_Choice* o
          o->end();
        } // Fl_Group* o
        { Fl_Group* o = voiceoscil = new Fl_Group(80, 375, 445, 145);
          voiceoscil->box(FL_THIN_DOWN_BOX);
          voiceoscil->color(FL_GRAY0);
          voiceoscil->selection_color((Fl_Color)71);
          voiceoscil->labelcolor((Fl_Color)179);
          osc=new Oscilloscope(o->x(),o->y(),o->w(),o->h(),"");
          int nv=nvoice; if (pars->VoicePar[nvoice].Pextoscil>=0) nv=pars->VoicePar[nvoice].Pextoscil;
          osc->init(pars->VoicePar[nv].OscilSmp,0,pars->VoicePar[nvoice].Poscilphase,master);
          voiceoscil->end();
        } // Fl_Group* voiceoscil
        { Fl_Button* o = changevoiceoscilbutton = new Fl_Button(5, 475, 65, 20, "Change");
          changevoiceoscilbutton->box(FL_THIN_UP_BOX);
          changevoiceoscilbutton->labelfont(1);
          changevoiceoscilbutton->labelsize(11);
          changevoiceoscilbutton->callback((Fl_Callback*)cb_changevoiceoscilbutton);
          if (pars->VoicePar[nvoice].Pextoscil>=0) o->labelcolor(FL_BLUE);
        } // Fl_Button* changevoiceoscilbutton
        { Fl_Box* o = new Fl_Box(5, 375, 75, 35, "Voice Oscillator");
          o->labelfont(1);
          o->labelsize(12);
          o->align(Fl_Align(FL_ALIGN_WRAP));
        } // Fl_Box* o
        { Fl_Slider* o = new Fl_Slider(10, 420, 65, 10, "Phase");
          o->type(5);
          o->box(FL_FLAT_BOX);
          o->labelsize(10);
          o->minimum(-64);
          o->maximum(63);
          o->step(1);
          o->callback((Fl_Callback*)cb_Phase1);
          o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
          o->value(64-pars->VoicePar[nvoice].Poscilphase);
        } // Fl_Slider* o
        { Fl_Check_Button* o = new Fl_Check_Button(210, 5, 35, 35, "R.");
          o->tooltip("Resonance On/Off");
          o->box(FL_THIN_UP_BOX);
          o->down_box(FL_DOWN_BOX);
          o->labelfont(1);
          o->labelsize(11);
          o->callback((Fl_Callback*)cb_R);
          o->value(pars->VoicePar[nvoice].Presonance);
        } // Fl_Check_Button* o
        { Fl_Choice* o = new Fl_Choice(5, 455, 65, 15, "Use Oscil.");
          o->down_box(FL_BORDER_BOX);
          o->labelsize(10);
          o->textfont(1);
          o->textsize(10);
          o->callback((Fl_Callback*)cb_Use1);
          o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
          o->add("Internal");
          char tmp[50]; for (int i=0;i<nvoice;i++) {sprintf(tmp,"Ext.%2d",i+1);o->add(tmp);};
          o->value(pars->VoicePar[nvoice].Pextoscil+1);
        } // Fl_Choice* o
        { Fl_Group* o = new Fl_Group(5, 525, 515, 45);
          o->box(FL_ENGRAVED_BOX);
          { WidgetPDial* o = new WidgetPDial(285, 540, 25, 25, "Stereo");
            o->tooltip("Stereo Spread");
            o->box(FL_ROUND_UP_BOX);
            o->color(FL_BACKGROUND_COLOR);
            o->selection_color(FL_INACTIVE_COLOR);
            o->labeltype(FL_NORMAL_LABEL);
            o->labelfont(0);
            o->labelsize(10);
            o->labelcolor(FL_FOREGROUND_COLOR);
            o->maximum(127);
            o->step(1);
            o->callback((Fl_Callback*)cb_Stereo);
            o->align(Fl_Align(FL_ALIGN_TOP));
            o->when(FL_WHEN_CHANGED);
            o->value(pars->VoicePar[nvoice].Unison_stereo_spread);
          } // WidgetPDial* o
          { Fl_Choice* o = new Fl_Choice(10, 545, 75, 20, "Unison");
            o->tooltip("Unison size");
            o->down_box(FL_BORDER_BOX);
            o->labelfont(1);
            o->textfont(1);
            o->textsize(10);
            o->callback((Fl_Callback*)cb_Unison);
            o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
            o->add("OFF");char tmp[100];for (int i=1;ADnote_unison_sizes[i];i++){snprintf(tmp,100,"size %d",ADnote_unison_sizes[i]);o->add(tmp);};
            o->value(pars->get_unison_size_index(nvoice));
          } // Fl_Choice* o
          { WidgetPDial* o = new WidgetPDial(340, 540, 25, 25, "Vibratto");
            o->tooltip("Vibratto");
            o->box(FL_ROUND_UP_BOX);
            o->color(FL_BACKGROUND_COLOR);
            o->selection_color(FL_INACTIVE_COLOR);
            o->labeltype(FL_NORMAL_LABEL);
            o->labelfont(0);
            o->labelsize(10);
            o->labelcolor(FL_FOREGROUND_COLOR);
            o->maximum(127);
            o->step(1);
            o->callback((Fl_Callback*)cb_Vibratto);
            o->align(Fl_Align(FL_ALIGN_TOP));
            o->when(FL_WHEN_CHANGED);
            o->value(pars->VoicePar[nvoice].Unison_vibratto);
          } // WidgetPDial* o
          { Fl_Choice* o = new Fl_Choice(445, 545, 65, 15, "Invert");
            o->tooltip("Phase Invert");
            o->down_box(FL_BORDER_BOX);
            o->labelsize(11);
            o->textfont(1);
            o->textsize(10);
            o->callback((Fl_Callback*)cb_Invert);
            o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
            o->add("None");o->add("Random");char tmp[100];for (int i=2;i<=5;i++){snprintf(tmp,100,"%d %%",100/i);o->add(tmp);};
            o->value(pars->VoicePar[nvoice].Unison_invert_phase);
          } // Fl_Choice* o
          { Fl_Slider* o = new Fl_Slider(95, 547, 125, 13, "Frequency Spread");
            o->tooltip("Frequency Spread of the Unison");
            o->type(5);
            o->box(FL_FLAT_BOX);
            o->labelsize(12);
            o->maximum(127);
            o->step(1);
            o->value(64);
            o->callback((Fl_Callback*)cb_Frequency);
            o->align(Fl_Align(FL_ALIGN_TOP));
            o->value(pars->VoicePar[nvoice].Unison_frequency_spread);
          } // Fl_Slider* o
          { Fl_Value_Output* o = unisonspreadoutput = new Fl_Value_Output(225, 545, 40, 15, "(cents)");
            unisonspreadoutput->labelsize(10);
            unisonspreadoutput->maximum(1000);
            unisonspreadoutput->step(0.1);
            unisonspreadoutput->textfont(1);
            unisonspreadoutput->textsize(10);
            unisonspreadoutput->callback((Fl_Callback*)cb_unisonspreadoutput);
            unisonspreadoutput->align(Fl_Align(FL_ALIGN_TOP_LEFT));
            o->value(pars->getUnisonFrequencySpreadCents(nvoice));
          } // Fl_Value_Output* unisonspreadoutput
          { WidgetPDial* o = new WidgetPDial(390, 540, 25, 25, "Vib.speed");
            o->tooltip("Vibratto Average Speed");
            o->box(FL_ROUND_UP_BOX);
            o->color(FL_BACKGROUND_COLOR);
            o->selection_color(FL_INACTIVE_COLOR);
            o->labeltype(FL_NORMAL_LABEL);
            o->labelfont(0);
            o->labelsize(10);
            o->labelcolor(FL_FOREGROUND_COLOR);
            o->maximum(127);
            o->step(1);
            o->callback((Fl_Callback*)cb_Vib);
            o->align(Fl_Align(FL_ALIGN_TOP));
            o->when(FL_WHEN_CHANGED);
            o->value(pars->VoicePar[nvoice].Unison_vibratto_speed);
          } // WidgetPDial* o
          o->end();
        } // Fl_Group* o
        voicemodegroup->end();
      } // Fl_Group* voicemodegroup
      { Fl_Group* o = new Fl_Group(5, 40, 240, 210, "AMPLITUDE");
        o->box(FL_THIN_UP_BOX);
        o->labeltype(FL_EMBOSSED_LABEL);
        o->labelfont(1);
        o->labelsize(13);
        o->align(Fl_Align(FL_ALIGN_TOP|FL_ALIGN_INSIDE));
        { Fl_Value_Slider* o = new Fl_Value_Slider(10, 60, 160, 15, "Vol");
          o->tooltip("Volume");
          o->type(5);
          o->box(FL_FLAT_BOX);
          o->labelsize(11);
          o->maximum(127);
          o->step(1);
          o->callback((Fl_Callback*)cb_Vol1);
          o->align(Fl_Align(FL_ALIGN_RIGHT));
          o->value(pars->VoicePar[nvoice].PVolume);
        } // Fl_Value_Slider* o
        { Fl_Value_Slider* o = new Fl_Value_Slider(10, 80, 160, 15, "V.Sns");
          o->tooltip("Velocity Sensing Function (rightmost to disable)");
          o->type(5);
          o->box(FL_FLAT_BOX);
          o->labelsize(11);
          o->maximum(127);
          o->step(1);
          o->callback((Fl_Callback*)cb_V1);
          o->align(Fl_Align(FL_ALIGN_RIGHT));
          o->value(pars->VoicePar[nvoice].PAmpVelocityScaleFunction);
        } // Fl_Value_Slider* o
        { EnvelopeUI* o = voiceampenvgroup = new EnvelopeUI(10, 105, 205, 70, "ADSynth Voice - Amplitude Envelope");
          voiceampenvgroup->box(FL_FLAT_BOX);
          voiceampenvgroup->color((Fl_Color)51);
          voiceampenvgroup->selection_color(FL_BACKGROUND_COLOR);
          voiceampenvgroup->labeltype(FL_NORMAL_LABEL);
          voiceampenvgroup->labelfont(0);
          voiceampenvgroup->labelsize(14);
          voiceampenvgroup->labelcolor(FL_FOREGROUND_COLOR);
          voiceampenvgroup->align(Fl_Align(FL_ALIGN_WRAP|FL_ALIGN_INSIDE));
          voiceampenvgroup->when(FL_WHEN_RELEASE);
          o->init(pars->VoicePar[nvoice].AmpEnvelope);
          if (pars->VoicePar[nvoice].PAmpEnvelopeEnabled==0) o->deactivate();
          voiceampenvgroup->end();
        } // EnvelopeUI* voiceampenvgroup
        { WidgetPDial* o = new WidgetPDial(210, 60, 30, 30, "Pan");
          o->tooltip("Panning (leftmost is Random)");
          o->box(FL_ROUND_UP_BOX);
          o->color(FL_BACKGROUND_COLOR);
          o->selection_color(FL_INACTIVE_COLOR);
          o->labeltype(FL_NORMAL_LABEL);
          o->labelfont(0);
          o->labelsize(10);
          o->labelcolor(FL_FOREGROUND_COLOR);
          o->maximum(127);
          o->step(1);
          o->callback((Fl_Callback*)cb_Pan);
          o->align(Fl_Align(FL_ALIGN_BOTTOM));
          o->when(FL_WHEN_CHANGED);
          o->value(pars->VoicePar[nvoice].PPanning);
        } // WidgetPDial* o
        { Fl_Check_Button* o = new Fl_Check_Button(15, 110, 50, 10, "Enable");
          o->tooltip("Forced Relase");
          o->down_box(FL_DOWN_BOX);
          o->labelfont(1);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_Enable4);
          o->value(pars->VoicePar[nvoice].PAmpEnvelopeEnabled);
        } // Fl_Check_Button* o
        { LFOUI* o = voiceamplfogroup = new LFOUI(10, 175, 230, 70, "Amplitude LFO     ");
          voiceamplfogroup->box(FL_FLAT_BOX);
          voiceamplfogroup->color(FL_DARK1);
          voiceamplfogroup->selection_color(FL_BACKGROUND_COLOR);
          voiceamplfogroup->labeltype(FL_NORMAL_LABEL);
          voiceamplfogroup->labelfont(0);
          voiceamplfogroup->labelsize(14);
          voiceamplfogroup->labelcolor(FL_FOREGROUND_COLOR);
          voiceamplfogroup->align(Fl_Align(FL_ALIGN_WRAP|FL_ALIGN_INSIDE));
          voiceamplfogroup->when(FL_WHEN_RELEASE);
          o->init(pars->VoicePar[nvoice].AmpLfo);
          if (pars->VoicePar[nvoice].PAmpLfoEnabled==0) o->deactivate();
          voiceamplfogroup->end();
        } // LFOUI* voiceamplfogroup
        { Fl_Check_Button* o = new Fl_Check_Button(15, 180, 55, 10, "Enable");
          o->tooltip("Forced Relase");
          o->down_box(FL_DOWN_BOX);
          o->labelfont(1);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_Enable5);
          o->value(pars->VoicePar[nvoice].PAmpLfoEnabled);
        } // Fl_Check_Button* o
        { Fl_Check_Button* o = new Fl_Check_Button(10, 45, 50, 10, "Minus");
          o->down_box(FL_DOWN_BOX);
          o->labelfont(1);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_Minus);
          o->value(pars->VoicePar[nvoice].PVolumeminus);
        } // Fl_Check_Button* o
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = voicefiltergroup = new Fl_Group(245, 5, 285, 245, "FILTER");
        voicefiltergroup->box(FL_THIN_UP_BOX);
        voicefiltergroup->labeltype(FL_EMBOSSED_LABEL);
        voicefiltergroup->labelfont(1);
        voicefiltergroup->labelsize(13);
        voicefiltergroup->align(Fl_Align(FL_ALIGN_TOP|FL_ALIGN_INSIDE));
        { FilterUI* o = new FilterUI(250, 30, 275, 75, "ADsynth Voice - Filter");
          o->box(FL_FLAT_BOX);
          o->color(FL_LIGHT1);
          o->selection_color(FL_BACKGROUND_COLOR);
          o->labeltype(FL_NORMAL_LABEL);
          o->labelfont(0);
          o->labelsize(14);
          o->labelcolor(FL_FOREGROUND_COLOR);
          o->align(Fl_Align(FL_ALIGN_WRAP|FL_ALIGN_INSIDE));
          o->when(FL_WHEN_RELEASE);
          o->init(pars->VoicePar[nvoice].VoiceFilter,NULL,NULL);
          o->end();
        } // FilterUI* o
        { EnvelopeUI* o = voicefilterenvgroup = new EnvelopeUI(250, 105, 275, 70, "ADSynth Voice - Filter Envelope");
          voicefilterenvgroup->box(FL_FLAT_BOX);
          voicefilterenvgroup->color((Fl_Color)51);
          voicefilterenvgroup->selection_color(FL_BACKGROUND_COLOR);
          voicefilterenvgroup->labeltype(FL_NORMAL_LABEL);
          voicefilterenvgroup->labelfont(0);
          voicefilterenvgroup->labelsize(14);
          voicefilterenvgroup->labelcolor(FL_FOREGROUND_COLOR);
          voicefilterenvgroup->align(Fl_Align(FL_ALIGN_WRAP|FL_ALIGN_INSIDE));
          voicefilterenvgroup->when(FL_WHEN_RELEASE);
          o->init(pars->VoicePar[nvoice].FilterEnvelope);
          if (pars->VoicePar[nvoice].PFilterEnvelopeEnabled==0) o->deactivate();
          voicefilterenvgroup->end();
        } // EnvelopeUI* voicefilterenvgroup
        { Fl_Check_Button* o = new Fl_Check_Button(255, 110, 55, 10, "Enable");
          o->tooltip("Forced Relase");
          o->down_box(FL_DOWN_BOX);
          o->labelfont(1);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_Enable6);
          o->value(pars->VoicePar[nvoice].PFilterEnvelopeEnabled);
        } // Fl_Check_Button* o
        { LFOUI* o = voicefilterlfogroup = new LFOUI(250, 175, 230, 70, "Filter LFO     ");
          voicefilterlfogroup->box(FL_FLAT_BOX);
          voicefilterlfogroup->color(FL_DARK1);
          voicefilterlfogroup->selection_color(FL_BACKGROUND_COLOR);
          voicefilterlfogroup->labeltype(FL_NORMAL_LABEL);
          voicefilterlfogroup->labelfont(0);
          voicefilterlfogroup->labelsize(14);
          voicefilterlfogroup->labelcolor(FL_FOREGROUND_COLOR);
          voicefilterlfogroup->align(Fl_Align(FL_ALIGN_WRAP|FL_ALIGN_INSIDE));
          voicefilterlfogroup->when(FL_WHEN_RELEASE);
          o->init(pars->VoicePar[nvoice].FilterLfo);
          if (pars->VoicePar[nvoice].PFilterLfoEnabled==0) o->deactivate();
          voicefilterlfogroup->end();
        } // LFOUI* voicefilterlfogroup
        { Fl_Check_Button* o = new Fl_Check_Button(255, 180, 55, 10, "Enable");
          o->tooltip("Forced Relase");
          o->down_box(FL_DOWN_BOX);
          o->labelfont(1);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_Enable7);
          o->value(pars->VoicePar[nvoice].PFilterLfoEnabled);
        } // Fl_Check_Button* o
        if (pars->VoicePar[nvoice].PFilterEnabled==0) o->deactivate();
        voicefiltergroup->end();
      } // Fl_Group* voicefiltergroup
      { Fl_Group* o = new Fl_Group(5, 5, 55, 35, "01");
        o->box(FL_THIN_UP_BOX);
        o->labeltype(FL_EMBOSSED_LABEL);
        o->labelfont(1);
        o->labelsize(22);
        o->align(Fl_Align(FL_ALIGN_CENTER|FL_ALIGN_INSIDE));
        char tmp[10];snprintf(tmp,10,"%d",nvoice+1);o->label(strdup(tmp));
        o->end();
      } // Fl_Group* o
      { Fl_Choice* o = new Fl_Choice(5, 500, 65, 20);
        o->tooltip("Oscillator Type (sound/noise)");
        o->down_box(FL_BORDER_BOX);
        o->labelsize(10);
        o->textfont(1);
        o->textsize(10);
        o->callback((Fl_Callback*)cb_2);
        o->menu(menu_);
        o->value(pars->VoicePar[nvoice].Type);
        if (pars->VoicePar[nvoice].Type!=0) voicemodegroup->deactivate();
      } // Fl_Choice* o
      { Fl_Check_Button* o = bypassfiltercheckbutton = new Fl_Check_Button(425, 10, 100, 20, "Bypass Global F.");
        bypassfiltercheckbutton->down_box(FL_DOWN_BOX);
        bypassfiltercheckbutton->labelfont(1);
        bypassfiltercheckbutton->labelsize(10);
        bypassfiltercheckbutton->callback((Fl_Callback*)cb_bypassfiltercheckbutton);
        bypassfiltercheckbutton->align(Fl_Align(132|FL_ALIGN_INSIDE));
        o->value(pars->VoicePar[nvoice].Pfilterbypass);
      } // Fl_Check_Button* bypassfiltercheckbutton
      { Fl_Group* o = new Fl_Group(115, 5, 95, 35);
        o->box(FL_THIN_UP_BOX);
        { Fl_Value_Slider* o = new Fl_Value_Slider(120, 21, 84, 12, "Delay");
          o->tooltip("Volume");
          o->type(5);
          o->box(FL_FLAT_BOX);
          o->labelsize(11);
          o->maximum(127);
          o->step(1);
          o->callback((Fl_Callback*)cb_Delay);
          o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
          o->value(pars->VoicePar[nvoice].PDelay);
        } // Fl_Value_Slider* o
        o->end();
      } // Fl_Group* o
      { Fl_Check_Button* o = new Fl_Check_Button(250, 15, 60, 15, "Enable");
        o->tooltip("Enable Filter");
        o->down_box(FL_DOWN_BOX);
        o->labelfont(1);
        o->labelsize(10);
        o->callback((Fl_Callback*)cb_Enable8);
        o->value(pars->VoicePar[nvoice].PFilterEnabled);
      } // Fl_Check_Button* o
      { Fl_Box* o = noiselabel = new Fl_Box(150, 415, 300, 65, "White Noise");
        noiselabel->labelfont(1);
        noiselabel->labelsize(50);
        noiselabel->labelcolor(FL_BACKGROUND2_COLOR);
        noiselabel->callback((Fl_Callback*)cb_noiselabel1);
        if (pars->VoicePar[nvoice].Type==0) o->hide(); else o->show();
      } // Fl_Box* noiselabel
      if (pars->VoicePar[nvoice].Enabled==0) o->deactivate();
      voiceparametersgroup->end();
    } // Fl_Group* voiceparametersgroup
    { Fl_Check_Button* o = voiceonbutton = new Fl_Check_Button(60, 5, 55, 35, "On");
      voiceonbutton->box(FL_THIN_UP_BOX);
      voiceonbutton->down_box(FL_DOWN_BOX);
      voiceonbutton->labelfont(1);
      voiceonbutton->labelsize(13);
      voiceonbutton->callback((Fl_Callback*)cb_voiceonbutton);
      o->value(pars->VoicePar[nvoice].Enabled);
    } // Fl_Check_Button* voiceonbutton
    ADnoteVoiceParameters->end();
  } // Fl_Group* ADnoteVoiceParameters
  return ADnoteVoiceParameters;
}

ADvoiceUI::ADvoiceUI(int x,int y, int w, int h, const char *label):Fl_Group(x,y,w,h,label) {
  nvoice=0;
pars=NULL;
oscedit=NULL;
}

void ADvoiceUI::init(ADnoteParameters *parameters,int nvoice_,Master *master_) {
  pars=parameters;
nvoice=nvoice_;
master=master_;
make_window();
end();
ADnoteVoiceParameters->show();
}

ADvoiceUI::~ADvoiceUI() {
  ADnoteVoiceParameters->hide();
hide();
if (oscedit!=NULL) {
    delete(oscedit);
};
//delete (ADnoteVoiceParameters);
}

void ADnoteUI::cb_octave_i(Fl_Counter* o, void*) {
  int k=(int) o->value();
if (k<0) k+=16;
pars->GlobalPar.PCoarseDetune = k*1024+
   pars->GlobalPar.PCoarseDetune%1024;
}
void ADnoteUI::cb_octave(Fl_Counter* o, void* v) {
  ((ADnoteUI*)(o->parent()->parent()->user_data()))->cb_octave_i(o,v);
}

void ADnoteUI::cb_coarsedet_i(Fl_Counter* o, void*) {
  int k=(int) o->value();
if (k<0) k+=1024;
pars->GlobalPar.PCoarseDetune = k+
   (pars->GlobalPar.PCoarseDetune/1024)*1024;
}
void ADnoteUI::cb_coarsedet(Fl_Counter* o, void* v) {
  ((ADnoteUI*)(o->parent()->parent()->user_data()))->cb_coarsedet_i(o,v);
}

void ADnoteUI::cb_freq_i(Fl_Slider* o, void*) {
  pars->GlobalPar.PDetune=(int)o->value()+8192;
detunevalueoutput->do_callback();
}
void ADnoteUI::cb_freq(Fl_Slider* o, void* v) {
  ((ADnoteUI*)(o->parent()->parent()->user_data()))->cb_freq_i(o,v);
}

void ADnoteUI::cb_detunevalueoutput2_i(Fl_Value_Output* o, void*) {
  o->value(getdetune(pars->GlobalPar.PDetuneType,0,pars->GlobalPar.PDetune));
}
void ADnoteUI::cb_detunevalueoutput2(Fl_Value_Output* o, void* v) {
  ((ADnoteUI*)(o->parent()->parent()->user_data()))->cb_detunevalueoutput2_i(o,v);
}

void ADnoteUI::cb_detunetype_i(Fl_Choice* o, void*) {
  pars->GlobalPar.PDetuneType=(int) o->value()+1;
detunevalueoutput->do_callback();
}
void ADnoteUI::cb_detunetype(Fl_Choice* o, void* v) {
  ((ADnoteUI*)(o->parent()->parent()->user_data()))->cb_detunetype_i(o,v);
}

void ADnoteUI::cb_relBW_i(WidgetPDial* o, void*) {
  pars->GlobalPar.PBandwidth=(int) o->value();

pars->getBandwidthDetuneMultiplier();

for (int i=0;i<NUM_VOICES;i++){
  voicelistitem[i]->refreshlist();
};
}
void ADnoteUI::cb_relBW(WidgetPDial* o, void* v) {
  ((ADnoteUI*)(o->parent()->parent()->user_data()))->cb_relBW_i(o,v);
}

void ADnoteUI::cb_volume_i(Fl_Value_Slider* o, void*) {
  pars->GlobalPar.PVolume=(int)o->value();
}
void ADnoteUI::cb_volume(Fl_Value_Slider* o, void* v) {
  ((ADnoteUI*)(o->parent()->parent()->user_data()))->cb_volume_i(o,v);
}

void ADnoteUI::cb_vsns_i(Fl_Value_Slider* o, void*) {
  pars->GlobalPar.PAmpVelocityScaleFunction=(int) o->value();
}
void ADnoteUI::cb_vsns(Fl_Value_Slider* o, void* v) {
  ((ADnoteUI*)(o->parent()->parent()->user_data()))->cb_vsns_i(o,v);
}

void ADnoteUI::cb_pan_i(WidgetPDial* o, void*) {
  pars->GlobalPar.PPanning=(int) o->value();
}
void ADnoteUI::cb_pan(WidgetPDial* o, void* v) {
  ((ADnoteUI*)(o->parent()->parent()->user_data()))->cb_pan_i(o,v);
}

void ADnoteUI::cb_pstr_i(WidgetPDial* o, void*) {
  pars->GlobalPar.PPunchStrength=(int) o->value();
}
void ADnoteUI::cb_pstr(WidgetPDial* o, void* v) {
  ((ADnoteUI*)(o->parent()->parent()->user_data()))->cb_pstr_i(o,v);
}

void ADnoteUI::cb_pt_i(WidgetPDial* o, void*) {
  pars->GlobalPar.PPunchTime=(int) o->value();
}
void ADnoteUI::cb_pt(WidgetPDial* o, void* v) {
  ((ADnoteUI*)(o->parent()->parent()->user_data()))->cb_pt_i(o,v);
}

void ADnoteUI::cb_pstc_i(WidgetPDial* o, void*) {
  pars->GlobalPar.PPunchStretch=(int) o->value();
}
void ADnoteUI::cb_pstc(WidgetPDial* o, void* v) {
  ((ADnoteUI*)(o->parent()->parent()->user_data()))->cb_pstc_i(o,v);
}

void ADnoteUI::cb_pvel_i(WidgetPDial* o, void*) {
  pars->GlobalPar.PPunchVelocitySensing=(int) o->value();
}
void ADnoteUI::cb_pvel(WidgetPDial* o, void* v) {
  ((ADnoteUI*)(o->parent()->parent()->user_data()))->cb_pvel_i(o,v);
}

void ADnoteUI::cb_rndgrp_i(Fl_Check_Button* o, void*) {
  pars->GlobalPar.Hrandgrouping=(int) o->value();
}
void ADnoteUI::cb_rndgrp(Fl_Check_Button* o, void* v) {
  ((ADnoteUI*)(o->parent()->parent()->user_data()))->cb_rndgrp_i(o,v);
}

void ADnoteUI::cb_stereo_i(Fl_Check_Button* o, void*) {
  pars->GlobalPar.PStereo=(int) o->value();
}
void ADnoteUI::cb_stereo(Fl_Check_Button* o, void* v) {
  ((ADnoteUI*)(o->parent()->user_data()))->cb_stereo_i(o,v);
}

void ADnoteUI::cb_Show_i(Fl_Button*, void*) {
  for (int i=0;i<NUM_VOICES;i++){
  voicelistitem[i]->refreshlist();
}
ADnoteVoiceList->show();
}
void ADnoteUI::cb_Show(Fl_Button* o, void* v) {
  ((ADnoteUI*)(o->parent()->user_data()))->cb_Show_i(o,v);
}

void ADnoteUI::cb_Show1_i(Fl_Button*, void*) {
  ADnoteVoice->show();
}
void ADnoteUI::cb_Show1(Fl_Button* o, void* v) {
  ((ADnoteUI*)(o->parent()->user_data()))->cb_Show1_i(o,v);
}

void ADnoteUI::cb_Close_i(Fl_Button*, void*) {
  ADnoteGlobalParameters->hide();
}
void ADnoteUI::cb_Close(Fl_Button* o, void* v) {
  ((ADnoteUI*)(o->parent()->user_data()))->cb_Close_i(o,v);
}

void ADnoteUI::cb_Resonance_i(Fl_Button*, void*) {
  resui->resonancewindow->redraw();
resui->resonancewindow->show();
}
void ADnoteUI::cb_Resonance(Fl_Button* o, void* v) {
  ((ADnoteUI*)(o->parent()->user_data()))->cb_Resonance_i(o,v);
}

void ADnoteUI::cb_C_i(Fl_Button*, void*) {
  presetsui->copy(pars);
}
void ADnoteUI::cb_C(Fl_Button* o, void* v) {
  ((ADnoteUI*)(o->parent()->user_data()))->cb_C_i(o,v);
}

void ADnoteUI::cb_P_i(Fl_Button*, void*) {
  presetsui->paste(pars,this);
}
void ADnoteUI::cb_P(Fl_Button* o, void* v) {
  ((ADnoteUI*)(o->parent()->user_data()))->cb_P_i(o,v);
}

void ADnoteUI::cb_Close1_i(Fl_Button*, void*) {
  ADnoteVoice->hide();
}
void ADnoteUI::cb_Close1(Fl_Button* o, void* v) {
  ((ADnoteUI*)(o->parent()->user_data()))->cb_Close1_i(o,v);
}

void ADnoteUI::cb_currentvoicecounter_i(Fl_Counter* o, void*) {
  nvoice=(int)o->value()-1;
advoice->hide();
ADnoteVoice->remove(advoice);
delete advoice;
advoice=new ADvoiceUI(0,0,765,585);
ADnoteVoice->add(advoice);
advoice->init(pars,nvoice,master);
advoice->show();
ADnoteVoice->redraw();
}
void ADnoteUI::cb_currentvoicecounter(Fl_Counter* o, void* v) {
  ((ADnoteUI*)(o->parent()->user_data()))->cb_currentvoicecounter_i(o,v);
}

void ADnoteUI::cb_C1_i(Fl_Button*, void*) {
  presetsui->copy(pars,nvoice);
}
void ADnoteUI::cb_C1(Fl_Button* o, void* v) {
  ((ADnoteUI*)(o->parent()->user_data()))->cb_C1_i(o,v);
}

void ADnoteUI::cb_P1_i(Fl_Button*, void*) {
  presetsui->paste(pars,this,nvoice);
}
void ADnoteUI::cb_P1(Fl_Button* o, void* v) {
  ((ADnoteUI*)(o->parent()->user_data()))->cb_P1_i(o,v);
}

void ADnoteUI::cb_Hide_i(Fl_Button*, void*) {
  ADnoteVoiceList->hide();
}
void ADnoteUI::cb_Hide(Fl_Button* o, void* v) {
  ((ADnoteUI*)(o->parent()->user_data()))->cb_Hide_i(o,v);
}

Fl_Double_Window* ADnoteUI::make_window() {
  { ADnoteGlobalParameters = new Fl_Double_Window(535, 405, "ADsynth Global Parameters of the Instrument");
    ADnoteGlobalParameters->user_data((void*)(this));
    { Fl_Group* o = new Fl_Group(5, 255, 525, 115, "FREQUENCY");
      o->box(FL_THIN_UP_BOX);
      o->labeltype(FL_EMBOSSED_LABEL);
      o->labelfont(1);
      o->labelsize(13);
      o->align(Fl_Align(FL_ALIGN_TOP|FL_ALIGN_INSIDE));
      { EnvelopeUI* o = freqenv = new EnvelopeUI(10, 295, 205, 70, "ADSynth Global - Frequency Envelope");
        freqenv->box(FL_FLAT_BOX);
        freqenv->color((Fl_Color)51);
        freqenv->selection_color(FL_BACKGROUND_COLOR);
        freqenv->labeltype(FL_NORMAL_LABEL);
        freqenv->labelfont(0);
        freqenv->labelsize(14);
        freqenv->labelcolor(FL_FOREGROUND_COLOR);
        freqenv->align(Fl_Align(FL_ALIGN_WRAP|FL_ALIGN_INSIDE));
        freqenv->when(FL_WHEN_RELEASE);
        o->init(pars->GlobalPar.FreqEnvelope);
        freqenv->end();
      } // EnvelopeUI* freqenv
      { Fl_Counter* o = octave = new Fl_Counter(450, 275, 45, 15, "Octave");
        octave->tooltip("Octave");
        octave->type(1);
        octave->labelsize(10);
        octave->minimum(-8);
        octave->maximum(7);
        octave->step(1);
        octave->textfont(1);
        octave->textsize(11);
        octave->callback((Fl_Callback*)cb_octave);
        octave->align(Fl_Align(FL_ALIGN_TOP));
        int k=pars->GlobalPar.PCoarseDetune/1024;if (k>=8) k-=16;
        o->value(k);
      } // Fl_Counter* octave
      { Fl_Counter* o = coarsedet = new Fl_Counter(455, 345, 60, 20, "Coarse det.");
        coarsedet->tooltip("Coarse Detune");
        coarsedet->labelsize(10);
        coarsedet->minimum(-64);
        coarsedet->maximum(63);
        coarsedet->step(1);
        coarsedet->textfont(1);
        coarsedet->textsize(11);
        coarsedet->callback((Fl_Callback*)cb_coarsedet);
        coarsedet->align(Fl_Align(FL_ALIGN_TOP_LEFT));
        int k=pars->GlobalPar.PCoarseDetune%1024;if (k>=512) k-=1024;
        o->value(k);
        o->lstep(10);
      } // Fl_Counter* coarsedet
      { LFOUI* o = freqlfo = new LFOUI(215, 295, 230, 70, "Frequency LFO     ");
        freqlfo->box(FL_FLAT_BOX);
        freqlfo->color(FL_DARK1);
        freqlfo->selection_color(FL_BACKGROUND_COLOR);
        freqlfo->labeltype(FL_NORMAL_LABEL);
        freqlfo->labelfont(0);
        freqlfo->labelsize(14);
        freqlfo->labelcolor(FL_FOREGROUND_COLOR);
        freqlfo->align(Fl_Align(FL_ALIGN_WRAP|FL_ALIGN_INSIDE));
        freqlfo->when(FL_WHEN_RELEASE);
        o->init(pars->GlobalPar.FreqLfo);
        freqlfo->end();
      } // LFOUI* freqlfo
      { Fl_Slider* o = freq = new Fl_Slider(60, 275, 385, 15);
        freq->tooltip("Fine Detune (cents)");
        freq->type(5);
        freq->box(FL_FLAT_BOX);
        freq->minimum(-8192);
        freq->maximum(8191);
        freq->step(1);
        freq->callback((Fl_Callback*)cb_freq);
        o->value(pars->GlobalPar.PDetune-8192);
      } // Fl_Slider* freq
      { Fl_Value_Output* o = detunevalueoutput = new Fl_Value_Output(12, 275, 45, 15, "Detune");
        detunevalueoutput->labelsize(10);
        detunevalueoutput->minimum(-5000);
        detunevalueoutput->maximum(5000);
        detunevalueoutput->step(0.01);
        detunevalueoutput->textfont(1);
        detunevalueoutput->textsize(10);
        detunevalueoutput->callback((Fl_Callback*)cb_detunevalueoutput2);
        detunevalueoutput->align(Fl_Align(FL_ALIGN_TOP_LEFT));
        o->value(getdetune(pars->GlobalPar.PDetuneType,0,pars->GlobalPar.PDetune));
      } // Fl_Value_Output* detunevalueoutput
      { Fl_Choice* o = detunetype = new Fl_Choice(450, 315, 75, 15, "Detune Type");
        detunetype->down_box(FL_BORDER_BOX);
        detunetype->labelsize(10);
        detunetype->textfont(1);
        detunetype->textsize(10);
        detunetype->callback((Fl_Callback*)cb_detunetype);
        detunetype->align(Fl_Align(FL_ALIGN_TOP_LEFT));
        o->add("L35cents");o->add("L10cents");o->add("E100cents");o->add("E1200cents");
        o->value(pars->GlobalPar.PDetuneType-1);
      } // Fl_Choice* detunetype
      { WidgetPDial* o = new WidgetPDial(500, 270, 25, 25, "relBW");
        o->tooltip("Bandwidth - how the relative fine detune of the voice are changed");
        o->box(FL_ROUND_UP_BOX);
        o->color(FL_BACKGROUND_COLOR);
        o->selection_color(FL_INACTIVE_COLOR);
        o->labeltype(FL_NORMAL_LABEL);
        o->labelfont(0);
        o->labelsize(10);
        o->labelcolor(FL_FOREGROUND_COLOR);
        o->maximum(127);
        o->step(1);
        o->callback((Fl_Callback*)cb_relBW);
        o->align(Fl_Align(FL_ALIGN_TOP));
        o->when(FL_WHEN_CHANGED);
        o->value(pars->GlobalPar.PBandwidth);
      } // WidgetPDial* o
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(5, 5, 240, 250, "AMPLITUDE");
      o->box(FL_THIN_UP_FRAME);
      o->labeltype(FL_EMBOSSED_LABEL);
      o->labelfont(1);
      o->labelsize(13);
      o->align(Fl_Align(FL_ALIGN_TOP|FL_ALIGN_INSIDE));
      { Fl_Value_Slider* o = volume = new Fl_Value_Slider(10, 30, 160, 15, "Vol");
        volume->tooltip("Volume");
        volume->type(5);
        volume->box(FL_FLAT_BOX);
        volume->labelsize(11);
        volume->maximum(127);
        volume->step(1);
        volume->callback((Fl_Callback*)cb_volume);
        volume->align(Fl_Align(FL_ALIGN_RIGHT));
        o->value(pars->GlobalPar.PVolume);
      } // Fl_Value_Slider* volume
      { Fl_Value_Slider* o = vsns = new Fl_Value_Slider(10, 50, 160, 15, "V.Sns");
        vsns->tooltip("Velocity Sensing Function (rightmost to disable)");
        vsns->type(5);
        vsns->box(FL_FLAT_BOX);
        vsns->labelsize(11);
        vsns->maximum(127);
        vsns->step(1);
        vsns->callback((Fl_Callback*)cb_vsns);
        vsns->align(Fl_Align(FL_ALIGN_RIGHT));
        o->value(pars->GlobalPar.PAmpVelocityScaleFunction);
      } // Fl_Value_Slider* vsns
      { WidgetPDial* o = pan = new WidgetPDial(210, 25, 30, 30, "Pan");
        pan->tooltip("Panning (leftmost is Random)");
        pan->box(FL_ROUND_UP_BOX);
        pan->color(FL_BACKGROUND_COLOR);
        pan->selection_color(FL_INACTIVE_COLOR);
        pan->labeltype(FL_NORMAL_LABEL);
        pan->labelfont(0);
        pan->labelsize(10);
        pan->labelcolor(FL_FOREGROUND_COLOR);
        pan->maximum(127);
        pan->step(1);
        pan->callback((Fl_Callback*)cb_pan);
        pan->align(Fl_Align(FL_ALIGN_BOTTOM));
        pan->when(FL_WHEN_CHANGED);
        o->value(pars->GlobalPar.PPanning);
      } // WidgetPDial* pan
      { WidgetPDial* o = pstr = new WidgetPDial(125, 227, 25, 25, "P.Str.");
        pstr->tooltip("Punch Strength");
        pstr->box(FL_ROUND_UP_BOX);
        pstr->color(FL_BACKGROUND_COLOR);
        pstr->selection_color(FL_INACTIVE_COLOR);
        pstr->labeltype(FL_NORMAL_LABEL);
        pstr->labelfont(0);
        pstr->labelsize(10);
        pstr->labelcolor(FL_FOREGROUND_COLOR);
        pstr->maximum(127);
        pstr->step(1);
        pstr->callback((Fl_Callback*)cb_pstr);
        pstr->align(Fl_Align(FL_ALIGN_TOP));
        pstr->when(FL_WHEN_CHANGED);
        o->value(pars->GlobalPar.PPunchStrength);
      } // WidgetPDial* pstr
      { WidgetPDial* o = pt = new WidgetPDial(155, 227, 25, 25, "P.t.");
        pt->tooltip("Punch Time (duration)");
        pt->box(FL_ROUND_UP_BOX);
        pt->color(FL_BACKGROUND_COLOR);
        pt->selection_color(FL_INACTIVE_COLOR);
        pt->labeltype(FL_NORMAL_LABEL);
        pt->labelfont(0);
        pt->labelsize(10);
        pt->labelcolor(FL_FOREGROUND_COLOR);
        pt->maximum(127);
        pt->step(1);
        pt->callback((Fl_Callback*)cb_pt);
        pt->align(Fl_Align(FL_ALIGN_TOP));
        pt->when(FL_WHEN_CHANGED);
        o->value(pars->GlobalPar.PPunchTime);
      } // WidgetPDial* pt
      { WidgetPDial* o = pstc = new WidgetPDial(185, 227, 25, 25, "P.Stc.");
        pstc->tooltip("Punch Stretch");
        pstc->box(FL_ROUND_UP_BOX);
        pstc->color(FL_BACKGROUND_COLOR);
        pstc->selection_color(FL_INACTIVE_COLOR);
        pstc->labeltype(FL_NORMAL_LABEL);
        pstc->labelfont(0);
        pstc->labelsize(10);
        pstc->labelcolor(FL_FOREGROUND_COLOR);
        pstc->maximum(127);
        pstc->step(1);
        pstc->callback((Fl_Callback*)cb_pstc);
        pstc->align(Fl_Align(FL_ALIGN_TOP));
        pstc->when(FL_WHEN_CHANGED);
        o->value(pars->GlobalPar.PPunchStretch);
      } // WidgetPDial* pstc
      { WidgetPDial* o = pvel = new WidgetPDial(215, 227, 25, 25, "P.Vel.");
        pvel->tooltip("Punch Velocity Sensing");
        pvel->box(FL_ROUND_UP_BOX);
        pvel->color(FL_BACKGROUND_COLOR);
        pvel->selection_color(FL_INACTIVE_COLOR);
        pvel->labeltype(FL_NORMAL_LABEL);
        pvel->labelfont(0);
        pvel->labelsize(10);
        pvel->labelcolor(FL_FOREGROUND_COLOR);
        pvel->maximum(127);
        pvel->step(1);
        pvel->callback((Fl_Callback*)cb_pvel);
        pvel->align(Fl_Align(FL_ALIGN_TOP));
        pvel->when(FL_WHEN_CHANGED);
        o->value(pars->GlobalPar.PPunchVelocitySensing);
      } // WidgetPDial* pvel
      { EnvelopeUI* o = ampenv = new EnvelopeUI(10, 75, 205, 70, "ADSynth Global - Amplitude Envelope");
        ampenv->box(FL_FLAT_BOX);
        ampenv->color((Fl_Color)51);
        ampenv->selection_color(FL_BACKGROUND_COLOR);
        ampenv->labeltype(FL_NORMAL_LABEL);
        ampenv->labelfont(0);
        ampenv->labelsize(14);
        ampenv->labelcolor(FL_FOREGROUND_COLOR);
        ampenv->align(Fl_Align(FL_ALIGN_WRAP|FL_ALIGN_INSIDE));
        ampenv->when(FL_WHEN_RELEASE);
        o->init(pars->GlobalPar.AmpEnvelope);
        ampenv->end();
      } // EnvelopeUI* ampenv
      { LFOUI* o = amplfo = new LFOUI(10, 145, 230, 70, "Amplitude LFO          ");
        amplfo->box(FL_FLAT_BOX);
        amplfo->color(FL_DARK1);
        amplfo->selection_color(FL_BACKGROUND_COLOR);
        amplfo->labeltype(FL_NORMAL_LABEL);
        amplfo->labelfont(0);
        amplfo->labelsize(14);
        amplfo->labelcolor(FL_FOREGROUND_COLOR);
        amplfo->align(Fl_Align(FL_ALIGN_WRAP|FL_ALIGN_INSIDE));
        amplfo->when(FL_WHEN_RELEASE);
        o->init(pars->GlobalPar.AmpLfo);
        amplfo->end();
      } // LFOUI* amplfo
      { Fl_Check_Button* o = rndgrp = new Fl_Check_Button(70, 225, 40, 25, "Rnd Grp");
        rndgrp->tooltip("How the Harmonic Amplitude is applied to voices that use the same oscillator");
        rndgrp->down_box(FL_DOWN_BOX);
        rndgrp->labelsize(10);
        rndgrp->callback((Fl_Callback*)cb_rndgrp);
        rndgrp->align(Fl_Align(132|FL_ALIGN_INSIDE));
        o->value(pars->GlobalPar.Hrandgrouping);
      } // Fl_Check_Button* rndgrp
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(245, 5, 285, 250, "FILTER");
      o->box(FL_THIN_UP_BOX);
      o->labeltype(FL_EMBOSSED_LABEL);
      o->labelfont(1);
      o->labelsize(13);
      o->align(Fl_Align(FL_ALIGN_TOP|FL_ALIGN_INSIDE));
      { EnvelopeUI* o = filterenv = new EnvelopeUI(250, 110, 275, 70, "ADSynth Global - Filter Envelope");
        filterenv->box(FL_FLAT_BOX);
        filterenv->color((Fl_Color)51);
        filterenv->selection_color(FL_BACKGROUND_COLOR);
        filterenv->labeltype(FL_NORMAL_LABEL);
        filterenv->labelfont(0);
        filterenv->labelsize(14);
        filterenv->labelcolor(FL_FOREGROUND_COLOR);
        filterenv->align(Fl_Align(FL_ALIGN_WRAP|FL_ALIGN_INSIDE));
        filterenv->when(FL_WHEN_RELEASE);
        o->init(pars->GlobalPar.FilterEnvelope);
        filterenv->end();
      } // EnvelopeUI* filterenv
      { LFOUI* o = filterlfo = new LFOUI(250, 180, 230, 70, "Filter LFO");
        filterlfo->box(FL_FLAT_BOX);
        filterlfo->color(FL_DARK1);
        filterlfo->selection_color(FL_BACKGROUND_COLOR);
        filterlfo->labeltype(FL_NORMAL_LABEL);
        filterlfo->labelfont(0);
        filterlfo->labelsize(14);
        filterlfo->labelcolor(FL_FOREGROUND_COLOR);
        filterlfo->align(Fl_Align(FL_ALIGN_WRAP|FL_ALIGN_INSIDE));
        filterlfo->when(FL_WHEN_RELEASE);
        o->init(pars->GlobalPar.FilterLfo);
        filterlfo->end();
      } // LFOUI* filterlfo
      { FilterUI* o = filterui = new FilterUI(250, 35, 275, 75, "ADsynth Global - Filter");
        filterui->box(FL_FLAT_BOX);
        filterui->color(FL_LIGHT1);
        filterui->selection_color(FL_BACKGROUND_COLOR);
        filterui->labeltype(FL_NORMAL_LABEL);
        filterui->labelfont(0);
        filterui->labelsize(14);
        filterui->labelcolor(FL_FOREGROUND_COLOR);
        filterui->align(Fl_Align(FL_ALIGN_WRAP|FL_ALIGN_INSIDE));
        filterui->when(FL_WHEN_RELEASE);
        o->init(pars->GlobalPar.GlobalFilter,&pars->GlobalPar.PFilterVelocityScale,&pars->GlobalPar.PFilterVelocityScaleFunction);
        filterui->end();
      } // FilterUI* filterui
      o->end();
    } // Fl_Group* o
    { Fl_Check_Button* o = stereo = new Fl_Check_Button(5, 220, 65, 35, "Stereo");
      stereo->box(FL_ENGRAVED_BOX);
      stereo->down_box(FL_DOWN_BOX);
      stereo->labelfont(1);
      stereo->labelsize(11);
      stereo->callback((Fl_Callback*)cb_stereo);
      o->value(pars->GlobalPar.PStereo);
    } // Fl_Check_Button* stereo
    { Fl_Button* o = new Fl_Button(180, 375, 125, 25, "Show Voice List");
      o->callback((Fl_Callback*)cb_Show);
    } // Fl_Button* o
    { Fl_Button* o = new Fl_Button(5, 375, 170, 25, "Show Voice Parameters");
      o->labelfont(1);
      o->labelsize(12);
      o->callback((Fl_Callback*)cb_Show1);
    } // Fl_Button* o
    { Fl_Button* o = new Fl_Button(470, 375, 60, 25, "Close");
      o->box(FL_THIN_UP_BOX);
      o->callback((Fl_Callback*)cb_Close);
    } // Fl_Button* o
    { Fl_Button* o = new Fl_Button(309, 375, 86, 25, "Resonance");
      o->tooltip("Resonance");
      o->box(FL_THIN_UP_BOX);
      o->callback((Fl_Callback*)cb_Resonance);
    } // Fl_Button* o
    { Fl_Button* o = new Fl_Button(405, 380, 25, 15, "C");
      o->box(FL_THIN_UP_BOX);
      o->color((Fl_Color)179);
      o->labelfont(1);
      o->labelsize(11);
      o->labelcolor(FL_BACKGROUND2_COLOR);
      o->callback((Fl_Callback*)cb_C);
    } // Fl_Button* o
    { Fl_Button* o = new Fl_Button(435, 380, 25, 15, "P");
      o->box(FL_THIN_UP_BOX);
      o->color((Fl_Color)179);
      o->labelfont(1);
      o->labelsize(11);
      o->labelcolor(FL_BACKGROUND2_COLOR);
      o->callback((Fl_Callback*)cb_P);
    } // Fl_Button* o
    ADnoteGlobalParameters->end();
  } // Fl_Double_Window* ADnoteGlobalParameters
  { ADnoteVoice = new Fl_Double_Window(765, 620, "ADsynth Voice Parameters");
    ADnoteVoice->user_data((void*)(this));
    { ADvoiceUI* o = advoice = new ADvoiceUI(0, 0, 760, 575);
      advoice->box(FL_BORDER_BOX);
      advoice->color(FL_BACKGROUND_COLOR);
      advoice->selection_color(FL_BACKGROUND_COLOR);
      advoice->labeltype(FL_NORMAL_LABEL);
      advoice->labelfont(0);
      advoice->labelsize(14);
      advoice->labelcolor(FL_FOREGROUND_COLOR);
      advoice->align(Fl_Align(FL_ALIGN_TOP));
      advoice->when(FL_WHEN_RELEASE);
      o->init(pars,nvoice,master);
      o->show();
      advoice->end();
    } // ADvoiceUI* advoice
    { Fl_Button* o = new Fl_Button(300, 585, 195, 25, "Close Window");
      o->box(FL_THIN_UP_BOX);
      o->labelfont(1);
      o->callback((Fl_Callback*)cb_Close1);
    } // Fl_Button* o
    { Fl_Counter* o = currentvoicecounter = new Fl_Counter(5, 585, 130, 25, "Current Voice");
      currentvoicecounter->type(1);
      currentvoicecounter->labelfont(1);
      currentvoicecounter->minimum(0);
      currentvoicecounter->maximum(2);
      currentvoicecounter->step(1);
      currentvoicecounter->value(1);
      currentvoicecounter->textfont(1);
      currentvoicecounter->textsize(13);
      currentvoicecounter->callback((Fl_Callback*)cb_currentvoicecounter);
      currentvoicecounter->align(Fl_Align(FL_ALIGN_RIGHT));
      o->bounds(1,NUM_VOICES);
    } // Fl_Counter* currentvoicecounter
    { Fl_Button* o = new Fl_Button(700, 590, 25, 15, "C");
      o->box(FL_THIN_UP_BOX);
      o->color((Fl_Color)179);
      o->labelfont(1);
      o->labelsize(11);
      o->labelcolor(FL_BACKGROUND2_COLOR);
      o->callback((Fl_Callback*)cb_C1);
    } // Fl_Button* o
    { Fl_Button* o = new Fl_Button(730, 590, 25, 15, "P");
      o->box(FL_THIN_UP_BOX);
      o->color((Fl_Color)179);
      o->labelfont(1);
      o->labelsize(11);
      o->labelcolor(FL_BACKGROUND2_COLOR);
      o->callback((Fl_Callback*)cb_P1);
    } // Fl_Button* o
    ADnoteVoice->end();
  } // Fl_Double_Window* ADnoteVoice
  { ADnoteVoiceList = new Fl_Double_Window(650, 260, "ADsynth Voices list");
    ADnoteVoiceList->user_data((void*)(this));
    { Fl_Text_Display* o = new Fl_Text_Display(10, 15, 30, 10, "No.");
      o->box(FL_NO_BOX);
      o->labelfont(1);
      o->labelsize(11);
    } // Fl_Text_Display* o
    { Fl_Text_Display* o = new Fl_Text_Display(145, 15, 30, 10, "Vol");
      o->box(FL_NO_BOX);
      o->labelfont(1);
      o->labelsize(11);
    } // Fl_Text_Display* o
    { Fl_Text_Display* o = new Fl_Text_Display(384, 15, 25, 10, "Detune");
      o->box(FL_NO_BOX);
      o->labelfont(1);
      o->labelsize(11);
    } // Fl_Text_Display* o
    { Fl_Text_Display* o = new Fl_Text_Display(210, 15, 30, 10, "Pan");
      o->box(FL_NO_BOX);
      o->labelfont(1);
      o->labelsize(11);
    } // Fl_Text_Display* o
    { Fl_Text_Display* o = new Fl_Text_Display(560, 15, 30, 10, "Vib. Depth");
      o->box(FL_NO_BOX);
      o->labelfont(1);
      o->labelsize(11);
    } // Fl_Text_Display* o
    { Fl_Text_Display* o = new Fl_Text_Display(245, 15, 25, 10, "R.");
      o->box(FL_NO_BOX);
      o->labelfont(1);
      o->labelsize(11);
    } // Fl_Text_Display* o
    { Fl_Button* o = new Fl_Button(255, 237, 125, 20, "Hide Voice List");
      o->callback((Fl_Callback*)cb_Hide);
    } // Fl_Button* o
    { Fl_Scroll* o = new Fl_Scroll(0, 15, 640, 220);
      o->type(2);
      o->box(FL_THIN_UP_BOX);
      { Fl_Pack* o = new Fl_Pack(0, 20, 620, 210);
        for (int i=0;i<NUM_VOICES;i++){voicelistitem[i]=new ADvoicelistitem(0,0,620,25,"");voicelistitem[i]->init(pars,i,master);}
        o->end();
      } // Fl_Pack* o
      o->end();
    } // Fl_Scroll* o
    ADnoteVoiceList->end();
  } // Fl_Double_Window* ADnoteVoiceList
  return ADnoteVoiceList;
}

ADnoteUI::ADnoteUI(ADnoteParameters *parameters,Master *master_) {
  pars=parameters;
master=master_;
nvoice=0;
resui=new ResonanceUI(pars->GlobalPar.Reson);
make_window();
}

ADnoteUI::~ADnoteUI() {
  ADnoteVoiceList->hide();
ADnoteGlobalParameters->hide();
ADnoteVoice->hide();
delete(ADnoteVoiceList);
delete(ADnoteGlobalParameters);
delete(ADnoteVoice);
delete(resui);
}

void ADnoteUI::refresh() {
  volume->value(pars->GlobalPar.PVolume);
vsns->value(pars->GlobalPar.PAmpVelocityScaleFunction);
pan->value(pars->GlobalPar.PPanning);

stereo->value(pars->GlobalPar.PStereo);
rndgrp->value(pars->GlobalPar.Hrandgrouping);

pstr->value(pars->GlobalPar.PPunchStrength);
pt->value(pars->GlobalPar.PPunchTime);
pstc->value(pars->GlobalPar.PPunchStretch);
pvel->value(pars->GlobalPar.PPunchVelocitySensing);

detunevalueoutput->value(getdetune(pars->GlobalPar.PDetuneType,0,pars->GlobalPar.PDetune));
freq->value(pars->GlobalPar.PDetune-8192);

int k=pars->GlobalPar.PCoarseDetune/1024;if (k>=8) k-=16;
octave->value(k);

detunetype->value(pars->GlobalPar.PDetuneType-1);
k=pars->GlobalPar.PCoarseDetune%1024;if (k>=512) k-=1024;
coarsedet->value(k);
amplfo->refresh();
freqlfo->refresh();
filterlfo->refresh();

ampenv->refresh();
freqenv->refresh();
filterenv->refresh();
filterui->refresh();

for (int i=0;i<NUM_VOICES;i++) voicelistitem[i]->refreshlist();

resui->refresh();
currentvoicecounter->do_callback();
}
