Template: localeconf/manage_config_with_debconf
Type: boolean
Default: true
Description: Manage locale configuration files with debconf?
 The /etc/environment and /etc/locale.gen files, which contain configuration
 information for system environment and localization can be handled
 automatically by debconf, or manually by you.
 .
 Note that only specific, marked sections of the configuration file will be
 handled by debconf if you select this option; if those markers are absent,
 you will have to update the file manually, or move or delete the file.
 .
 Note also that this question pertains only to portions of these files managed
 by the localeconf package.
Description-ru:       debconf?
  /etc/environment  /etc/locale.gen,    
        
  debconf,    .
 .
    ,  debconf    , 
    ,     ;  
  ,      ,   
  .
 .
  ,        , 
   localeconf.

Template: localeconf/backup_existing_nondebconf_config
Type: boolean
Default: false
Description: Replace existing locale configuration files?
 One or both of the existing /etc/environment and /etc/locale.gen files
 currently on the system do not contain a marked section for debconf to write
 data for the localeconf package.
 .
 If you select this option, the configuration files lacking these markers will
 be backed up (with the extension ".localeconf-backup") and new files written.
 If you do not select this option, the existing configuration files will not
 be managed by debconf, and no further questions about localization
 configuration will be asked.
Description-ru:     ?
       /etc/environment  /etc/locale.gen
   ,      debconf, 
       localeconf.
 .
     ,      
  (  ".localeconf-backup")     
 .         debconf,  
      .

Template: localeconf/lang
Type: select
Choices: ${choices}
Default: C
Description: Please select the default system locale.
 The LANG environment variable controls all aspects of system localization,
 except where overridden by the LC_* family of functions.  See the locales(7)
 manual page for more information about locales.
 .
 Locales are specified in a format indicating the language and territory,
 using codes specified by ISO 639 (language) and ISO 3166 (territory),
 optionally followed by parameters indicating a codeset and/or modifier.
 .
 The available options also display the codeset used by each locale (even
 where not specified by the locale itself), for reference.
 .
 If you are not sure which locale best applies to you, you may simply select
 the "C" locale, which is the POSIX standard locale and is always supported.
Description-ru:      
   LANG     ,
  ,     LC_*.  
       locales(7).
 .
    ,    ,   ,
   ISO 639 ()  ISO 3166 (),  
   ,   / .
 .
       ,  
   (     ).
 .
    ,       ,
       "C",   
  POSIX   .

Template: localeconf/lc_collate
Type: select
Choices: ${choices}
Default: 
Description: Please select the default system collation order locale.
 The LC_COLLATE environment variable controls text sorting and comparison
 functions.  If set, it will override the LANG environment variable for these
 functions.
 .
 Locales are specified in a format indicating the language and territory,
 using codes specified by ISO 639 (language) and ISO 3166 (territory),
 optionally followed by parameters indicating a codeset and/or modifier.
 .
 The available options also display the codeset used by each locale (even
 where not specified by the locale itself), for reference.
 .
 If you are not sure which locale best applies to you, you may simply select
 the "C" locale, which is the POSIX standard locale and is always supported.
Description-ru:        
   LC_COLLATE     
  .  ,    
  LANG   .
 .
    ,    ,   ,
   ISO 639 ()  ISO 3166 (),  
   ,   / .
 .
       ,  
   (     ).
 .
    ,       ,
       "C",   
  POSIX   .

Template: localeconf/lc_ctype
Type: select
Choices: ${choices}
Default: 
Description: Please select the default system character type locale.
 The LC_CTYPE environment variable controls character classification and
 handling.  If set, it will override the LANG environment variable for these
 functions.
 .
 Locales are specified in a format indicating the language and territory,
 using codes specified by ISO 639 (language) and ISO 3166 (territory),
 optionally followed by parameters indicating a codeset and/or modifier.
 .
 The available options also display the codeset used by each locale (even
 where not specified by the locale itself), for reference.
 .
 If you are not sure which locale best applies to you, you may simply select
 the "C" locale, which is the POSIX standard locale and is always supported.
Description-ru:        
   LC_CTYPE    
 .  ,     LANG 
   .
 .
    ,    ,   ,
   ISO 639 ()  ISO 3166 (),  
   ,   / .
 .
       ,  
   (     ).
 .
    ,       ,
       "C",   
  POSIX   .

Template: localeconf/lc_messages
Type: select
Choices: ${choices}
Default: 
Description: Please select the default system message locale.
 The LC_MESSAGES environment variable controls how messages are displayed
 (using localized translations where supported by the application) and the
 form of textual affirmative and negative user input.  If set, it will
 override the LANG environment variable for these functions.
 .
 Locales are specified in a format indicating the language and territory,
 using codes specified by ISO 639 (language) and ISO 3166 (territory),
 optionally followed by parameters indicating a codeset and/or modifier.
 .
 The available options also display the codeset used by each locale (even
 where not specified by the locale itself), for reference.
 .
 If you are not sure which locale best applies to you, you may simply select
 the "C" locale, which is the POSIX standard locale and is always supported.
Description-ru:        
   LC_MESSAGES    (
  ,   )  
     .  ,  
    LANG   .
 .
    ,    ,   ,
   ISO 639 ()  ISO 3166 (),  
   ,   / .
 .
       ,  
   (     ).
 .
    ,       ,
       "C",   
  POSIX   .

Template: localeconf/lc_monetary
Type: select
Choices: ${choices}
Default: 
Description: Please select the default system monetary locale.
 The LC_MONETARY environment variable controls the formatting of monetary
 values.  If set, it will override the LANG environment variable for these
 functions.
 .
 Locales are specified in a format indicating the language and territory,
 using codes specified by ISO 639 (language) and ISO 3166 (territory),
 optionally followed by parameters indicating a codeset and/or modifier.
 .
 The available options also display the codeset used by each locale (even
 where not specified by the locale itself), for reference.
 .
 If you are not sure which locale best applies to you, you may simply select
 the "C" locale, which is the POSIX standard locale and is always supported.
Description-ru:         
   LC_MONETARY    
 .  ,     LANG 
  .
 .
    ,    ,   ,
   ISO 639 ()  ISO 3166 (),  
   ,   / .
 .
       ,  
   (     ).
 .
    ,       ,
       "C",   
  POSIX   .

Template: localeconf/lc_numeric
Type: select
Choices: ${choices}
Default: 
Description: Please select the default system numeric locale.
 The LC_NUMERIC environment variable controls the formatting of non-monetary
 numeric data.  If set, it will override the LANG environment variable for
 these functions.
 .
 Locales are specified in a format indicating the language and territory,
 using codes specified by ISO 639 (language) and ISO 3166 (territory),
 optionally followed by parameters indicating a codeset and/or modifier.
 .
 The available options also display the codeset used by each locale (even
 where not specified by the locale itself), for reference.
 .
 If you are not sure which locale best applies to you, you may simply select
 the "C" locale, which is the POSIX standard locale and is always supported.
Description-ru:        
   LC_NUMERIC    
 .  ,     LANG 
  .
 .
    ,    ,   ,
   ISO 639 ()  ISO 3166 (),  
   ,   / .
 .
       ,  
   (     ).
 .
    ,       ,
       "C",   
  POSIX   .

Template: localeconf/lc_time
Type: select
Choices: ${choices}
Default: 
Description: Please select the default system time locale.
 The LC_TIME environment variable controls the formatting of time-of-day
 display.  If set, it will override the LANG environment variable for these
 functions.
 .
 Locales are specified in a format indicating the language and territory,
 using codes specified by ISO 639 (language) and ISO 3166 (territory),
 optionally followed by parameters indicating a codeset and/or modifier.
 .
 The available options also display the codeset used by each locale (even
 where not specified by the locale itself), for reference.
 .
 If you are not sure which locale best applies to you, you may simply select
 the "C" locale, which is the POSIX standard locale and is always supported.
Description-ru:       
   LC_TIME     .
  ,     LANG 
  .
 .
    ,    ,   ,
   ISO 639 ()  ISO 3166 (),  
   ,   / .
 .
       ,  
   (     ).
 .
    ,       ,
       "C",   
  POSIX   .

