/* LogJam, a GTK LiveJournal client.
 * Copyright (C) 2000,2001 Evan Martin <evan@livejournal.com>
 * vim:ts=4:sw=4:
 *
 * $Id: users.c,v 1.2 2001/07/14 05:56:17 martine Exp $
 */

#include "config.h"

#include <gtk/gtk.h>
#include "dotconf.h"
#include "util.h"
#include "login.h"

typedef struct {
	GtkWidget *win;
	GtkWidget *userlist;
	GtkWidget *bedit, *bdelete;
} user_dlg;

typedef struct {
	GtkWidget *win;
	GtkWidget *eusername, *epassword;
	GtkWidget *bok;
	user *edituser;
} user_edit_dlg;

static char*
entry_text(GtkWidget *entry) {
	char *text;
	text = gtk_editable_get_chars(GTK_EDITABLE(entry), 0, -1);

	if (text[0] == 0) { 
		g_free(text); 
		return NULL;
	}
	return text;
}

static void user_addmodify(GtkWidget *w, user_edit_dlg *uedlg) {
	char *username, *password;
	user *u;

	username = entry_text(uedlg->eusername);
	password = entry_text(uedlg->epassword);

	if (username == NULL || password == NULL) {
		if (username != NULL) g_free(username);
		if (password != NULL) g_free(password);
		return;
	}

	if (uedlg->edituser == NULL) {
		/* verify this id is really new */
		u = conf_user_by_name(&conf, username);
		if (u != NULL) {
			uedlg->edituser = u;
		} else {
			u = g_new0(user, 1);
		}
	} else {
		u = uedlg->edituser;
	}

	string_replace(&u->username, username);
	string_replace(&u->password, password);
	
	if (uedlg->edituser == NULL)
		conf.users = g_list_append(conf.users, u);

	/*populate_list(userlist);*/

	gtk_widget_destroy(uedlg->win);
}

static void
entry_changed(GtkWidget *w, user_edit_dlg *uedlg) {
	char *user = gtk_entry_get_text(GTK_ENTRY(uedlg->eusername));
	char *pass = gtk_entry_get_text(GTK_ENTRY(uedlg->epassword));
	if (user && user[0] != 0 &&
			pass && pass[0] != 0) {
		gtk_widget_set_sensitive(uedlg->bok, TRUE);
	} else {
		gtk_widget_set_sensitive(uedlg->bok, FALSE);
	}
}

static GtkWidget*
user_edit_dlg_make_entries(user_edit_dlg *uedlg) {
	GtkWidget *table;

	table = lj_table_new(2, 2);

	uedlg->eusername = gtk_entry_new();
	gtk_widget_set_usize(uedlg->eusername, 100, -1);
	lj_table_label(GTK_TABLE(table),   0, "User Name:");
	lj_table_content(GTK_TABLE(table), 0, uedlg->eusername);

	uedlg->epassword = gtk_entry_new();
	gtk_entry_set_visibility(GTK_ENTRY(uedlg->epassword), FALSE);
	lj_table_label(GTK_TABLE(table),   1, "Password:");
	lj_table_content(GTK_TABLE(table), 1, uedlg->epassword);

	if (uedlg->edituser) {
		gtk_entry_set_text(GTK_ENTRY(uedlg->eusername), 
				uedlg->edituser->username);
		gtk_entry_set_text(GTK_ENTRY(uedlg->epassword), 
				uedlg->edituser->password);
	}

	gtk_signal_connect(GTK_OBJECT(uedlg->eusername), "changed",
			GTK_SIGNAL_FUNC(entry_changed), uedlg);
	gtk_signal_connect(GTK_OBJECT(uedlg->epassword), "changed",
			GTK_SIGNAL_FUNC(entry_changed), uedlg);
	gtk_signal_connect(GTK_OBJECT(uedlg->epassword), "activate",
			GTK_SIGNAL_FUNC(user_addmodify), uedlg);

	return table;
}

static void
user_edit_dlg_run(user_dlg *udlg, user *u) {
	user_edit_dlg uedlg_actual = {0}, *uedlg = &uedlg_actual;

	uedlg->edituser = u;
	uedlg->win = lj_dialog_new(udlg->win, 
			u ? "Edit user" : "Add user", 
			-1, -1);

	lj_dialog_set_contents(uedlg->win, user_edit_dlg_make_entries(uedlg));

	uedlg->bok = lj_dialog_add_okcancel(uedlg->win, NULL, 
			user_addmodify, uedlg);
	gtk_signal_connect(GTK_OBJECT(uedlg->win), "destroy",
			GTK_SIGNAL_FUNC(gtk_main_quit), NULL);
	entry_changed(NULL, uedlg);

	gtk_widget_show(uedlg->win);
	gtk_main();
}

static void 
repopulate_list(GtkWidget *list) {
	GList *l;
	user *u;
	char *item[1];
	int row;

	gtk_clist_freeze(GTK_CLIST(list));
	gtk_clist_clear(GTK_CLIST(list));
	for (l = conf.users; l != NULL; l = l->next) {
		u = l->data;
		item[0] = u->username;
		row = gtk_clist_append(GTK_CLIST(list), item);
		gtk_clist_set_row_data(GTK_CLIST(list), row, u);
	}
	gtk_clist_thaw(GTK_CLIST(list));

	gtk_signal_emit_by_name(GTK_OBJECT(list), "unselect_row");
}

static void
edit_user(user_dlg *udlg, user *u) {
	user_edit_dlg_run(udlg, u);
	repopulate_list(udlg->userlist);
}

static void 
user_new(GtkWidget *w, user_dlg *udlg) {
	edit_user(udlg, NULL);
}

static void user_edit(GtkWidget *w, user_dlg *udlg) {
	user *u;

	g_return_if_fail(GTK_CLIST(udlg->userlist)->selection != NULL);

	u = gtk_clist_get_row_data(GTK_CLIST(udlg->userlist),
			(int)GTK_CLIST(udlg->userlist)->selection->data);
	edit_user(udlg, u);
}

static void user_delete(GtkWidget *w, user_dlg *udlg) {
	user *u;

	g_return_if_fail(GTK_CLIST(udlg->userlist)->selection != NULL);

	u = gtk_clist_get_row_data(GTK_CLIST(udlg->userlist),
			(int)GTK_CLIST(udlg->userlist)->selection->data);

	conf.users = g_list_remove(conf.users, u);

	if (u->username) g_free(u->username);
	if (u->password) g_free(u->password);
	g_free(u);

	repopulate_list(udlg->userlist);
}

static void 
row_selected(GtkCList *list, 
		     gint row, gint col, 
			 GdkEventButton *event, 
			 user_dlg *udlg) {
	gtk_widget_set_sensitive(GTK_WIDGET(udlg->bedit), 
			list->selection != NULL);
	gtk_widget_set_sensitive(GTK_WIDGET(udlg->bdelete), 
			list->selection != NULL);
}

static GtkWidget*
make_list(user_dlg *udlg) {
	GtkWidget *scroll;
	gchar *titles[] = { "User Name" };

	udlg->userlist = gtk_clist_new_with_titles(1, titles);
	gtk_clist_set_selection_mode(GTK_CLIST(udlg->userlist),
			GTK_SELECTION_SINGLE);
	gtk_clist_column_titles_passive(GTK_CLIST(udlg->userlist));
	gtk_signal_connect(GTK_OBJECT(udlg->userlist), "select_row",
					   GTK_SIGNAL_FUNC(row_selected), udlg);
	gtk_signal_connect(GTK_OBJECT(udlg->userlist), "unselect_row",
					   GTK_SIGNAL_FUNC(row_selected), udlg);

	scroll = gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW (scroll),
			GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_container_add(GTK_CONTAINER(scroll), udlg->userlist);
	return scroll;
}

static GtkWidget*
make_buttonbox(user_dlg *udlg) {
	GtkWidget *box, *badd;

	badd = gtk_button_new_with_label(" Add... ");
	gtk_signal_connect(GTK_OBJECT(badd), "clicked",
			GTK_SIGNAL_FUNC(user_new), udlg);

	udlg->bedit = gtk_button_new_with_label(" Edit... ");
	gtk_signal_connect(GTK_OBJECT(udlg->bedit), "clicked",
			GTK_SIGNAL_FUNC(user_edit), udlg);

	udlg->bdelete = gtk_button_new_with_label(" Delete ");
	gtk_signal_connect(GTK_OBJECT(udlg->bdelete), "clicked",
			GTK_SIGNAL_FUNC(user_delete), udlg);

	box = lj_dialog_buttonbox_new();
	lj_dialog_buttonbox_add(box, badd);
	lj_dialog_buttonbox_add(box, udlg->bedit);
	lj_dialog_buttonbox_add(box, udlg->bdelete);
	return box;
}

void user_dlg_run(GtkWidget *parent) {
	user_dlg udlg_actual = {0}, *udlg = &udlg_actual;

	udlg->win = lj_dialog_new(parent, "Identities", 200, -1);
	lj_dialog_set_contents_buttonbox(udlg->win, 
			make_list(udlg),
			make_buttonbox(udlg));
	lj_dialog_add_close(udlg->win);
	gtk_signal_connect(GTK_OBJECT(udlg->win), "destroy",
			GTK_SIGNAL_FUNC(gtk_main_quit), NULL);
	gtk_widget_show(udlg->win);

	repopulate_list(udlg->userlist);
	gtk_main();
}

