/* LogJam, a GTK LiveJournal client.
 * Copyright (C) 2000,2001 Evan Martin <evan@livejournal.com>
 * vim:ts=4:sw=4:
 *
 * $Id: friendgroupedit.c,v 1.2 2001/07/14 05:56:17 martine Exp $
 */

#include <gtk/gtk.h>

#include <stdlib.h>

#include "friends.h"
#include "dotconf.h"
#include "friendgroupedit.h"
#include "network.h"
#include "util.h"

typedef struct {
	GtkWidget *win;
	GtkWidget *egroupname, *cpublic;

	friendgroup *editgroup;

	int freegroup; /* index of first free group number. */

	int okclicked;
} friend_group_edit_dlg;

static void 
editgroup_begin(GtkWidget *w, friend_group_edit_dlg *fged) {
	int groupid;
	GHashTable *request, *result;
	
	request = net_request_new("editfriendgroups");
	if (fged->editgroup) {
		groupid = fged->editgroup->id;
	} else {
		groupid = fged->freegroup;
	}
	g_hash_table_insert(request, 
			g_strdup_printf("efg_set_%d_name", groupid),
			g_strdup(gtk_entry_get_text(GTK_ENTRY(fged->egroupname))));
	g_hash_table_insert(request, 
			g_strdup_printf("efg_set_%d_public", groupid),
			g_strdup_printf(gtk_toggle_button_get_active(
					GTK_TOGGLE_BUTTON(fged->cpublic)) 
				? "1" : "0"));

	result = net_request_run(fged->win, "Modifying Friend Group...", request);
	hash_destroy(request);

	if (net_request_succeeded(result)) {
		if (fged->editgroup == NULL) {
			/* we must create a new group */
			fged->editgroup = g_new0(friendgroup, 1);
			fged->editgroup->id = fged->freegroup;
		}
		string_replace(&fged->editgroup->name, 
				g_strdup(gtk_entry_get_text(GTK_ENTRY(fged->egroupname))));
		fged->editgroup->ispublic = 
			gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fged->cpublic));

		fged->okclicked = TRUE;
		gtk_widget_destroy(fged->win);
	}
	hash_destroy(result);
}

static void
entry_changed(GtkEntry *entry, GtkWidget* button) {
	gtk_widget_set_sensitive(button, 
			(strlen(gtk_entry_get_text(entry)) > 0));
}

friendgroup*
friend_group_edit_dlg_run(GtkWidget *parent, friendgroup *fg, int freegroup) {
	friend_group_edit_dlg fged_actual = {0};
	friend_group_edit_dlg *fged = &fged_actual;
	GtkWidget *table, *button;

	fged->editgroup = fg;
	fged->freegroup = freegroup;

	fged->win = lj_dialog_new(parent, 
			fg ? "Edit Friend Group" : "New Friend Group",
			200, 1);
	gtk_signal_connect(GTK_OBJECT(fged->win), "destroy",
			GTK_SIGNAL_FUNC(gtk_main_quit), NULL);

	table = lj_table_new(2, 2);
	lj_table_label(GTK_TABLE(table), 0, "Group name:");

	fged->egroupname = gtk_entry_new();
	lj_table_content(GTK_TABLE(table), 0, fged->egroupname);

	fged->cpublic = gtk_check_button_new_with_label("Public");
	lj_table_fillrow(GTK_TABLE(table), 1, fged->cpublic);

	lj_dialog_set_contents(fged->win, table);

	button = lj_dialog_add_okcancel(fged->win, fg ? "  Change  " : "  Create  ",
		editgroup_begin, fged);
	
	/* enable/disable the button based on name text */
	gtk_signal_connect(GTK_OBJECT(fged->egroupname), "changed",
		GTK_SIGNAL_FUNC(entry_changed), button);

	/* fill in default values. */
	if (fg) {
		gtk_entry_set_text(GTK_ENTRY(fged->egroupname), fg->name);
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fged->cpublic), fg->ispublic);
	} else {
		gtk_entry_set_text(GTK_ENTRY(fged->egroupname), "");
		/* emit the "changed" signal, anyway. */
	}

	gtk_widget_show(fged->win);

	gtk_main();

	if (fged->okclicked) {
		return fged->editgroup;
	} else {
		return NULL;
	}
}


