/* LogJam, a GTK LiveJournal client.
 * Copyright (C) 2000,2001 Evan Martin <evan@livejournal.com>
 * vim:ts=4:sw=4:
 *
 * $Id: friends.h,v 1.2 2001/07/14 05:56:17 martine Exp $
 */

#ifndef friends_h
#define friends_h

#define FRIEND_MY	(1 << 0)
#define FRIEND_OF	(1 << 1)
#define FRIEND_BOTH (FRIEND_MY | FRIEND_OF)

typedef enum {
	FRIEND_TYPE_USER=0,
	FRIEND_TYPE_COMMUNITY
} FriendType;

typedef struct {
	char *name;
	char *username;
	char foreground[10], background[10];
	int conn; /* FRIEND_MY, etc */
	FriendType type; 
	guint32 groupmask;
} friend;

/* the first bit is the "all friends" group. */
#define FRIEND_GROUP_ALLFRIENDS 1

extern void friends_dialog(GtkWidget *mainwin);

#endif /* history_h */
