from qt import *
import paths

_star = None

def star():
	global _star
	if _star==None:
		_star = QPixmap(paths.art("labelstar.png"))
	return _star

class LRatingWidget(QFrame):
	def __init__(self,container):
		QFrame.__init__(self,container)
		self.setFixedSize(QSize(80,20))
		self._rating = 0
		self._edited = False
	
	def paintEvent(self,e):
		p = QPainter()
		p.begin(self)
		p.setBrush(QColor(255,255,255))
		p.drawRect(self.rect())
		for i in xrange(0,self._rating):
			p.drawPixmap(QPoint(i*13+8,4),star())
		p.end()
	
	def mousePressEvent(self,e):
		p = e.pos()
		#print "x",p.x()
		stars = (p.x()-8)/13+1
		#print "stars",stars
		if stars<0:
			stars = 0
		elif stars>5:
			stars = 5
		self.setRating(stars)
		self._edited = True
		self.emit(PYSIGNAL("ratingChanged"),(self,stars))
	
	def setRating(self,rating):
		self._rating = rating
		self.update()
	
	def rating(self):
		return self._rating

	def edited(self):
		return self._edited


	
