<?xml version="1.0" encoding="iso-8859-1"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns="http://www.w3.org/1999/xhtml" version="1.0">
<xsl:output encoding="iso-8859-1" method="xml" doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" doctype-system="DTD/xhtml1-strict.dtd"/>


<xsl:template match="/Thumbs">
<html>
<head>
<title><xsl:value-of select="@Title"/></title>
<style>
BODY {background-color:#CCE; }
TD.fulltablecolumn { font-family:Verdana,Helvetica,sans; font-size:12px; vertical-align:top; horizontal-align:center; }
IMG { border:solid gray 1px; align:center; veritcal-align:bottom;}
H1 { font-family:Verdana,Helvetica,sans; font-weight:bold; font-size:25px; text-align: center;}
TABLE.phototable { border-top: solid #CCE 1px;border-bottom: solid #CCE 0px; margin-left:auto; margin-right:auto;border-left-width:0px;border-right-width:0px;}
TR.phototablephotorow { background-color: white;}
TD.phototablephotocolumn{text-align:center; vertical-align:center;}
TD.phototabledescriptioncolumn {background-color:#FFF; text-align:center;vertical-align:bottom;border-top: solid gray 1px;border-bottom:0px;border-left-width:0px;border-right-width:0px;}
SPAN.phototitle {font-size: 14px; font-weight:bold; text-align:center;}
SPAN.photodescription { text-align:center; }
TR.fulltablerow{ background-color:#FFFFFF; align:center;}
TABLE.fulltable{border: solid black 1px;background-color:#FFFFFF;}
SPAN.footer{font: 0.8em Verdana, Arial, sans-serif;padding: 0.5em 0.5em 0.5em 0.5em;}
</style>
</head>
<body>

<table class="fulltable" cellspacing="0" cellpadding="10" align="center" >
<tr><td colspan="5"><h1><xsl:value-of select="@Title"/></h1></td></tr>
<xsl:apply-templates/>
</table>
<xsl:call-template name="footer"/>
</body>
</html>
</xsl:template>

<xsl:template match="/Thumbs/Photo">
<xsl:if test="(position() mod 10) = 2">
	<xsl:text disable-output-escaping="yes">&lt;tr class="fulltablerow" align="center" &gt;</xsl:text>
</xsl:if>

<td class="fulltablecolumn">
	<table class="phototable" >
		<tr class="phototablephotorow" >
			<td class="phototablephotocolumn" width="190" height="190" >
				<a>
					<xsl:attribute name="href">p_<xsl:value-of select="Filename"/>.html</xsl:attribute>
					<img align="center" >
						<xsl:attribute name="src">thumbs/<xsl:value-of select="Filename"/></xsl:attribute>
					</img><br/>
				</a>
			</td>
		</tr>
		<tr class="phototabledescriptionrow">
			<td class="phototabledescriptioncolumn" width="190">
				<span class="phototitle"><xsl:value-of select="Title"/></span>
				<xsl:if test="./Comments != 'None'">
					<br/><span class="photodescription"><xsl:value-of select="Comments"/></span>
				</xsl:if>
			</td>
		</tr>
	</table>
</td>
<xsl:if test="(position() mod 10) = 0">
	<xsl:text disable-output-escaping="yes">&lt;/tr&gt;</xsl:text>
	
</xsl:if>
</xsl:template>

<xsl:template match="/Photo">
<html>
<head>
<title><xsl:value-of select="@Caption"/></title>
<style>
BODY {background-color:#CCE; }
IMG { border:solid grey 1px; align:center;vertical-align:center;}
SPAN.phototitle {font-family:Verdana,Helvetica,sans; font-size: 18px; font-weight:bold; text-align:center;}
SPAN.photodescription { font-family:Verdana,Helvetica,sans; text-align:center; }
SPAN.footer{font: 0.8em Verdana, Arial, sans-serif;padding: 0.5em 0.5em 0.5em 0.5em;}
TD.phototext {background-color:#FFF; text-align:center; border-top: solid black 1px;border-left: 0px;border-bottom: 0px;border-right: 0px;}
TABLE { border:solid black 1px; align:center; background-color:#FFF;}
TD.links {background-color:#CCE; border-bottom: solid black 1px;border-left: 0px;border-top: 0px;border-right: 0px;font-family:Verdana,Helvetica,sans; font-size: 18px; font-weight:bold;}
TD.links-bottom {background-color:#FFF; border-top: solid black 1px;border-left-width: 0px;border-bottom-width: 0px;border-right-width: 0px;font-family:Verdana,Helvetica,sans; font-size: 18px; font-weight:bold;}
</style>
</head>
<body>
<table cellpadding="10" align="center" cellspacing="0" >
<xsl:apply-templates/>
</table>
<xsl:call-template name="footer"/>
</body>
</html>
</xsl:template>

<xsl:template match="/Photo/Photo">
<xsl:call-template name="previous-next"/>
<tr>
	<td colspan="3">
		<img>
			<xsl:attribute name="src">images/<xsl:value-of select="Filename"/></xsl:attribute>
		</img>
	</td>
</tr>
<tr>
	<td class="phototext" colspan="3">
		<span class="phototitle"><xsl:value-of select="Title"/></span>
		<xsl:if test="./Comments != 'None'">
			<br/>
			<span class="photodescription"><xsl:value-of select="Comments"/></span>
		</xsl:if>
	</td>
</tr>
<xsl:call-template name="previous-next"/>
</xsl:template>

<xsl:template name="previous-next">
<tr>
	<td align="left" width="33%">
		<a>
			<xsl:if test="./Prev">
				<xsl:attribute name="href">p_<xsl:value-of select="Prev"/>.html</xsl:attribute>Previous
			</xsl:if>
		</a>
	</td>
	<td align="center" width="33%">
		<a href="./index.html">Home</a>
	</td>
	<td align="right" width="33%">
		<a>
			<xsl:if test="./Next">
				<xsl:attribute name="href">p_<xsl:value-of select="Next"/>.html</xsl:attribute>Next
			</xsl:if>
		</a>
	</td>
</tr>
</xsl:template>

<xsl:template name="footer">
<br/>
<div align="center">
	<a href="http://www.lphoto.com"><img src="resources/lphoto.gif" border="0" /></a>
	<br/>
	<span class="footer">Created with <a href="http://www.lphoto.com">Lphoto</a></span>
</div>
</xsl:template>

</xsl:stylesheet>




