#define MODULE

#if 0
#define CONFIG_TRACE
#endif

#include <linux/config.h>
#include <linux/module.h>
#include <linux/trace.h>
#include <asm/string.h>

struct delta_event
{
  int   an_int;
  char  a_char;
};

static int alpha_id, omega_id;

int init_module(void)
{
  uint8_t a_byte;
  char a_char;
  int an_int;
  int a_hex;
  char* a_string = "We are initializing the module";
  struct delta_event a_delta_event;

  /* Create events */
  alpha_id = trace_create_event("Alpha",
				NULL,
				CUSTOM_EVENT_FORMAT_TYPE_XML,
				"<event name=\"Alpha\" size=\"0\"><var name=\"an_int\" type=\"int\" /><var name=\"a_char\" type=\"char\" /></event>");
  omega_id = trace_create_event("Omega",
			        NULL,
				CUSTOM_EVENT_FORMAT_TYPE_XML,
				"<event name=\"Omega\" size=\"0\"><var name=\"a_byte\" type=\"u8\" /></event>");

  /* Trace events */
  memset(&a_delta_event, 0, sizeof(a_delta_event));
  trace_raw_event(alpha_id, sizeof(a_delta_event), &a_delta_event);
  a_byte = 0x12;
  trace_raw_event(omega_id, sizeof(a_byte), &a_byte);
  return 0;
}

void cleanup_module(void)
{
  uint8_t a_byte;
  char a_char;
  int an_int;
  int a_hex;
  char* a_string = "We are initializing the module";
  struct delta_event a_delta_event;

  /* Trace events */
  memset(&a_delta_event, 0xFF, sizeof(a_delta_event));
  trace_raw_event(alpha_id, sizeof(a_delta_event), &a_delta_event);
  a_byte = 0xA4;
  trace_raw_event(omega_id, sizeof(a_byte), &a_byte);

  /* Destroy the events created */
  trace_destroy_event(alpha_id);
  trace_destroy_event(omega_id);
}
