#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <limits.h>
#include <errno.h>
#include <mntent.h>
#include <paths.h>
#include <fcntl.h>
#include <string.h>

#include <sys/types.h>
#include <sys/mount.h>
#include <sys/stat.h>

#define MTAB_TMP _PATH_MOUNTED".tmp"

static void
help(){
    printf("\n");
    printf("Usage: lufsumount mount-point\n");

}

static int
fullpath(char *path, char *full){
    
    full[0] = 0;
    
    if(strlen(path) >= PATH_MAX - 1)
	return -1;

    if(!realpath(path, full))
	return -1;
    else 
	return 0;
}

int
main(int argc, char **argv){
    char *mountpoint;
    static char fpath[PATH_MAX];
    struct mntent *ment;
    int fd, muid = -1;
    FILE *mtab, *new_mtab;
    
    if(argc != 2){
	help();
	return 1;
    }
    
    if(geteuid()){
	fprintf(stderr, "lufsumount should be installed suid root\n");
	return 1;
    }
        
    mountpoint = argv[1];

    fullpath(mountpoint, fpath);
    
    if((fd = open(_PATH_MOUNTED"~", O_RDWR|O_CREAT|O_EXCL, 0600)) < 0){
	fprintf(stderr, "can't get "_PATH_MOUNTED"~ lock file");
	return 1;
    }
    
    close(fd);
    
    if((mtab = setmntent(_PATH_MOUNTED, "r")) == NULL){
	fprintf(stderr, "can't open "_PATH_MOUNTED ":%s\n", strerror(errno));
	goto err;
    }

    if((new_mtab = setmntent(MTAB_TMP, "w")) == NULL){
	fprintf(stderr, "can't open "MTAB_TMP": %s\n", strerror(errno));
	endmntent(mtab);
	goto err;
    }
    
    while((ment = getmntent(mtab))){
	if(!strcmp(ment->mnt_dir, fpath)){
	    sscanf(ment->mnt_opts, "owner=%u,", &muid);
	}else
	    addmntent(new_mtab, ment);
    }

    endmntent(mtab);

    if(fchmod(fileno(new_mtab), 0644) < 0){
	fprintf(stderr, "can't change mode for "MTAB_TMP"\n");
	goto err;
    }

    endmntent(new_mtab);
    
    if(muid == -1){
	fprintf(stderr, "mtab entry for %s not found\n", fpath);
	goto err_mtab;
    }

    if((getuid()) && (getuid() != muid)){
	fprintf(stderr, "you are not allowed to umount this filesystem.\n");
	goto err_mtab;
    }

    if(umount(fpath)){
	fprintf(stderr, "could not umount %s: %s\n", fpath, strerror(errno));
	goto err_mtab;
    }

    if(rename(MTAB_TMP, _PATH_MOUNTED) < 0){
	fprintf(stderr, "can't rename %s to %s: %s\n", MTAB_TMP, _PATH_MOUNTED, strerror(errno));
	goto err_mtab;
    }

    if(unlink(_PATH_MOUNTED"~") < 0){
	fprintf(stderr, "can't remove "_PATH_MOUNTED"~\n");
	return 1;
    }
    
    return 0;

err_mtab:
    unlink(MTAB_TMP);
err:
    unlink(_PATH_MOUNTED"~");
    return 1;
}

