/***************************************************************************
                          cdownloadqueue.cpp  -  description
                             -------------------
    begin                : Don Mai 16 2002
    copyright            : (C) 2002-2003 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdio.h>

#include <dclib/dcos.h>

#include "cdownloadqueue.h"

/** */
CDownloadQueue::CDownloadQueue()
{
	pQueue     = new CThreadStringList();
	pChunkList = new CThreadStringList();
}

/** */
CDownloadQueue::~CDownloadQueue()
{
	if ( pQueue )
	{
		delete pQueue;
		pQueue = 0;
	}

	if ( pChunkList )
	{
		delete pChunkList;
		pChunkList = 0;
	}
}

/** */
CStringList * CDownloadQueue::GetUserHubList( CString nick )
{
	CStringList * StringList = 0;

	if ( pQueue->Get( nick, (CObject *&) StringList ) == 0 )
	{
		return StringList;
	}

	return 0;
}

/** */
bool CDownloadQueue::RenameNick( CString srcnick, CString dstnick, CString srchubname, CString dsthubname )
{
	CStringList * StringList = 0;
	DCTransferQueueObject * TransferObject = 0;
	bool res = FALSE;

	// get the transferobject
	if ( (TransferObject = GetUserTransferObject( srcnick, srchubname, "" )) != 0 )
	{
		// made changes
		TransferObject->sNick    = dstnick;
		TransferObject->sHubName = dsthubname;

		// update the lists
		if ( pQueue->Get( srcnick, (CObject *&) StringList ) == 0 )
		{
			StringList->Remove( srchubname );

			if ( StringList->Count() == 0 )
				pQueue->Del(srcnick);

			if ( pQueue->Get( dstnick, (CObject *&) StringList ) != 0 )
			{
				StringList = new CStringList();
				pQueue->Add( dstnick, StringList );
			}

			StringList->Add( dsthubname, TransferObject );

			res = TRUE;
		}
	}

	return res;
}

/** */
DCTransferQueueObject * CDownloadQueue::GetUserTransferObject( CString nick, CString hubname, CString hubhost )
{
	CStringList * StringList = 0;
	DCTransferQueueObject * TransferObject = 0;

	if ( (StringList = GetUserHubList( nick )) != 0 )
	{
		if ( StringList->Get( hubname, (CObject *&) TransferObject ) == 0 )
		{
			return TransferObject;
		}
	}

	return 0;
}

/** */
DCTransferFileObject * CDownloadQueue::GetUserFileObject( CString nick, CString hubname, CString hubhost, CString remotename )
{
	DCTransferFileObject * TransferFileObject = 0;
	DCTransferQueueObject * TransferObject;

	if ( (TransferObject = GetUserTransferObject( nick, hubname, hubhost )) != 0 )
	{
		if ( TransferObject->pTransferFileList.Get( remotename, (CObject *&) TransferFileObject ) == 0 )
		{
			return TransferFileObject;
		}
	}

	return 0;
}

/** */
bool CDownloadQueue::DelUserFileObject( CString nick, CString hubname, CString hubhost, CString remotefile )
{
	bool res = FALSE,err;
	CStringList * StringList;
	DCTransferQueueObject * TransferObject;
	DCTransferFileObject * TransferFileObject;

	if ( (TransferObject = GetUserTransferObject( nick, hubname, hubhost ) ) != 0 )
	{
		if ( remotefile != "" )
		{
			// remove a single file
			if ( TransferObject->pTransferFileList.Get( remotefile, (CObject *&) TransferFileObject ) == 0 )
			{
				if ( TransferFileObject->m_eState == etfsTRANSFER )
				{
					printf("warning ! file transfer is running ...\n");
				}
				else
				{
					RemoveChunk(TransferFileObject->m_sLocalFile);
					TransferObject->pTransferFileList.Del(remotefile);
					res = TRUE;
				}
			}
		}
		else
		{
			// remove a file tree
			TransferFileObject = 0;
			err = FALSE;
			while ( TransferObject->pTransferFileList.Next( (CObject *&) TransferFileObject ) )
			{
				if ( TransferFileObject->m_eState == etfsTRANSFER )
				{
					printf("warning ! file transfer is running ...\n");
					err = TRUE;
					break;
				}
				else
				{
					RemoveChunk(TransferFileObject->m_sLocalFile);
				}
			}

			if ( err == FALSE )
			{
				if ( (StringList = GetUserHubList(nick)) != 0 )
				{
					StringList->Del(hubname);

					if ( StringList->Count() == 0 )
					{
						pQueue->Del(nick);
					}

					res = TRUE;
				}
			}
		}
	}
	else
	{
		printf("warning ! queue not found ...\n");
	}

	return res;
}

/** */
bool CDownloadQueue::RemoveChunk( CString localfile )
{
	bool res = FALSE;
	DCFileChunkObject * FileChunkObject;

	// update file chunks
	pChunkList->Lock();

	if ( pChunkList->Get( localfile, (CObject *&)FileChunkObject ) == 0 )
	{
		res = TRUE;

		FileChunkObject->m_nReferenceCount--;
		if ( FileChunkObject->m_nReferenceCount == 0 )
		{
			pChunkList->Del(localfile);
		}
	}

	pChunkList->UnLock();

	return res;
}

/** */
DCFileChunkObject * CDownloadQueue::GetFileChunkObject( CString file )
{
	DCFileChunkObject * FileChunkObject = 0;

	pChunkList->Get( file, (CObject *&)FileChunkObject );

	return FileChunkObject;
}

/** */
DCTransferFileObject::DCTransferFileObject()
{
	m_nID            = 0;
	m_nTime          = 0;
	m_sIndex         = "";
	m_stHash         = "";
	m_sHash          = "";
	m_eMedium        = eltNONE;
	m_sRemoteFile    = "";
	m_sLocalFile     = "";
	m_sLocalPath     = "";
	m_sLocalFileName = "";
	m_eState         = etfsNONE;
	m_nSize          = 0;
	m_bMulti         = FALSE;
	m_nPriority      = 0;
}

/** */
DCTransferFileObject::~DCTransferFileObject()
{
}

/** */
void DCTransferFileObject::copy( DCTransferFileObject * TransferFileObject )
{
	if( !TransferFileObject )
	{
		return;
	}
	
	m_nID            = TransferFileObject->m_nID;
	m_nTime          = TransferFileObject->m_nTime;
	m_sIndex         = TransferFileObject->m_sIndex;
	m_stHash         = TransferFileObject->m_stHash;
	m_sHash          = TransferFileObject->m_sHash;
	m_eMedium        = TransferFileObject->m_eMedium;
	m_sRemoteFile    = TransferFileObject->m_sRemoteFile;
	m_sLocalFile     = TransferFileObject->m_sLocalFile;
	m_sLocalPath     = TransferFileObject->m_sLocalPath;
	m_sLocalFileName = TransferFileObject->m_sLocalFileName;
	m_eState         = TransferFileObject->m_eState;
	m_nSize          = TransferFileObject->m_nSize;
	m_bMulti         = TransferFileObject->m_bMulti;
	m_nPriority      = TransferFileObject->m_nPriority;
}
