/***************************************************************************
                           chttp.cpp  -  description
                             -------------------
    begin                : Mon Jul 29 2002
    copyright            : (C) 2002-2003 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>

#include <dclib/dcos.h>
#include <dclib/core/clist.h>
#include <dclib/core/ccallback.h>
#include <dclib/core/cmanager.h>
#include <dclib/dcobject.h>

#include "chttp.h"

/** */
CHttp::CHttp()
{
	m_pHttpCallback = 0;
	m_pCallback     = 0;
	m_eUrlMethod    = eumGET;

	m_pMessageList = new CList<CObject>();
}

/** */
CHttp::~CHttp()
{
	if ( m_pCallback )
	{
		CManager::Instance()->Remove( m_pCallback );
		delete m_pCallback;
		m_pCallback = 0;
	}

	Disconnect();

	if ( m_pHttpCallback )
	{
		delete m_pHttpCallback;
		m_pHttpCallback = 0;
	}

	delete m_pMessageList;
}

/** */
int CHttp::Callback( CObject *, CObject * )
{
	Thread(0);
	return 0;
}

/** */
int CHttp::GetUrl( CString url, CString postdata )
{
	int i,i1;
	CString s(url);
	CString sRealHost;
	CString sRealPort;

	//Disconnect();

	m_nErrorCode = 0;
	m_bData      = FALSE;
	m_sHeader    = "";
	m_sLocation  = "";

	m_baData.SetSize(0);

	if ( s == "" )
	{
		return -1;
	}

	if ( postdata.IsEmpty() )
	{
		m_eUrlMethod = eumGET;
		m_sPostData  = "";
	}
	else
	{
		m_eUrlMethod = eumPOST;
		m_sPostData  = postdata;
	}

	CString header = s.Mid(0,7);

	header = header.ToUpper();

	if ( header == "HTTP://" )
	{
		s = s.Mid(7,s.Length()-7);
	}

	if ( (i = s.Find(':')) >= 0 )
	{
		m_sHost = s.Mid(0,i);
	}

	if ( (i1 = s.Find('/')) < 0 )
	{
		printf("CHTTP: no '/' found\n");
		return -1;
	}

	if ( i >= 0 )
	{
		m_sPort = s.Mid(i+1,i1-i-1);
	}
	else
	{
		m_sHost = s.Mid(0,i1);
		m_sPort = "80";
	}

	char *proxy = getenv("http_proxy");

	if( proxy )
	{
		CString sProxyTemp ( proxy );
		CString header = sProxyTemp.Mid(0,7);

		header = header.ToUpper();

		if ( header == "HTTP://" )
		{
			sProxyTemp = sProxyTemp.Mid(7,sProxyTemp.Length()-7);
		}

		if ( (i = sProxyTemp.Find(':')) >= 0 )
		{
			m_sProxy = sProxyTemp.Mid(0,i);
		}

		if ( (i1 = sProxyTemp.Find('/')) < 0 )
		{
			printf("CHTTP: no '/' at the end of your proxy found.\n");
			printf("CHTTP: Check your http_proxy environment variable !\n");
			printf("CHTTP: Trying without ...\n");
			i1 = sProxyTemp.Length();
		}

		if ( i >= 0 )
		{
			m_sProxyPort = sProxyTemp.Mid(i+1,i1-i-1);
		}
		else
		{
			m_sProxy = sProxyTemp.Mid(0,i1);
			m_sProxyPort = "8080";
		}

		m_sUrl    = url;
		sRealHost = m_sProxy;
		sRealPort = m_sProxyPort;
	}
	else
	{
		m_sUrl    = s.Mid(i1,s.Length()-i1);
		m_sProxy  = "";
		sRealHost = m_sHost;
		sRealPort = m_sPort;
	}

	if ( m_sProxy != "" )
	{
		printf("CHTTP: PROXY: '%s:%s'\n",m_sProxy.Data(),m_sProxyPort.Data());
	}

	printf("CHTTP: HOST : '%s:%s'\n",m_sHost.Data(),m_sPort.Data());
	printf("CHTTP: URL  : '%s'\n",m_sUrl.Data());

	if ( Connect( sRealHost, sRealPort.asINT() ) == ecsERROR )
	{
		return -1;
	}

	if ( !m_pCallback )
	{
		m_pCallback = new CCallback<CHttp>( this, &CHttp::Callback );
		CManager::Instance()->Add( m_pCallback );
	}

	return 0;
}

/** */
bool CHttp::GetData( CByteArray * ba )
{
	bool err = FALSE;

	if ( (m_nErrorCode == 200) && (m_bData == TRUE) && (m_eMode == estNONE) )
	{
		if ( (m_nContentLength == -1) || (m_nContentLength == m_baData.Size()) )
		{
			if ( ba )
			{
				ba->SetSize(0);
				ba->Append( m_baData.Data(), m_baData.Size() );
			}
			
			err = TRUE;
		}
	}

	return err;
}

/** */
int CHttp::CallBack_SendObject( CObject * Object )
{
	int err;

	if ( m_pHttpCallback )
	{
		err = m_pHttpCallback->notify(this,Object);
	}
	else
	{
		err = DC_CallBack( Object );
	}

	if ( err == -1 )
	{
		printf("CallBack failed (state)...\n");
		delete Object;
	}

	return err;
}

/** */
void CHttp::ConnectionState( eConnectionState state )
{
	CMessageConnectionState *Object;

	Object = new CMessageConnectionState();

	Object->m_eState   = state;
	Object->m_sMessage = GetSocketError();

	if ( state == estCONNECTED )
	{
		m_eMode = estTRANSFERHANDSHAKE;
	}
	else if ( state == estDISCONNECTED )
	{
		m_eMode = estNONE;
	}

	// callback over notify because connection class is locked
	m_pMessageList->Add(Object);
}

/** */
void CHttp::DataAvailable( const char * buffer, int len )
{
	int i,i1,i2;

	if ( m_eMode == estTRANSFERDOWNLOAD )
	{
		if ( m_bData == FALSE )
		{
			for(i=0;i<len;i++)
			{
				m_sHeader += buffer[i];

				if ((m_sHeader.Length() > 4) &&
				    (m_sHeader.Data()[m_sHeader.Length()-4] == 0x0d) &&
				    (m_sHeader.Data()[m_sHeader.Length()-3] == 0x0a) &&
				    (m_sHeader.Data()[m_sHeader.Length()-2] == 0x0d) &&
				    (m_sHeader.Data()[m_sHeader.Length()-1] == 0x0a) )
				{
					//m_sHeader += CString().Set(buffer,i);
					//i+=4;

					// parse header ...
					if ( (i1 = m_sHeader.Find("HTTP/1.0 ")) == -1 )
					{
						if ( (i1 = m_sHeader.Find("HTTP/1.1 ")) == -1 )
						{
							printf("wrong proto '%s'\n",m_sHeader.Data());
							Disconnect();
							return;
						}
					}

					if ( (i2 = m_sHeader.Find(' ',i1+9)) == -1 )
					{
						printf("wrong proto '%s'\n",m_sHeader.Data());
						Disconnect();
					}
					else
					{
						m_nErrorCode = m_sHeader.Mid(i1+9,i2-i1-9).asINT();

						if ( m_nErrorCode == 200 )
						{
							printf("no error\n");
							m_bData = TRUE;
						}
						else if ( m_nErrorCode == 302 )
						{
							printf("redirect 302\n");
						}
						else
						{
							printf("http error %d\n",m_nErrorCode);
							Disconnect();
						}
					}

					m_nContentLength = -1;

					if ( m_nErrorCode == 200 )
					{
						if ( (i1 = m_sHeader.Find("Content-Length: ")) != -1 )
						{
							if ( (i2 = m_sHeader.Find(0x0d,i1)) != -1 )
							{
								m_nContentLength = m_sHeader.Mid(i1+16,i2-i1-16).asLONG();
							}
						}
					}
					else if ( m_nErrorCode == 302 )
					{
						if ( (i1 = m_sHeader.Find("Location: ")) != -1 )
						{
							if ( (i2 = m_sHeader.Find(0x0d,i1)) != -1 )
							{
								m_sLocation = m_sHeader.Mid(i1+10,i2-i1-10);
							}

							if ( m_sLocation == "" )
							{
								printf("http wrong location\n");
								m_nErrorCode = 0;
							}
						}
					}

					i++;
					break;
				}
			}

			if ( (m_bData == TRUE) && (m_nErrorCode != 0) )
			{
				AppendData( buffer+i,len-i );
			}
		}
		else
		{
			AppendData( buffer, len );
		}

		//printf("DATA: %ld\n",baData.Size());
	}
}

/** */
void CHttp::AppendData( const char * buffer, int len )
{
	CMessageTransfer  * msg = new CMessageTransfer();

	if ( m_nContentLength != -1 )
	{
		msg->m_nLength = m_nContentLength;
	}

	msg->m_nTransfered = m_baData.Size();

	m_pMessageList->Add(msg);

	m_baData.Append((const unsigned char*)buffer,len);
}

/** */
void CHttp::DataSend()
{
	CString header;

	if ( m_eMode == estTRANSFERHANDSHAKE )
	{
		// send request
		if ( m_eUrlMethod == eumGET )
		{
			header = "GET ";
		}
		else
		{
			header = "POST ";
		}

		header += m_sUrl;
		header += " HTTP/1.1";
		header += "\xd\xa";
		header += "User-Agent: DCGUI v";
		header += VERSION;
		header += "\xd\xa";
		header += "Referer: ";
		header += "http://" + m_sHost + ":" + m_sPort + "/";
		header += "\xd\xa";
		header += "Host: ";
		header += m_sHost;
		header += "\xd\xa";

		if ( m_eUrlMethod == eumPOST )
		{
			header += "Content-Type: text/plain";
			header += "\xd\xa";
			header += "Content-Length: " + CString().setNum(m_sPostData.Length());
			header += "\xd\xa";
		}

		header += "\xd\xa";

		if ( m_eUrlMethod == eumPOST )
		{
			header += m_sPostData;
		}

		if ( Write( (const unsigned char*)header.Data(), header.Length() ) != 0 )
		{
			m_eMode = estNONE;
		}
		else
		{
			m_eMode = estTRANSFERDOWNLOAD;
		}
	}
}

/** */
void CHttp::DataTimeout()
{
	Disconnect(TRUE);
	printf("data timeout\n");
}

/** */
void CHttp::Notify()
{
	CObject * object = 0;

	while ( (object=m_pMessageList->Next(0)) != 0 )
	{
		m_pMessageList->Remove(object);
		CallBack_SendObject(object);
	}
}

/** */
CString CHttp::Encode( CString s )
{
	CString s1;

	s1 = s.Replace("&","&amp;");
	s1 = s1.Replace(">","&gt;");
	s1 = s1.Replace("<","&lt;");
	s1 = s1.Replace("\x7f","&#x25a1;");
	s1 = s1.Replace("=","&#61;");
	s1 = s1.Replace(" ","&#32;");

	return s1;
}

/** */
CString CHttp::Decode( CString s )
{
	CString s1;

	s1 = s.Replace("&gt;",">");
	s1 = s1.Replace("&lt;","<");
	s1 = s1.Replace("&#x25a1;","\x7f");
	s1 = s1.Replace("&#61;","=");
	s1 = s1.Replace("&#32;"," ");
	s1 = s1.Replace("&amp;","&");

	return s1;
}
