/*
 * Copyright (C) MX4J.
 * All rights reserved.
 *
 * This software is distributed under the terms of the MX4J License version 1.0.
 * See the terms of the MX4J License in the documentation provided with this software.
 */

package javax.management;

/**
 * The metadata class for a parameter of MBean constructors and operations.
 *
 * @author <a href="mailto:biorn_steedom@users.sourceforge.net">Simone Bordet</a>
 * @version $Revision: 1.6 $
 */
public class MBeanParameterInfo extends MBeanFeatureInfo
{
   private static final long serialVersionUID = 7432616882776782338L;

   /**
    * @serial The parameter type
    */
   private String type;

   /**
    * Creates a new MBeanParameterInfo
    * @param name The parameter name
    * @param type The parameter type
    * @param description The parameter description
    */
   public MBeanParameterInfo(String name, String type, String description)
   {
      super(name, description);
      this.type = type;
   }

   /**
    * Returns the parameter type
    * @return
    */
   public String getType()
   {
      return type;
   }

   public int hashCode()
   {
      int hash = super.hashCode();
      String type = getType();
      hash ^= type == null ? 0 : type.hashCode();
      return hash;
   }

   public boolean equals(Object obj)
   {
      if (!super.equals(obj)) return false;

      try
      {
         MBeanParameterInfo other = (MBeanParameterInfo)obj;
         String type = getType();
         String otherType = other.getType();
         if (type != null && !type.equals(otherType)) return false;
         if (type == null && otherType != null) return false;
         return true;
      }
      catch (ClassCastException ignored)
      {
      }
      return false;
   }
}
