///////////////////////////////////////////////////////////////////////////////
//
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

#ifndef __TACHYON_RENDERER_H
#define __TACHYON_RENDERER_H

#include <core/Core.h>
#include <core/rendering/PluginRenderer.h>
#include <core/scene/animation/controller/Controller.h>
#include "../TachyonPlugin.h"
#include "TachyonExportInterface.h"

#include "../tachyonlib/tachyon.h"

namespace TachyonPlugin {

/******************************************************************************
* A scene renderer that makes use of the Tachyon raytrace engine.
******************************************************************************/
class TACHYON_DLLEXPORT TachyonRenderer : public PluginRenderer
{
public:
	/// Default constructor.
	TachyonRenderer(bool isLoading = false);

	///	Prepares the renderer for rendering of the given scene.
	/// Throws an exception on error. Returns false when the operation has been aborted by the user.
	virtual bool startRender(DataSet* dataset);

	/// Renders a single animation frame into the given frame buffer.
	/// Throws an exception on error. Returns false when the operation has been aborted by the user.
	virtual bool renderFrame(TimeTicks time, CameraViewDescription view, FrameBuffer* frameBuffer);

	///	Finishes the rendering pass. This is called after all animation frames have been rendered
	/// or when the rendering operation has been aborted.
	virtual void endRender();

private:

	/// Loads all installed scene object export interfaces.
	void loadCustomExporters();

private:

	/// The data set to be rendered.
	/// This field is only used during a render pass.
	DataSet* dataset;

	/// Turns anti-aliasing on/off
	PropertyField<bool> _enableAntialiasing;

	/// Controls quality of antialiasing.
	PropertyField<int> _antialiasingSamples;

	/// Rendering modes:
	///  0 - No shadows / no ambient occlusion.
	///  1 - Shadows / no ambient occlusion
	///  2 - Shadows / ambient occlusion
	PropertyField<int> _renderingMode;

	/// Controls quality of ambient occlusion.
	PropertyField<int> _ambientOcclusionSamples;

	/// The Tachyon internal scene handle.
	SceneHandle _rtscene;

	/// List of installed object exporters.
	QVector<TachyonExportInterface::SmartPtr> _exportInterfaces;

	Q_OBJECT
	DECLARE_SERIALIZABLE_PLUGIN_CLASS(TachyonRenderer)
	DECLARE_PROPERTY_FIELD(_enableAntialiasing)
	DECLARE_PROPERTY_FIELD(_renderingMode)
	DECLARE_PROPERTY_FIELD(_antialiasingSamples)
	DECLARE_PROPERTY_FIELD(_ambientOcclusionSamples)
};

};	// End of namespace TachyonPlugin

#endif // __TACHYON_RENDERER_H
