#include <rumba/manifoldFile.h>
#include <rumba/arghandler.h>
#include <rumba/parse.h>
#include <rumba/util.hpp>
#include <iostream>
#include <cstdlib>
#include <vector>
#include <fstream>

using std::cout;
using std::cerr;
using std::endl;
using std::vector;
using std::string;
using RUMBA::stream_cast;

void error()
{
	cerr  << "Usage: getheader -i infile -o outfile header1 header2 header3" << endl;
}

int main(int argc, char** argv)
{
//	RUMBA::ArgHandler::setRequiredDefaultArg("infile");
	std::ostream* out = &std::cout;
	std::ofstream fout;

	try 
	{
		RUMBA::ArgHandler argh(argc,argv);
		string infile,outfile;
		/* 
		   intPoint origin,dims;
		bool verbose;
		bool debug = true;
		*/
		if ( argh.arg("help" ))
		{
			error();
			exit (EXIT_SUCCESS);
		}

		argh.arg_or_loose("infile", infile );
		if (argh.arg("outfile"))
			argh.arg("outfile",outfile);
		if (!outfile.empty())
		{
			fout.open(outfile.c_str());
			if (!fout)
			{
				throw RUMBA::BadFile(outfile);
			}
			out = &fout;
		}	
		vector<string> v = argh.loose();

		RUMBA::ManifoldFile* M = RUMBA::ManifoldFile::construct(infile.c_str());
		if (!M)
		{
			std::cerr << "Couldn't open input" << std::endl;
			exit(1);
		}

		for ( vector<string>::const_iterator it = v.begin(); it != v.end(); ++it )
		{
			*out << *it << ": " << M->headerData()[*it] << endl;
		}
	
	}
    catch (RUMBA::MissingArgumentException& s)
    {
		cerr << "Error, missing required argument: " << s.error() << endl;
	}
    catch (RUMBA::DuplicateArgumentException& s)
    {
		cerr << "Duplicate argument: " << s.error() << endl;
	}
	catch (RUMBA::ArgHandlerException& s)
	{
		cerr << "Error: " << s.error() << endl;
	}                   
	catch ( RUMBA::Exception & e)
	{
		cerr << "Fatal exception " << e.error() << endl;	
	}

	return 0;
}
