#include <rumba/dl.h>
#include <rumba/rumba_system.h>
#include <rumba/parse.h>

#include <dlfcn.h> // dlopen()

#include <string>
#include <algorithm> //debugging 
#include <iostream>

using std::string;
using std::list;

std::list<void*> RUMBA::dl_init()
{
	list<void*> handles;
	void* ptr;

	string mod_dir = RUMBA::find_file_modules();
	string filename;
	list<string> v = RUMBA::ls(mod_dir);


	if ( ! v.empty())
		RUMBA::pruneFileList(v,".la");

	if ( v.empty() )
		return handles;

//	std::copy (v.begin(), v.end(),std::ostream_iterator<string>(std::cout,"\n"));

	list<string>::const_iterator it = v.begin();

	for (; it!=v.end();++it  )
	{
		filename = get_dlname( string( mod_dir  + "/" + (*it) ) );
//		cout << "get_dlname() OK: filename is :" << filename << endl;
		filename = mod_dir + string("/") + filename;
//		cout << "About to open: " << filename.c_str() << endl;
		ptr =  dlopen ( filename.c_str(), RTLD_NOW );
//		cout << "dlopen() OK" << endl;
		if (ptr) 
		{
//			std::cout << "Opened " << filename << std::endl;
		}
		else
			std::cerr << dlerror() << std::endl;

		if (ptr)
			handles.push_back (ptr);
	}

	return handles;
	
}

void RUMBA::dl_shutdown ( std::list<void*> & v )
{
	while ( ! v.empty() )
	{
		dlclose(v.front());
		v.pop_front();
	}
}
