#include <rumba/fileIO.h>

#include <rumba/rumba_system.h>






void RUMBA::iGet( char* dest, const char* buf, int nelts, bool )
{//{{{
	
	int i=0;
	for ( ; i<nelts; i++ )	
		*(dest++) = *(buf++);
}//}}}

void RUMBA::iGet(short* dest, const char* buf, int nelts, bool le)
{//{{{
	int i=0;
	unsigned char lsb, msb;
	short value;
	for ( ; i<nelts; i++ )
	{
		if (le) {
	        lsb=buf[0];
	        msb=buf[1];
		} else {
	        msb=buf[0];
	        lsb=buf[1];
	  }
	  value = (msb << 8) | lsb;
	  *(dest++) = value;
	  buf += sizeof(short);
	}

}//}}}



void RUMBA::iGet(int* dest, const char* buf, int nelts, bool le)
{ //{{{

	int i = 0;
	unsigned char llsb, lsb, msb, mmsb;
	for (; i<nelts; ++i)
	{	
		if (le) {
        	llsb=buf[0];
        	lsb=buf[1];
        	msb=buf[2];
        	mmsb=buf[3];
  		} else {
        	mmsb=buf[0];
        	msb=buf[1];
        	lsb=buf[2];
        	llsb=buf[3];
  		}
  		int value = (mmsb << 24) | (msb << 16) | (lsb << 8) | llsb ;
	  	*(dest++) = value;
	  	buf += sizeof(int);
	}
}//}}}


void RUMBA::iGet(float* res, const char* buf, int nelts, bool le)
{//{{{
	char bytes[4];

	if ( littleEndianHost() == le ) 	// use memmove in case of overlap
	{
		if ((const char*)res != buf)
			memcpy ( (void*)res, (void*)buf, nelts * 4 ); 
	}
	else
	for ( int j = 0; j<nelts; ++j )
	{
		for ( short i=0; i<4; ++i ) 
		bytes[4-1-i] = buf[i];
		memcpy ( (void*)res, (void*)bytes, 4 );
		buf += 4;
		res++;
	}
}//}}}

void RUMBA::iGet(double* res, const char* buf, int nelts, bool le)
{//{{{
	char bytes[8];

	if ( littleEndianHost() == le ) 	
	{
		if ( (const char*)res != buf )
			memcpy ( (void*)res, (void*)buf, nelts * 8 ); 
	}
	else
	for ( int j = 0; j<nelts; ++j )
	{
		for ( int i=0; i<8; ++i ) 
		bytes[8-1-i] = buf[i];
		memcpy ( (void*)res, (void*)bytes, 8 );
		buf += 8;
		res++;
	}
}//}}}

//---------------------------------------- PUT

void RUMBA::iPut(char* dest, const char* src, int nelts, bool )
{ //{{{
	if ( (const char*)dest != src )
		memcpy ( (void*)dest, (void*)src, nelts );
}//}}}

void RUMBA::iPut(char* dest, const short* src, int  nelts, bool le )
{ //{{{
	unsigned char lsb, msb;
	short val;
	for (int i = 0; i<nelts; ++i)
	{
		val = *src++;
		lsb = val & 0xff;
		msb = val >> 8;

		if (le) {
			*dest++ = lsb;
			*dest++ = msb;
		} else {
			*dest++ = msb;
			*dest++ = lsb;
		}
	}

}//}}}

void RUMBA::iPut(char* dest, const int* src, int nelts, bool le  )
{ //{{{

	unsigned char llsb, lsb, msb, mmsb;
	int val;

	for (int i =0; i<nelts; ++i)
	{
 		val = *src++; 
		llsb = val & 0xff;
		lsb = (val >> 8) & 0xff;
		msb = (val >> 16) & 0xff;
		mmsb = (val >> 24);

  		if (le) {
        	*dest++ = llsb;
        	*dest++ = lsb;
        	*dest++ = msb;
        	*dest++ = mmsb;
  		} else {
        	*dest++ = mmsb;
        	*dest++ = msb;
        	*dest++ = lsb;
        	*dest++ = llsb;
  		}
	}
}//}}}


void RUMBA::iPut(char* dest, const float* src, int nelts, bool le)
{//{{{

	char bytes[4];

	// if no byteswap is required, use memcpy()

	if ( littleEndianHost() == le )
	{
		if ( (char*) src != dest )
			memcpy( (void*)dest, (void*)src, nelts * 4 );
	}
	else
	{	// otherwise, we have some work to do.
		short i =0;
	   	int j=0;
		for ( j =0; j<nelts; ++j )
		{
			memcpy ( (void*)bytes, (void*)src, 4 ); // initialise copy buffer
			for ( i=0; i<4; ++i ) 
				dest[4-1-i] = bytes[i]; // note the offset! dest[3] = bytes[0]
			dest += 4;	// increase dest by 4 since it's char*
			src += 1;	// increase src by only 1 since it's float*
		}
	}
}//}}}

void RUMBA::iPut(char* dest, const double* src, int nelts, bool le)
{//{{{

	char bytes[8];

	// if no byteswap is required, use memcpy()

	if ( littleEndianHost() == le )
	{
		if ( (char*)src != dest )
			memcpy( (void*)dest, (void*)src, nelts * 8 );
	}
	else
	{	// otherwise, we have some work to do.
		short i=0; 
		int j=0;
		for ( j =0; j<nelts; ++j )
		{
			memcpy ( (void*)bytes, (void*)src, 8 ); // initialise copy buffer
			for ( i=0; i<8; ++i ) 
				dest[8-1-i] = bytes[i]; // note the offset! dest[7] = bytes[0]
			dest += 8;	// increase dest by 8 since it's char*
			src += 1;	// increase src by only 1 since it's float*
		}
	}
}//}}}





/**
void RUMBA::BaseManifold::putFloat(ofstream& file, float val) const
//{{{
{
  char *bytes = new char[4];
  ostrstream dataArray(bytes,4);

  dataArray.write(&val,4);

  if (LittleEndian) {
        file.put(bytes[0]);
        file.put(bytes[1]);
        file.put(bytes[2]);
        file.put(bytes[3]);
  } else {
        file.put(bytes[3]);
        file.put(bytes[2]);
        file.put(bytes[1]);
        file.put(bytes[0]);
  }

  delete bytes;
} //}}}

//{{{
void RUMBA::BaseManifold::putDouble(ofstream& file, double val) const
{
  char *bytes = new char[8];
  ostrstream dataArray(bytes,8);

  dataArray.write(&val,8);

  if (LittleEndian) {
        file.put(bytes[0]);
        file.put(bytes[1]);
        file.put(bytes[2]);
        file.put(bytes[3]);
        file.put(bytes[4]);
        file.put(bytes[5]);
        file.put(bytes[6]);
        file.put(bytes[7]);
  } else {
        file.put(bytes[7]);
        file.put(bytes[6]);
        file.put(bytes[5]);
        file.put(bytes[4]);
        file.put(bytes[3]);
        file.put(bytes[2]);
        file.put(bytes[1]);
        file.put(bytes[0]);
  }

  delete bytes;
}

*/
//}}}
