template <class TYPE>
void RUMBA::Manifold<TYPE>::loadMinc(string imgname, bool loadData  )
{
	long result[4];
	long start[4] = { 0,0,0,0 };
	struct netcdfDescriptor D;
	nc_type t;

	D.cdf = ncopen ( imgname.c_str(), NC_NOWRITE );
	mincInitDescriptor ( &D );
    mincSize ( D, result );   

	Width = (int)result[0]; 
	Height = (int)result[1];
	Depth = (int)result[2];
	TimePoints = (int)result[3];
	Size = Width * Height * Depth * TimePoints;

	if ( loadData )
		allocate ( Width, Depth, Height, TimePoints );

	t = mincGetDataType ( D );

	switch ( t ) 
	{
		case NC_CHAR: fileDataType=TYPE_CHAR;break;
		case NC_SHORT: fileDataType=TYPE_SHORT;break;
		case NC_LONG: fileDataType=TYPE_INT;break;
		case NC_FLOAT: fileDataType=TYPE_FLOAT;break;
		case NC_DOUBLE: fileDataType=TYPE_DOUBLE;break;
		default:
			cerr << "Unknown type in Manifold<TYPE>::loadMinc\n";
	}

	if ( loadData )
	{
		void* tmpDataArray = malloc  (  Size * nctypelen ( t )  );
		ncvarget ( D.cdf, D.image, start, result, tmpDataArray );
		int size = Size;
		TYPE* dstDataArray = DataArray;
		char* cPtr; short* sPtr; int* iPtr; float* fPtr; double* dPtr;
		switch ( t )
		{
			case NC_CHAR: 
				cPtr = (char*) tmpDataArray;	
				while ( size-- ) *(dstDataArray++) = (TYPE)*(cPtr++);
				break;
			case NC_LONG:
				iPtr = (int*) tmpDataArray;	
				while ( size-- ) *(dstDataArray++) = (TYPE)*(iPtr++);
				break;
			case NC_SHORT:
				sPtr = (short*) tmpDataArray;	
				while ( size-- ) *(dstDataArray++) = (TYPE)*(sPtr++);
				break;
			case NC_FLOAT:
				fPtr = (float*) tmpDataArray;	
				while ( size-- ) *(dstDataArray++) = (TYPE)*(fPtr++);
				break;
			case NC_DOUBLE:
				dPtr = (double*) tmpDataArray;
				while ( size-- ) *(dstDataArray++) = (TYPE)*(dPtr++);
				break;
			default:
				cerr  << "Unsupported data type" << endl;
		}
		free ( tmpDataArray );
	}

}

template <class TYPE>
void RUMBA::Manifold<TYPE>::saveMinc(string imgname) const
{
	RUMBA::Patient p;
	struct netcdfDescriptor D;
	long start[4] = { 0,0,0,0 };
	long count[4] = { (long)Width, (long)Height, (long)Depth, (long)TimePoints };

	D.cdf = nccreate ( imgname.c_str(), NC_CLOBBER );

	/* Define the dimensions */
	D.dim[0] = ncdimdef ( D.cdf, MIxspace, Width );
	D.dim[1] = ncdimdef ( D.cdf, MIyspace, Height );
	D.dim[2] = ncdimdef ( D.cdf, MIzspace, Depth  );
	D.dim[3] = ncdimdef ( D.cdf, MItime, TimePoints );

	/* Define the variables */
	D.space[0] = ncvardef ( D.cdf, MIxspace, NC_DOUBLE, 0, 0 );
	D.space[1] = ncvardef ( D.cdf, MIyspace, NC_DOUBLE, 0, 0 );
	D.space[2] = ncvardef ( D.cdf, MIzspace, NC_DOUBLE, 0, 0 );
	D.space[3] = ncvardef ( D.cdf, MItime, NC_DOUBLE, 0, 0 );

	ncattput ( D.cdf, D.space[0], MIstep, NC_DOUBLE, 1, &DimX  );
	ncattput ( D.cdf, D.space[1], MIstep, NC_DOUBLE, 1, &DimY  );
	ncattput ( D.cdf, D.space[2], MIstep, NC_DOUBLE, 1, &DimZ  );

	ncattput ( D.cdf, D.space[0], MIstart, NC_DOUBLE, 1, &OriginX  );
	ncattput ( D.cdf, D.space[1], MIstart, NC_DOUBLE, 1, &OriginY  );
	ncattput ( D.cdf, D.space[2], MIstart, NC_DOUBLE, 1, &OriginZ  );

	/*	Save patient record */
	/*----------------------*/
	D.patient = ncvardef ( D.cdf, MIpatient, NC_LONG, 0, 0 );

	ncattput ( D.cdf, D.patient, 
		MIfull_name, NC_CHAR, p.fullname.length() + 1, p.fullname.c_str() );
	ncattput ( D.cdf, D.patient, 
		MIother_names, NC_CHAR, p.other_names.length() + 1, p.other_names.c_str() );
	ncattput ( D.cdf, D.patient, 
		MIidentification, NC_CHAR, p.identification.length() + 1, p.identification.c_str() );
	ncattput ( D.cdf, D.patient, 
		MIother_ids, NC_CHAR, p.other_ids.length() + 1, p.other_ids.c_str() );
	ncattput ( D.cdf, D.patient, 
		MIbirthdate, NC_CHAR, p.birthdate.length() + 1, p.birthdate.c_str() );
	ncattput ( D.cdf, D.patient, 
		MIsex, NC_CHAR, p.sex.length() + 1, p.sex.c_str() );
	ncattput ( D.cdf, D.patient, 
		MIaddress, NC_CHAR, p.address.length() + 1, p.address.c_str() );
	ncattput ( D.cdf, D.patient, 
		MIinsurance_id, NC_CHAR, p.insurance_id.length() + 1, p.insurance_id.c_str() );
	ncattput ( D.cdf, D.patient,
		MIweight, NC_DOUBLE, 1, &p.weight );

	ncattput ( D.cdf, D.patient,
		MIsize, NC_DOUBLE, 1, &p.size );

	/*	Done saving patient !!!							*/
	/*--------------------------------------------------*/

	/*	Probably shouldn't hardcode four dimensions ! */
	D.image = ncvardef ( D.cdf, MIimage, NC_DOUBLE, 4, D.dim );

	/* End definition mode	*/
	ncendef(D.cdf);

	ncvarput ( D.cdf, D.image, start, count, (void*)DataArray );
	(void)ncclose(D.cdf);



}


