#include <fstream>
#include <sstream>
#include <list>
#include <map>

#include <rumba/exception.h>
#include <rumba/splodge.h>
#include <rumba/parse.h>
#include <rumba/constants.h>

#include <rumba/header_request.h>


#include <rumba/parsecsv.h>


// invisible in other translation units.
namespace 
{

RUMBA::Splodge fix_default_value_str(std::string defval, std::string type)
{
	if ( type == "char" )
		return RUMBA::Splodge(defval);
	if ( type == "int16" || type == "int32" )
		return RUMBA::Splodge ( RUMBA::stream_cast<int>(defval) );
	if ( type == "float64" || type == "float32" )
		return RUMBA::Splodge ( RUMBA::stream_cast<double>(defval) );
	// throw exception !!!
	throw RUMBA::Exception ( "Bad file format" );
}

int typeNameToNum ( std::string type )
{
	if ( type == "char" ) return RUMBA::TYPE_CHAR;
	if ( type == "int16" ) return RUMBA::TYPE_SHORT;
	if ( type == "int32" ) return RUMBA::TYPE_INT;
	if ( type == "float32" ) return RUMBA::TYPE_FLOAT;
	if ( type == "float64" ) return RUMBA::TYPE_DOUBLE;
	return -1;

}



RUMBA::header_request 
readTokens 
( std::list<std::string> & tokens )
{
	std::string type, required_flags, default_value_str;
	RUMBA::header_request req;

	req.name = tokens.front(); 
	tokens.pop_front();
	type = tokens.front(); 
	tokens.pop_front();
	req.offset = RUMBA::stream_cast<int>(tokens.front()); 
	tokens.pop_front();
	if (! tokens.empty() )
	{
		req.bytes= RUMBA::stream_cast<int>(tokens.front());
		tokens.pop_front();
	}

	if (! tokens.empty() )
	{
		required_flags= tokens.front(); 
		tokens.pop_front();
		if ( required_flags == "1" || required_flags == "true" )
			req.required = 1;
		else
			req.required = 0;
	}


	req.type = typeNameToNum(type);

	if (! tokens.empty() )
	{
		default_value_str = tokens.front(); 
		tokens.pop_front();
		req.default_value = fix_default_value_str(default_value_str, type);
	}



	return req;
}



}// end namespace

void RUMBA::parseCsv ( std::list<RUMBA::header_request> & li,  std::istream& fin)
{
	std::string line;
	std::list<std::string> tokens;
	RUMBA::header_request req;

	while (getline (fin, line ))
	{
		req = RUMBA::header_request();
		tokens = RUMBA::tokenizeCsvLine(line);
		if ( tokens.size() < 3 ) 
			throw 0;
		req = readTokens(tokens );
		li.push_back (req);
	}
}



/*

int main()
{
	ifstream fin ( "analyze_header_request.csv" );
	std::map<std::string, RUMBA::header_request>  m;
	parseCsv ( m, fin);
}

*/
