#include <header_request.h>
#include <constants.h>

struct header_request 
siemens_header_request[] = 
{

	header_request("study_start_year", TYPE_INT, 0 ),
	header_request("study_start_month", TYPE_INT, 4 ),
	header_request("study_start_day", TYPE_INT, 8 ),
	header_request("study_start_hour", TYPE_INT, 36 ),
	header_request("study_start_minute", TYPE_INT, 40 ),
	header_request("study_start_seconds", TYPE_INT, 44 ),
	header_request("study_manufacturer", TYPE_INT, 96, 7),
	header_request("study_institution", TYPE_INT, 105, 25),
	header_request("study_device-model", TYPE_INT, 281, 15),
	header_request("study_study-id", TYPE_CHAR, 5943, 3),



	header_request("patient_name",TYPE_CHAR,768,25),
	header_request("patient_id",TYPE_CHAR,795,21),
	header_request("patient_dob_year",TYPE_INT,808),
	header_request("patient_dob_month",TYPE_INT,812),
	header_request("patient_dob_date",TYPE_INT,816),
	header_request("patient_age",TYPE_CHAR,851,3),
	header_request("patient_age_units",TYPE_CHAR,854,1),



	header_request("acquisition_injection_year",TYPE_INT,12),
	header_request("acquisition_injection_month",TYPE_INT,16),
	header_request("acquisition_injection_date",TYPE_INT,20),

	header_request("acquisition_injection_hour",TYPE_INT,52),
	header_request("acquisition_injection_minute",TYPE_INT,56),
	header_request("acquisition_injection_seconds",TYPE_INT,60),


	header_request("acquisition_echo-time", TYPE_INT, 1568),


	
	header_request("dimX",TYPE_DOUBLE, 5000 ),
	header_request("dimY",TYPE_DOUBLE, 5008 ),
	header_request("dimZ",TYPE_DOUBLE, 1544 ),
	header_request("dimT",TYPE_DOUBLE, 1560 ),

	header_request("FOVX",TYPE_DOUBLE, 3744 ),
	header_request("FOVY",TYPE_DOUBLE, 3752 ),

	header_request("OriginX",TYPE_DOUBLE, 3768),
	header_request("OriginY",TYPE_DOUBLE, 3776),
	header_request("OriginZ",TYPE_DOUBLE, 3784),






	header_request("private_DisplayMatrixSize", TYPE_INT, 2864 ),

  	header_request("private_OrientationSet1Top",TYPE_CHAR,3880,3),
	header_request("private_OrientationSet1Left",TYPE_CHAR,3884,3),
	header_request("private_OrientationSet1Back",TYPE_CHAR,3888,3),
  	header_request("private_OrientationSet2Down",TYPE_CHAR,3892,3),
  	header_request("private_OrientationSet2Right",TYPE_CHAR,3896,3),
  	header_request("private_OrientationSet2Front",TYPE_CHAR,3900,3),

	header_request("private_NumSlices", TYPE_INT, 4008 ),
	header_request("private_SliceOrder", TYPE_INT, 4144 ),
		//Ascending: 1 - Descending: 2 - Interleaved:4



	header_request()

};
	

/**

  ... it seems we have "study", acquisition", and "image". Need to work out correspondences with 
  minc. What do they mean ??

	------------------ Study

	Minc study variable
	
	MIstart_{year,month,day,hour,minute,seconds}

  	inImage.seekg(0); headstruct.SiemensStudyDateYYYY = GetInt(inImage, littleEndianIn);
  	inImage.seekg(4); headstruct.SiemensStudyDateMM = GetInt(inImage, littleEndianIn);
  	inImage.seekg(8); headstruct.SiemensStudyDateDD = GetInt(inImage, littleEndianIn);

  	inImage.seekg(36); headstruct.SiemensStudyTimeHH = GetInt(inImage, littleEndianIn);
  	inImage.seekg(40); headstruct.SiemensStudyTimeMM = GetInt(inImage, littleEndianIn);
  	inImage.seekg(44); headstruct.SiemensStudyTimeSS = GetInt(inImage, littleEndianIn);

	*/





/*
	------------------ Acquisition

	Minc acquisition variable

	MIinjection_{year,month,day,hour,minute,seconds}

  	inImage.seekg(12); headstruct.AcquisitionDateYYYY = GetInt(inImage, littleEndianIn);
  	inImage.seekg(16); headstruct.AcquisitionDateMM = GetInt(inImage, littleEndianIn);
  	inImage.seekg(20); headstruct.AcquisitionDateDD = GetInt(inImage, littleEndianIn);

  	inImage.seekg(52); headstruct.AcquisitionTimeHH = GetInt(inImage, littleEndianIn);
  	inImage.seekg(56); headstruct.AcquisitionTimeMM = GetInt(inImage, littleEndianIn);
  	inImage.seekg(60); headstruct.AcquisitionTimeSS = GetInt(inImage, littleEndianIn);

	------------------ Image.

	image_time

  	inImage.seekg(24); headstruct.ImageDateYYYY = GetInt(inImage, littleEndianIn);
  	inImage.seekg(28); headstruct.ImageDateMM = GetInt(inImage, littleEndianIn);
  	inImage.seekg(32); headstruct.ImageDateDD = GetInt(inImage, littleEndianIn);

  	inImage.seekg(68); headstruct.ImageTimeHH = GetInt(inImage, littleEndianIn);
  	inImage.seekg(72); headstruct.ImageTimeMM = GetInt(inImage, littleEndianIn);
  	inImage.seekg(76); headstruct.ImageTimeSS = GetInt(inImage, littleEndianIn);


	------------------- Looks like stuff about the machine. lastmove ???

	MImanufacturer (study)
  	inImage.seekg(96); inImage.read(headstruct.Manufacturer,7);

	MIinstitution (study)
  	inImage.seekg(105); inImage.read(headstruct.InstitutionName,25);

  	inImage.seekg(186); inImage.read(headstruct.Annotation,4);

	MIdevice_model
  	inImage.seekg(281); inImage.read(headstruct.ModelName,15);

	--- last time table moved. 
	--- subjects head quasi-invariant if time table is

  	inImage.seekg(412); headstruct.LastMoveDateYYYY = GetInt(inImage, littleEndianIn);
  	inImage.seekg(416); headstruct.LastMoveDateMM = GetInt(inImage, littleEndianIn);
  	inImage.seekg(420); headstruct.LastMoveDateDD = GetInt(inImage, littleEndianIn);
  	inImage.seekg(424); headstruct.LastMoveTimeHH = GetInt(inImage, littleEndianIn);
  	inImage.seekg(428); headstruct.LastMoveTimeMM = GetInt(inImage, littleEndianIn);
  	inImage.seekg(432); headstruct.LastMoveTimeSS = GetInt(inImage, littleEndianIn);


	------------------ Patient 

	MIfull_name, MIidentification, MIage. What is PatientAgeUnits ? 
	Note MIbirthdate (could manufactur it from YYYY,MM,DD).

  	inImage.seekg(768); inImage.read(headstruct.PatientName,25);
  	inImage.seekg(795); inImage.read(headstruct.PatientID,12);
  	inImage.seekg(808); headstruct.DOBYYYY = GetInt(inImage, littleEndianIn);
  	inImage.seekg(812); headstruct.DOBMM = GetInt(inImage, littleEndianIn);
  	inImage.seekg(816); headstruct.DOBDD = GetInt(inImage, littleEndianIn);
  	inImage.seekg(851); inImage.read(headstruct.PatientAge,3);
  	inImage.seekg(854); headstruct.PatientAgeUnits = GetChar(inImage);


	-------------------- Looks like more stuff about the machine

  	inImage.seekg(1052); headstruct.RegistrationDateYYYY = GetInt(inImage, littleEndianIn);
  	inImage.seekg(1056); headstruct.RegistrationDateMM = GetInt(inImage, littleEndianIn);
  	inImage.seekg(1060); headstruct.RegistrationDateDD = GetInt(inImage, littleEndianIn);
  	inImage.seekg(1064); headstruct.RegistrationTimeHH = GetInt(inImage, littleEndianIn);
  	inImage.seekg(1068); headstruct.RegistrationTimeMM = GetInt(inImage, littleEndianIn);
  	inImage.seekg(1072); headstruct.RegistrationTimeSS = GetInt(inImage, littleEndianIn);

	------ This is DimZ

  	inImage.seekg(1544); headstruct.SliceThickness = GetDouble(inImage, littleEndianIn);

	-- And this is DimT
  	inImage.seekg(1560); headstruct.RepetitionTime = GetDouble(inImage, littleEndianIn);

	MIecho_time (acq)

  	inImage.seekg(1568); headstruct.EchoTime = GetDouble(inImage, littleEndianIn);

	MIimaging_frequency (acq)
  	inImage.seekg(1592); headstruct.FrequencyMHz = GetDouble(inImage, littleEndianIn);

  	inImage.seekg(1639); inImage.read(headstruct.Station,5);
  	inImage.seekg(1712); headstruct.CalibrationDateYYYY = GetInt(inImage, littleEndianIn);
  	inImage.seekg(1716); headstruct.CalibrationDateMM = GetInt(inImage, littleEndianIn);
  	inImage.seekg(1720); headstruct.CalibrationDateDD = GetInt(inImage, littleEndianIn);
  	inImage.seekg(1724); headstruct.CalibrationTimeHH = GetInt(inImage, littleEndianIn);
  	inImage.seekg(1728); headstruct.CalibrationTimeMM = GetInt(inImage, littleEndianIn);
  	inImage.seekg(1732); headstruct.CalibrationTimeSS = GetInt(inImage, littleEndianIn);
  	inImage.seekg(1767); inImage.read(headstruct.ReceivingCoil,16);

	MIimaged_nucleus (acq)
  	inImage.seekg(1828); inImage.read(headstruct.ImagedNucleus,4);
  	inImage.seekg(2112); headstruct.FlipAngle = GetDouble(inImage, littleEndianIn);
  	inImage.seekg(2560); headstruct.MagneticFieldStrength = GetDouble(inImage, littleEndianIn);
  	inImage.seekg(2720); headstruct.ADC1 = GetDouble(inImage, littleEndianIn);
  	inImage.seekg(2728); headstruct.ADC2 = GetDouble(inImage, littleEndianIn);
  	inImage.seekg(2792); headstruct.RPEI = GetDouble(inImage, littleEndianIn);


	--------------------------- ***** This is important -- it tells us about the mosaic size !!!
  	inImage.seekg(2864); headstruct.DisplayMatrixSize = GetInt(inImage, littleEndianIn);

	
	--------------------------- Huh ?

	--- pulse sequence program name : software to extract binary data
	--- from EM pulses.

  	inImage.seekg(2944); inImage.read(headstruct.SequencePrgName,65);
  	inImage.seekg(3009); inImage.read(headstruct.SequenceWkcName,65);
  	inImage.seekg(3074); inImage.read(headstruct.SequenceAuthor,9);
  	inImage.seekg(3083); inImage.read(headstruct.SequenceType,8);


	--- study number, image number

  	inImage.seekg(3200); headstruct.StuNo = GetInt(inImage, littleEndianIn);
  	inImage.seekg(3212); headstruct.ImaNo = GetInt(inImage, littleEndianIn);

	--------------------------- Info about image size and position


  	inImage.seekg(3744); headstruct.FOVRow = GetDouble(inImage, littleEndianIn);
  	inImage.seekg(3752); headstruct.FOVColumn = GetDouble(inImage, littleEndianIn);

	This is the origin ...  ?
	---------------------------
  	inImage.seekg(3768); headstruct.CenterPointX = GetDouble(inImage, littleEndianIn);
  	inImage.seekg(3776); headstruct.CenterPointY = GetDouble(inImage, littleEndianIn);
  	inImage.seekg(3784); headstruct.CenterPointZ = GetDouble(inImage, littleEndianIn);

	This is the vector out of the plane (?)
	------------------------------------------
  	inImage.seekg(3792); headstruct.NormalVectorX = GetDouble(inImage, littleEndianIn);
  	inImage.seekg(3800); headstruct.NormalVectorY = GetDouble(inImage, littleEndianIn);
  	inImage.seekg(3808); headstruct.NormalVectorZ = GetDouble(inImage, littleEndianIn);

	What is this ?
	--------------------
  	inImage.seekg(3816); headstruct.DistanceFromIsocenter = GetDouble(inImage, littleEndianIn);

	Co-ordinate axes for x and y dimensions (?)
	-------------------------------------------------
  	inImage.seekg(3832); headstruct.RowVectorX = GetDouble(inImage, littleEndianIn);
  	inImage.seekg(3840); headstruct.RowVectorY = GetDouble(inImage, littleEndianIn);
  	inImage.seekg(3848); headstruct.RowVectorZ = GetDouble(inImage, littleEndianIn);
  	inImage.seekg(3856); headstruct.ColumnVectorX = GetDouble(inImage, littleEndianIn);
  	inImage.seekg(3864); headstruct.ColumnVectorY = GetDouble(inImage, littleEndianIn);
  	inImage.seekg(3872); headstruct.ColumnVectorZ = GetDouble(inImage, littleEndianIn);

	Each of these should probably be sag, cor or tra
	Question -- why have both front and back, left/right, top/bottom ???
	-----------------------------------------------------------------------
  	inImage.seekg(3880); inImage.read(headstruct.OrientationSet1Top,3);
  	inImage.seekg(3884); inImage.read(headstruct.OrientationSet1Left,3);
  	inImage.seekg(3888); inImage.read(headstruct.OrientationSet1Back,3);
  	inImage.seekg(3892); inImage.read(headstruct.OrientationSet2Down,3);
  	inImage.seekg(3896); inImage.read(headstruct.OrientationSet2Right,3);
  	inImage.seekg(3900); inImage.read(headstruct.OrientationSet2Front,3);

	DimX and DimY
	---------------------
  	inImage.seekg(5000); headstruct.PixelSizeRow = GetDouble(inImage, littleEndianIn);
  	inImage.seekg(5008); headstruct.PixelSizeColumn = GetDouble(inImage, littleEndianIn);


	--------------- A lot of this seems redundant. Maybe we should just "dump" it when 
	--------------- we're working with formats that support "dumping" (minc, stimulate, 
	--------------- our own custom formats ... )

  	inImage.seekg(5504); inImage.read(headstruct.TextPatientID,12);
  	inImage.seekg(5517); headstruct.TextPatientSex = GetChar(inImage);
  	inImage.seekg(5518); inImage.read(headstruct.TextPatientAge,3);
  	inImage.seekg(5521); headstruct.TextPatientAgeUnits = GetChar(inImage);
  	inImage.seekg(5529); inImage.read(headstruct.TextPatientPosition,7);
  	inImage.seekg(5541); inImage.read(headstruct.TextImageNumberFlag,5);
  	inImage.seekg(5547); inImage.read(headstruct.TextImageNumber,4); //not 5546,3
  	inImage.seekg(5559); inImage.read(headstruct.TextDateDD,2);
  	inImage.seekg(5562); inImage.read(headstruct.TextDateMM,3);
  	inImage.seekg(5566); inImage.read(headstruct.TextDateYYYY,4);
  	inImage.seekg(5571); inImage.read(headstruct.TextTimeHH,2);
  	inImage.seekg(5574); inImage.read(headstruct.TextTimeMM,2);
  	inImage.seekg(5577); inImage.read(headstruct.TextAcquisitionTimeFlag,2);
  	inImage.seekg(5583); inImage.read(headstruct.TextAcquisitionTimeMM,2);
  	inImage.seekg(5586); inImage.read(headstruct.TextAcquisitionTimeSS,2);
  	inImage.seekg(5601); inImage.read(headstruct.TextAnnotation,4);
  	inImage.seekg(5655); inImage.read(headstruct.TextOrganization,25);
  	inImage.seekg(5682); inImage.read(headstruct.TextStation,5);
  	inImage.seekg(5695); inImage.read(headstruct.TextAcquisitionMatrixPhase,3);
  	inImage.seekg(5698); headstruct.TextAcquisitionMatrixPhaseAxis = GetChar(inImage);
  	inImage.seekg(5700); inImage.read(headstruct.TextAcquisitionMatrixFreq,3);
  	inImage.seekg(5703); headstruct.TextAcquisitionMatrixFreqO = GetChar(inImage);
  	inImage.seekg(5704); headstruct.TextAcquisitionMatrixFreqS = GetChar(inImage);
  	inImage.seekg(5706); inImage.read(headstruct.TextSequence,8);
  	inImage.seekg(5714); inImage.read(headstruct.TextFlipAngle,3);
  	inImage.seekg(5718); inImage.read(headstruct.TextScanNumberFlag,4);
  	inImage.seekg(5723); inImage.read(headstruct.TextScanNumberA,3);
  	inImage.seekg(5726); inImage.read(headstruct.TextScanNumberB,3);
  	inImage.seekg(5730); inImage.read(headstruct.TextRepetitionTimeFlag,2);
  	inImage.seekg(5734); inImage.read(headstruct.TextRepetitionTime,7);
  	inImage.seekg(5742); inImage.read(headstruct.TextEchoTimeFlag,2);
  	inImage.seekg(5746); inImage.read(headstruct.TextEchoTime,5);
  	inImage.seekg(5752); headstruct.TextEchoNumber = GetChar(inImage);
  	inImage.seekg(5790); inImage.read(headstruct.TextSliceThicknessFlag,2);
  	inImage.seekg(5794); inImage.read(headstruct.TextSliceThickness,7);
  	inImage.seekg(5802); inImage.read(headstruct.TextSlicePositionFlag,2);
  	inImage.seekg(5806); inImage.read(headstruct.TextSlicePosition,7);
  	inImage.seekg(5814); inImage.read(headstruct.TextAngleFlag1,3);
  	inImage.seekg(5817); headstruct.TextAngleFlag2 = GetChar(inImage);
  	inImage.seekg(5818); inImage.read(headstruct.TextAngleFlag3,3);
  	inImage.seekg(5821); inImage.read(headstruct.TextAngle,4);
  	inImage.seekg(5838); inImage.read(headstruct.TextFOVFlag,3);
  	inImage.seekg(5842); inImage.read(headstruct.TextFOVH,3);
  	inImage.seekg(5846); inImage.read(headstruct.TextFOVV,3);
  	inImage.seekg(5874); inImage.read(headstruct.TextTablePositionFlag,2);
  	inImage.seekg(5878); inImage.read(headstruct.TextTablePosition,7);
  	inImage.seekg(5938); inImage.read(headstruct.TextStudyNumberFlag,5);
  	inImage.seekg(5943); inImage.read(headstruct.TextStudyNumber,3); //not 2
  	inImage.seekg(5956); inImage.read(headstruct.TextDOBDD,2);
  	inImage.seekg(5959); inImage.read(headstruct.TextDOBMM,3);
  	inImage.seekg(5963); inImage.read(headstruct.TextDOBYYYY,4);
  	inImage.seekg(5992); inImage.read(headstruct.TextStudyNumberFlag2,3);
  	inImage.seekg(5996); inImage.read(headstruct.TextImageNumberFlag2,3);
  	inImage.seekg(5999); inImage.read(headstruct.TextStudyNumber2,3); //not 2
  	inImage.seekg(6003); inImage.read(headstruct.TextImageNumber2,4); //not 6002,2
  	inImage.seekg(6011); inImage.read(headstruct.TextStudyImageNumber3,8); //not 6013,5
  	inImage.seekg(6031); inImage.read(headstruct.TextModelName,15);
  	inImage.seekg(6058); inImage.read(headstruct.TextPatientName,25);
  	inImage.seekg(6085); inImage.read(headstruct.TextScanStartTimeHH,2);
  	inImage.seekg(6088); inImage.read(headstruct.TextScanStartTimeMM,2);
  	inImage.seekg(6091); inImage.read(headstruct.TextScanStartTimeSS,2);
  	inImage.close();

*/













