/*
 * s51dude - A Downloader/Uploader for 8051 device programmers
 * Copyright (C) 2008 Lucas Chiesa.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef	_parts_h_
#define	_parts_h_

#define			AT89S8253_text	"s8253"
#define			AT89S53_text	"s53"
#define			AT89S8252_text	"s8252"
#define			AT89S52_text	"s52"

//Enable program codes
#define 		AT89S8252_enable_code_b0		0x00
#define 		AT89S8252_enable_code_b1		0xAC
#define 		AT89S8252_enable_code_b2		0x53
#define 		AT89S8252_enable_code_b3		0x00

#define 		AT89S8253_enable_code_b0		0xAC
#define 		AT89S8253_enable_code_b1		0x53
#define 		AT89S8253_enable_code_b2		0x00
#define 		AT89S8253_enable_code_b3		0x00

#define 		AT89S52_enable_code_b0			0xAC
#define 		AT89S52_enable_code_b1			0x53
#define 		AT89S52_enable_code_b2			0x00
#define 		AT89S52_enable_code_b3			0x00

#define 		AT89S53_enable_code_b0			0x00
#define 		AT89S53_enable_code_b1			0xAC
#define 		AT89S53_enable_code_b2			0x53
#define 		AT89S53_enable_code_b3			0x00

//Erase codes
#define 		AT89S8252_erase_code_b0			0x00
#define 		AT89S8252_erase_code_b1			0xAC
#define 		AT89S8252_erase_code_b2			0x04
#define 		AT89S8252_erase_code_b3			0x00

#define 		AT89S8253_erase_code_b0			0xAC
#define 		AT89S8253_erase_code_b1			0x80
#define 		AT89S8253_erase_code_b2			0x00
#define 		AT89S8253_erase_code_b3			0x00

#define 		AT89S52_erase_code_b0			0xAC
#define 		AT89S52_erase_code_b1			0x80
#define 		AT89S52_erase_code_b2			0x00
#define 		AT89S52_erase_code_b3			0x00

#define 		AT89S53_erase_code_b0			0x00
#define 		AT89S53_erase_code_b1			0xAC
#define 		AT89S53_erase_code_b2			0x04
#define 		AT89S53_erase_code_b3			0x00

#define			AT89S8253_max_mem	12288 //12k
#define			AT89S53_max_mem		12288 //12k
#define			AT89S8252_max_mem	8192  //8k
#define			AT89S52_max_mem		8192  //8k

// Verificar los codigos de programacion!
#define			AT89S8253_write_flash	0x40
#define			AT89S53_write_flash		0x02
#define			AT89S8252_write_flash	0x02
#define			AT89S52_write_flash		0x40

#define			AT89S8253_read_flash	0x20
#define			AT89S53_read_flash		0x01
#define			AT89S8252_read_flash	0x01
#define			AT89S52_read_flash		0x20

#define			AT89S8253_write_eeprom	0x40
#define			AT89S53_write_eeprom	0x20
#define			AT89S8252_write_eeprom	0x20
#define			AT89S52_write_eeprom	0x20

#define			AT89S8253_read_eeprom	0x20
#define			AT89S53_read_eeprom		0x20
#define			AT89S8252_read_eeprom	0x20
#define			AT89S52_read_eeprom		0x20

//Tiempos de Delay
#define 		AT89S8252_delay			6000
#define 		AT89S8253_delay			6000
#define 		AT89S52_delay			1000
#define 		AT89S53_delay			1000

#define			TAMANIO_MASK		0x07
#define			TAMANIO_AVR			0x04
#define			TAMANIO_8253		0x04
#define			TAMANIO_8252		0x03

#define			MICRO_S51_MASK		0x38
#define			MICRO_AVR			0x00
#define			MICRO_8253			0x08
#define			MICRO_8252			0x10

#define			INVERTED_SCK_MASK	0x40
#define			AVR_SCK				0x00

#define			CONFIGURE_MSG		15

#endif
