/* $Copyright: $
 * Copyright (c) 1995 - 2001 by Steve Baker (ice@mama.indstate.edu)
 * All Rights reserved
 *
 * This software is provided as is without any express or implied
 * warranties, including, without limitation, the implied warranties
 * of merchant-ability and fitness for a particular purpose.
 */

#include <sys/types.h>
#include <sys/time.h>
#include <time.h>
#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <dirent.h>
#include <errno.h>
#include <sys/wait.h>

#include "utmp.h"

#define scopy(s)	(strcpy(bmalloc(strlen(s)+1),s))
#define min(a,b)	((a) < (b) ? (a) : (b))
#define max(a,b)	((a) > (b) ? (a) : (b))

/* This will break if someone has an 89 year old wtmp  =) */
#define MINUSZERO	-32767		/* HACK ALERT!! */
#define PLUSZERO	+32767		/* HACK ALERT!! */

#define BUFSIZE		1024

enum {
  TOTAL	  = 0x0001,	/* Total login time */
  DAY     = 0x0002,	/* Daily average */
  USER    = 0x0003,	/* Per user login time */
  TTY     = 0x0004,	/* Show usage / tty */
  RAW	  = 0x0005,	/* Show everything */
  SIMUSE  = 0x0006,	/* Simultaneous tty usage */

  AVERAGE = 0x0010,	/* Average login time / login */
  HOUR    = 0x0020,	/* Hourly profile */
  CLIP	  = 0x0040,	/* Multiple logins during same time count only once */
  MINMAX  = 0x0080,	/* Show min max # logins at one time */
  LOGIN	  = 0x0100,	/* Display login breakdown */
  IPACCT  = 0x0200,	/* Display IP accounting/data rate info */
  CALLID  = 0x0400,	/* Display caller ID accounting */
  IGNORE  = 0x0800	/* Ignore X amount of usage before starting accounting */
};

/* Time formats */
enum {
  FRAC	  = 0x00,	/* default: %10.2f hours */
  HMS	  = 0x01,
  HM	  = 0x02,
  HOURS	  = 0x03,
  SECONDS = 0x04,
  ROUND	  = 0x40,
};

#ifndef TRUE
enum { FALSE=0, TRUE=1 };
#endif

enum { USERLIST, EXCLUDELIST, TTYLIST, HOSTLIST, PORTMASTERLIST, LOGFILELIST, FILELIST };

struct day {
  time_t start, stop;
  short day, wday, month, year, minlogins, maxlogins;
  time_t time;
  time_t h[24];
  double inoct, outoct;
  double inpkt, outpkt;
  u_long datarate;
  struct login *login, *lastlogin;
  u_long logins;
  struct usr *us;
  struct tty *tty;
  struct simuse *simuse;
  struct day *nxt;
};

/*
 * Keep a pointer at the end of the days list, since we'll usually be
 * adding crap to it, not to days before.  What 'o what do we do about
 * time changes aka time warps?
 */

struct usr {
  char user[UT_NAMESIZE+1];
  short loggedin, minlogins, maxlogins;
  time_t time;
  time_t ignore;
  time_t h[24];
  double inoct, outoct;
  double inpkt, outpkt;
  u_long datarate;
  struct login *login, *lastlogin;
  u_long logins, xlogins;
  struct usr *nxt;
};

struct tty {
  char line[UT_LINESIZE+1];
  time_t time, h[24];
  double inoct, outoct;
  double inpkt, outpkt;
  u_long datarate;
  struct login *login, *lastlogin;
  u_long logins, xlogins;
  struct tty *nxt;
};

/* simultaneous usage time */
struct simuse {
  short index;
  time_t time;
  long count;
  time_t h[24];
  struct login *login, *lastlogin;
  struct simuse *nxt;
};

/* excluded users list */
struct exc {
  char user[UT_NAMESIZE+1];
  struct exc *nxt;
};

/* ttys list */
struct ttys {
  char *line;
  char ispat;		/* Is tty a pattern?	*/
  struct ttys *nxt;
};

/* hosts list */
struct hosts {
  char *host;
  char ispat;		/* Is host a pattern?	*/
  char len,ss;		/* Is host a substring?	*/
  struct hosts *nxt;
};

struct user {
  char user[UT_NAMESIZE+1];
  char line[UT_LINESIZE+1];
  char host[UT_HOSTSIZE+1];
  time_t in;
  struct user *nxt;
};

enum filetype {
  ACCT_WTMP,			/* Good old linux (sysv) extended utmp format */
  ACCT_ANCIENT,			/* Bad old BSD style utmp with no ut_type field. */
  ACCT_TACACS3,			/* same as above (old BSD style) */
  ACCT_TACACS4,			/* Bizarre utmp w/ ut_comment field. (no ut_type) */
  ACCT_RADIUS,			/* sucky detail file support */
  ACCT_RADIUS_LOGFILE		/* probably won't support this. */
};

struct file {
  char *file;
  char ftype;
  void (*gronk)();
  struct file *nxt;
};

struct login {
  time_t start, stop;
  char *name;
  char *tty;
  char *host;
  struct login *nxt;
};

#include "proto.h"

/* Globals */

#ifdef MAIN
#  define EXTERN
#  define INIT(x) = x
#else
#  define EXTERN extern
#  define INIT(x)
#endif

EXTERN struct day *days INIT(NULL), *end INIT(NULL);
EXTERN struct usr *us INIT(NULL);
EXTERN struct ttys *tty INIT(NULL);
EXTERN struct exc *ex INIT(NULL);
EXTERN struct simuse *simuse INIT(NULL);
EXTERN struct tty *ttys INIT(NULL);
EXTERN struct hosts *hosts INIT(NULL);
EXTERN struct user *usr INIT(NULL);

#ifdef MAIN
  char *month[13] = {
    "Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec", NULL
  };
  char *dayabbr[8] = {"Sun","Mon","Tue","Wed","Thr","Fri","Sat",NULL};
#else
  extern char *month[13], *dayaddbr[8];
#endif

EXTERN char fix INIT(FALSE), exclude INIT(FALSE), fixtty INIT(FALSE), fixhost INIT(FALSE), radhost INIT(FALSE);
EXTERN char hosttoo INIT(FALSE), verbose INIT(FALSE), longdate INIT(FALSE);
EXTERN char *back INIT(NULL), *ignore INIT(NULL), timefmt INIT(FRAC);
EXTERN u_short type INIT(TOTAL);
EXTERN time_t total INIT(0), sd INIT(0), ed INIT(0), backtime INIT(0), curtime INIT(0);
EXTERN time_t lastent INIT(0), ignoretime INIT(0), cutoff INIT(0), discard INIT(0);
EXTERN int ndays INIT(0), logins INIT(0), loggedin INIT(0), minlogins INIT(-1), maxlogins INIT(0);
EXTERN signed int sm INIT(0), em INIT(0);
EXTERN u_long hourmask INIT(0);
EXTERN char *usespec;

/* Simultaneous usage globals */
EXTERN int simdex INIT(0);
EXTERN time_t simtime INIT(0);

EXTERN char buf[BUFSIZE+1];

/*
char *month[] = {
  "Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec", NULL
};
char *dayabbr[] = {"Sun","Mon","Tue","Wed","Thr","Fri","Sat",NULL };

char fix = FALSE, exclude = FALSE, fixtty = FALSE, fixhost = FALSE, radhost = FALSE;
char hosttoo = FALSE, verbose = FALSE, longdate = FALSE;
char *back = NULL, *ignore = NULL, timefmt = FRAC;
u_short type = TOTAL;
time_t total = 0, sd = 0, ed = 0, backtime = 0, curtime = 0;
time_t lastent = 0, ignoretime = 0, cutoff = 0, discard = 0;
int ndays = 0, logins = 0, loggedin = 0, minlogins = -1, maxlogins = 0;
signed int sm = 0, em = 0;
u_long hourmask = 0;
char *usespec;

int simdex = 0;
time_t simtime = 0;

char buf[BUFSIZE+1];
*/
