# Samizdat HTML helpers for Resource components
#
#   Copyright (c) 2002-2007  Dmitry Borodaenko <angdraug@debian.org>
#
#   This program is free software.
#   You can distribute/modify this program under the terms of
#   the GNU General Public License version 2 or later.
#
# vim: et sw=2 sts=2 ts=8 tw=0

require 'samizdat/helpers/application_helper'

module ResourceHelper
  include ApplicationHelper

  # wrap focus name and rating in <span> tags
  #
  def focus_info(related, focus)
    return nil if focus.id == related   # never relate resource to itself
    info = focus.name
    id = Resource.validate_id(focus.id)

    info = resource_href(id, info) if id
    info << ': ' << focus.print_rating
    info << ' (<a title="' << _('Click to vote on how this resource is related to this focus') <<
      '" href="resource/' << related.to_s << '/vote' <<
      '?focus=' << CGI.escape((focus.id or focus.uriref).to_s) <<
      '">' << _('vote') <<
      '</a>)' if @request.access('vote')

    '<p>' + info + "</p>\n"
  end

  # list supplied focuses using focus_info
  #
  def focus_box(related, focuses)
    return '' unless focuses.kind_of? Array and
      (focuses.size > 0 or @request.access('vote'))
    fbox = box( _('Related Focuses'),
      focuses.sort_by {|f| -f.sort_index }.collect {|focus|
        focus_info(related, focus)
      }.join,
      'focuses'
    )
    if @request.access('vote')
      fbox << box(nil,
        '<p><a class="action" title="' <<
        _('Click to relate this resource to another focus') <<
        %{" href="resource/#{related}/vote">} <<
        _('Add another focus') <<
        '</a></p>')
    end
    fbox
  end
end
