/*
 * Copyright 1996 Thierry Bousch
 * Licensed under the Gnu Public License, Version 2
 *
 * $Id: saml-util.h,v 1.3 1996/05/01 09:34:27 bousch Exp $
 *
 * Various utility routines
 */

#ifndef _SAML_UTIL_H
#define _SAML_UTIL_H

#include <stddef.h>
#ifdef __linux__
#include <asm/types.h>
#else
typedef unsigned char      __u8;
typedef unsigned short     __u16;
typedef unsigned int       __u32;
#ifdef __alpha__
typedef unsigned long      __u64;
#else
typedef unsigned long long __u64;
#endif
#endif

/* Growable strings */

typedef struct _growable_string {
	size_t	buflen;
	size_t	len;
	char	s[0];
} gr_string;

gr_string* new_gr_string (size_t initial_length);
gr_string* grs_append (gr_string* dest, const char* src, size_t len);
gr_string* grs_prepend (gr_string* dest, const char* src, size_t len);
gr_string* grs_append1 (gr_string* dest, char c);
gr_string* grs_prepend1 (gr_string* dest, char c);

/* Panics */

#define EXITING __attribute__((noreturn))
void saml_panic(const char *message) EXITING;
void panic_out_of_memory(void) EXITING;

/* Miscillaneous */

char *u32toa (__u32);
char *u64toa (__u64);

#endif
