#!/usr/local/bin/python
#
# Computes 1 + 1/2 + 1/3 + ... +1/2000
#

from saml1 import *
import string

def test1(loops):
  s = Mathnode(ST_RATIONAL, '0')
  n = s
  for i in xrange(loops):
    n = n + n.one()
    s = s + n.invert()
  print 'H(%d) == %s' % (loops,s)

# Pretty straightworward, isn't it ?
# Now compare with this:

def test2(loops):
  expr = string.join(map(lambda x:'1/%d'%x, range(1,loops+1)),'+')
  s = Mathnode(ST_RATIONAL,'0').parse(expr)
  print 'H(%d) == %s' % (loops,s)

# Main

if __name__ == '__main__':
  test1(2000)
  print MnAllocStats()
