/* locate.c - locate various files
 *
 * Copyright (C) 2000  Jochen Voss.  */

static const  char  rcsid[] = "$Id: locate.c,v 1.1 2000/01/27 20:00:11 voss Rel $";

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <gnome.h>

#include "locate.h"


char *
get_pixmap_file (const char *name)
/* Return the newly allocated name of an existing pixmap file.  */
{
  char *fil, *part;

  fil = g_concat_dir_and_file ("pixmaps", name);
  if (g_file_exists (fil))  return fil;
  g_free (fil);

  fil = g_concat_dir_and_file ("../pixmaps", name);
  if (g_file_exists (fil))  return fil;
  g_free (fil);

#ifdef PIXMAP_DIR
  fil = g_concat_dir_and_file (PIXMAP_DIR, name);
  if (g_file_exists (fil))  return fil;
  g_free (fil);
#endif
  
  part = g_concat_dir_and_file ("sanduhr", name);
  fil = gnome_pixmap_file (part);
  g_free (part);

  return  fil;
}

char *
get_sound_dir (void)
/* Return the directory, where SandUhr stores its audio files.  */
{
#ifdef SOUND_DIR
  return  g_strdup (SOUND_DIR);
#endif

  if (g_file_exists ("sounds"))  return g_strdup ("sounds");
  if (g_file_exists ("../sounds"))  return g_strdup ("../sounds");
  return g_strdup (".");
}
