#  Copyright (C) 1999-2004
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

proc ButtonExamine {which x y} {
    global current
    global ds9
    global examine
    global slave
    global master

    if {![$which has fits]} {
	return
    }

    # set default channel
    if {[$which get type] == "rgb"} {
	$which rgb channel red
    }

    # find coordinates
    if {[$which has bin]} {
	set coord [$which get coordinates canvas $x $y physical]
    } else {
	set coord [$which get coordinates canvas $x $y image]
    }

    # go to tile mode in case
    set ds9(display,user) tile
    DisplayMode

    switch -- $examine(mode) {
	new {
	    CreateNamedFrame FrameEx [$which get type]
	    set f $current(frame)
	}
	one {
	    if {[info exists examine(one)]} {
		if {$which == $examine(one)} {
		    # do nothing, we clicked in the examine frame
		    return
		}
		set f $examine(one)
		$f clear
	    } else {
		CreateNamedFrame FrameEx [$which get type]
		set examine(one) $current(frame)
		set f $examine(one)
	    }
	}
    }

    if {[$which get type] == "rgb"} {
	# load image
	if {[$which has fits cube]} {
	    $f load fits rgb cube slave [$which get fits master]
	} else {
	    foreach c {red green blue} {
		$which rgb channel $c
		$f rgb channel $c

		set m [$which get fits master]
		if {[string length $m] != 0} {
		    set fn [lindex $m 0]
		    set ptr [lindex $m 1]
		    $f load fits slave "\{$fn\}" $ptr
		}
	    }
	}

	# set scale/bin parameters
	foreach c {red green blue} {
	    $which rgb channel $c
	    $f rgb channel $c

	    $f colorscale [$which get colorscale]

	    $f clip scope [$which get clip scope]
	    $f clip mode [$which get clip mode]
	    $f clip user [$which get clip]

	    $f clip minmax mode [$which get clip minmax mode]
	    $f clip minmax sample [$which get clip minmax sample]

	    if {[$which has bin]} {
		$f bin function [$which get bin function]
		$f bin factor to "[$which get bin factor]"
		$f bin depth [$which get bin depth]
		$f bin buffer size [$which get bin buffer size]
	    }
	}

	$which rgb channel red
	$f rgb channel red
    } else {
	$f load fits slave [$which get fits master]
	if {[$which has bin]} {
	    $f bin function [$which get bin function]
	    $f bin factor to "[$which get bin factor]"
	    $f bin depth [$which get bin depth]
	    $f bin buffer size [$which get bin buffer size]
	}
    }

    lappend slave($which) $f
    lappend master($f) $which

    $f zoom to [$which get zoom]
    $f orient [$which get orient]
    $f rotate to [$which get rotate]
    $f wcs align [$which get wcs align]

    RealizeDS9

    # zoom to about
    if {[$which has bin]} {
	if {[$which get type] == "rgb"} {
	    foreach c {red green blue} {
		$f rgb channel $c
		set bf "[$f get bin factor]"
		set bx [expr [lindex $bf 0]/$examine(zoom)]
		set by [expr [lindex $bf 1]/$examine(zoom)]
		$f bin factor to $bn $by about \
		    [lindex $coord 0] [lindex $coord 1]
	    }
	    $f rgb channel red
	} else {
	    set bf "[$f get bin factor]"
	    set bx [expr [lindex $bf 0]/$examine(zoom)]
	    set by [expr [lindex $bf 1]/$examine(zoom)]
	    $f bin factor to $bx $by about [lindex $coord 0] [lindex $coord 1]
	}
    } else {
	$f zoom $examine(zoom) about image [lindex $coord 0] [lindex $coord 1]
    }

    set ds9(next) $which
    GotoFrame
    $which magnifier on
}

proc DeleteExamine {which} {
    global master
    global slave
    global examine

    # check to see if it has any slaves
    if {[info exists slave($which)]} {
	foreach f $slave($which) {
	    DeleteSingleFrame $f
	}
	unset slave($which)
    }

    # cleck to see if it has any masters
    if {[info exists master($which)]} {
	set m $master($which)
	if {[info exists slave($m)]} {
	    set i [lsearch $slave($m) $which]
	    set slave($m) [lreplace $slave($m) $i $i]
	}
	unset master($which)
    }

    # check to see if its an examine(one) frame
    if {[info exists examine(one)]} {
	if {$which == $examine(one)} {
	    unset examine(one)
	}
    }
}
