#  Copyright (C) 1999-2004
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

proc HVFormCB {tt n cmd args} {
    global hv
    global debug

    # for some reason, we will receive a 'cancel', so ignore hv($tt,active)
    #  if {!$hv($tt,active)} {
    #  return
    #  }

    if {$debug(tcl,hv)} {
	puts "HVFormCB $tt $n $cmd $args"
    }

    switch -- [string tolower $cmd] {
	form {HVFormForm $tt $n args}
	flush {HVFormFlush $tt $n args}
	input {HVFormInput $tt $n args}
	select {HVFormSelect $tt $n args}
	textarea {HVFormTextArea $tt $n args}
    }
}

proc HVFormForm {tt n a} {
    upvar $a args
    global hv
    global debug

    if {$debug(tcl,hv)} {
	puts "HVFormForm $n $args"
    }

    # try to clean up lose vars from previous forms
    HVFormFlush $tt $n {}

    set aa [lindex $args 2]
    set hv($tt,form,$n,action) [lindex $args 0]
    set hv($tt,form,$n,method) [HVattrs method $aa get]

    if {$debug(tcl,hv)} {
	puts "HVFormForm method $hv($tt,form,$n,method)"
	puts "HVFormForm action $hv($tt,form,$n,action)"
    }
}

proc HVFormFlush {tt n a} {
    upvar $a args
    global hv
    global debug
    
    if {$debug(tcl,hv)} {
	puts "HVFormFlush $n"
    }

    # try to unset all hv($tt,*,$n,*)
    # this does not work for all -textvariable fields, unless window destroyed
    # becareful not to unset hv($tt,index,*)!
    foreach x [array names hv] {
	set f [split $x ,]
	if {[lindex $f 0] == $tt && 
	    [lindex $f 1] != "index" &&
	    [lindex $f 2] == $n} {
	    unset hv($x)
	}
    }
}

proc HVFormInput {tt n a} {
    upvar $a args
    global hv
    global debug

    set path [lindex $args 0]
    set attrs [lindex $args 1]
    if {$debug(tcl,hv)} {
	puts "HVFormInput $n $path $attrs"
    }

    set id [lindex [split $path .] end]
    set type [HVattrs type $attrs {}]
    set disabled [HVattrs disabled $attrs normal]
    set readonly [HVattrs readonly $attrs normal]

    switch -- [string tolower $type] {
	checkbox {
	    set name [HVattrs name $attrs var]
	    set value [HVattrs value $attrs on]
	    set checked [HVattrs checked $attrs nochecked]

	    set hv($tt,name,$n,$id) $name
	    if {$checked != "nochecked"} {
		set hv($tt,var,$n,$id) $value
	    } else {
		set hv($tt,var,$n,$id) {}
	    }
	    set hv($tt,init,$n,$id) $$hv($tt,var,$n,$id)

	    checkbutton $path -variable hv($tt,var,$n,$id) \
		-onvalue $value -offvalue {} -state $disabled -bg white
	}
	radio {
	    set name [HVattrs name $attrs var]
	    # we need this so that all share the same variable
	    set id $name
	    set value [HVattrs value $attrs on]
	    set checked [HVattrs checked $attrs nochecked]

	    set hv($tt,name,$n,$id) $name
	    if {$checked != "nochecked"} {
		set hv($tt,var,$n,$id) $value
		set hv($tt,init,$n,$id) $hv($tt,var,$n,$id)
	    }

	    # override init value
	    foreach f $hv($tt,init) {
		if {$n == [lindex $f 0] && 
		    $name == [lindex $f 1] &&
		    $value == [lindex $f 2]} {

		    set hv($tt,var,$n,$id) $value
		    set hv($tt,init,$n,$id) $hv($tt,var,$n,$id)
		}
	    }

	    radiobutton $path -variable hv($tt,var,$n,$id) \
		-value $value -state $disabled -bg white
	}
	submit {
	    set name [HVattrs name $attrs submit]
	    set value [HVattrs value $attrs "Submit"]

	    button $path -text $value \
		-command "HVSubmit $tt $n \{$name\} \{$value\}"
	}
	reset {
	    set name [HVattrs name $attrs reset]
	    set value [HVattrs value $attrs "Reset"]

	    button $path -text $value -command "HVReset $tt $n"
	}
	image {
	    set name [HVattrs name $attrs submit]
	    set value [HVattrs value $attrs "Submit"]
	    set src [HVattrs src $attrs {}]

	    set img [HVImageCB $tt [$hv($tt,widget) resolve $src]]
	    if {$img != "biggray"} {
		button $path -image $img \
		    -command "HVSubmit $tt $n \{$name\} \{$value\}"
	    } else {
		button $path -text $value -state $disabled \
		    -command "HVSubmit $tt $n \{$name\} \{$value\}"
	    }
	    return
	}
	hidden {
	    set name [HVattrs name $attrs var]
	    set value [HVattrs value $attrs {}]

	    set hv($tt,name,$n,$id) $name
	    set hv($tt,var,$n,$id) $value
	}
	password {
	    set name [HVattrs name $attrs var]
	    set value [HVattrs value $attrs {}]
	    set size [HVattrs size $attrs 20]

	    set hv($tt,name,$n,$id) $name
	    set hv($tt,var,$n,$id) $value
	    set hv($tt,init,$n,$id) $hv($tt,var,$n,$id)

	    entry $path -textvariable hv($tt,var,$n,$id) \
		-width $size -show "*" -state $readonly
	}
	file {
	    set name [HVattrs name $attrs var]
	    set value [HVattrs value $attrs {}]
	    set size [HVattrs size $attrs 20]

	    set hv($tt,name,$n,$id) $name
	    set hv($tt,var,$n,$id) [HVInitVar $tt $n $name $value]
	    set hv($tt,init,$n,$id) $hv($tt,var,$n,$id)

	    entry $path -textvariable hv($tt,var,$n,$id) \
		-width $size -state $readonly
	}
	text -
	default {
	    set name [HVattrs name $attrs var]
	    set value [HVattrs value $attrs {}]
	    set size [HVattrs size $attrs 20]

	    set hv($tt,name,$n,$id) $name
	    set hv($tt,var,$n,$id) [HVInitVar $tt $n $name $value]
	    set hv($tt,init,$n,$id) $hv($tt,var,$n,$id)

	    entry $path -textvariable hv($tt,var,$n,$id) \
		-width $size -state $readonly
	}
    }
}

proc HVFormSelect {tt n a} {
    upvar $a args
    global hv
    global debug

    set path [lindex $args 0]
    set attrs [lindex $args 1]
    set choices [lindex $args 2]
    set initial [lindex $args 3]
    if {$debug(tcl,hv)} {
	puts "HVFormSelect $n $path $attrs $choices $initial"
    }

    set id [lindex [split $path .] end]
    set name [HVattrs name $attrs var]

    set size [HVattrs size $attrs 0]
    set multiple [HVattrs multiple $attrs single]
    if {[string length $multiple] == 0} {
	set multiple multiple
    }

    switch -- $multiple {
	single {
	    set hv($tt,name,$n,$id) $name

	    menubutton $path -textvariable hv($tt,single,$n,$id) \
		-menu $path.m -relief raised -bd 2 
	    menu $path.m -tearoff 0

	    set l 0
	    set first 1
	    foreach f $choices {
		set i [lindex $f 0]
		set v [lindex $f 1]
		set m [lindex $f 2]
		if {[string length $v] == 0} {
		    set v $m
		}

		if {$i || $first} {
		    set hv($tt,var,$n,$id) $v
		    set hv($tt,init,$n,$id) $v
		    set hv($tt,single,$n,$id) $m
		    set hv($tt,singleinit,$n,$id) $m
		    set first 0
		}
		
		if {[string length $m]>$l} {
		    set l [string length $m]
		}
		$path.m add command -label $m -command \
		    "global hv; set hv($tt,var,$n,$id) \"$v\"; set hv($tt,single,$n,$id) \"$m\""
	    }

	    # override init value
	    foreach f $hv($tt,init) {
		if {$n == [lindex $f 0] && $name == [lindex $f 1]} {
		    set v [lindex $f 2]
		    set m [lindex $f 3]

		    set hv($tt,var,$n,$id) $v
		    set hv($tt,init,$n,$id) $v
		    set hv($tt,single,$n,$id) $m
		    set hv($tt,singleinit,$n,$id) $m
		}
	    }

	    $path configure -width $l
	}
	multiple {
	    set hv($tt,name,$n,$id) $name
	    set hv($tt,multivar,$n,$id) {}
	    set hv($tt,multiinit,$n,$id) {}
	    set hv($tt,multimenu,$n,$id) {}

	    set l 0
	    set long {}
	    set ii 0
	    foreach f $choices {
		if [lindex $f 0] {
		    lappend hv($tt,multiinit,$n,$id) $ii
		}
		set foo [lindex $f 1]
		if {[string length $foo] == 0} {
		    set foo [lindex $f 2]
		}
		lappend hv($tt,multivar,$n,$id) $foo
		lappend hv($tt,multimenu,$n,$id) [lindex $f 2]

		set m [lindex $f 2]
		if {[string length $m]>$l} {
		    set long $m
		    set l [string length $m]
		}
		incr ii
	    }
	    set hv($tt,multiple,$n,$id) $path

	    # we have a problem
	    # the frame we create will not resize itself based on the
	    # interior size of the listbox and the scrollbar
	    # so, we need to set the frame size by hand

	    set font {Helvetica 10}
#	    set font {Helvetica 12}
	    frame $path
	    scrollbar $path.scroll -command "$path.list yview" \
		-width 10
	    listbox $path.list -selectmode multiple \
		-width 0 -height $size \
		-listvar hv($tt,multimenu,$n,$id) \
		-font $font \
		-yscroll "$path.scroll set" \
		-exportselection false

	    set w [expr [font measure $font $long]+30]
	    set h [expr $size*[font metrics $font -linespace]]
	    $path configure -width $w -height $h

	    pack $path.list $path.scroll -side left -fill y -expand 1

	    foreach ii $hv($tt,multiinit,$n,$id) {
		$path.list selection set $ii
	    }
	}
    }
}

proc HVFormTextArea {tt n a} {
    upvar $a args
    global hv
    global debug

    set path [lindex $args 0]
    set attrs [lindex $args 1]
    set initial [string range [lindex $args 2] 1 end]
    
    if {$debug(tcl,hv)} {
	puts "HVFormTextArea $n $path $attrs $initial"
    }

    set id [lindex [split $path .] end]
    set name [HVattrs name $attrs var]

    set rows [HVattrs rows $attrs 4]
    set cols [HVattrs cols $attrs 20]
    set readonly [HVattrs disabled $attrs normal]

    # update initial
    set initial [HVInitVar $tt $n $name $initial]

    text $path -height $rows -width $cols -wrap none -state $readonly
    $path insert end $initial

    set hv($tt,name,$n,$id) $name
    set hv($tt,var,$n,$id) $initial
    set hv($tt,init,$n,$id) $hv($tt,var,$n,$id)
    set hv($tt,textarea,$n,$id) $path
}

proc HVattrs {k l def} {
    # break list up into key/value pairs
    set key {}
    set value {}
    set w 1
    foreach f $l {
	if {$w} {
	    lappend key [string tolower $f]
	    set w 0
	} else {
	    lappend value $f
	    set w 1
	}
    }
    set a [lsearch -exact $key [string tolower $k]]
    if {$a>=0} {
	return [lindex $value $a]
    } else {
	return $def
    }
}

proc HVSubmit {tt n name value} {
    global hv
    global http
    global debug

    if {$debug(tcl,hv)} {
	puts "HVSubmit $n"
    }

    # update textareas
    foreach x [array names hv] {
	set f [split $x ,]
	if {[lindex $f 0] == $tt && 
	    [lindex $f 1] == "textarea" && 
	    [lindex $f 2] == $n} {
	    set id [lindex $f 3]
	    set path $hv($x)
	    set hv($tt,var,$n,$id) [$path get 1.0 end]
	}
    }

    set query {}
    # append button name=value
    append query "[http::formatQuery $name]=[http::formatQuery $value]&"

    # append normal vars
    foreach x [array names hv] {
	set f [split $x ,]
	if {[lindex $f 0] == $tt && 
	    [lindex $f 1] == "var" && 
	    [lindex $f 2] == $n} {
	    set id [lindex $f 3]
	    set var [string trim $hv($tt,var,$n,$id)]
	    if {[string length $var] != 0} {
		append query "[http::formatQuery $hv($tt,name,$n,$id)]=[http::formatQuery $var]&"
	    }
	}
    }

    # append multiple select
    foreach x [array names hv] {
	set f [split $x ,]
	if {[lindex $f 0] == $tt && 
	    [lindex $f 1] == "multiple" && 
	    [lindex $f 2] == $n} {
	    set id [lindex $f 3]
	    set path $hv($x)
	    set iii [$path.list curselection]
	    foreach ii $iii {
		set v [string trim [lindex $hv($tt,multivar,$n,$id) $ii]]
		if {[string length $v] != 0} {
		    append query "[http::formatQuery $hv($tt,name,$n,$id)]=[http::formatQuery $v]&"
		}
	    }
	}
    }

    # remove last '&'
    set query [string trimright $query &]

    HVClearIndex $tt $hv($tt,index)

    # clear previous
    set hv($tt,previous) {}

    # and do it
    # already resolved
    switch -- [string tolower $hv($tt,form,$n,method)] {
	get {HVLoadURL $tt "$hv($tt,form,$n,action)?$query" {}}
	post {HVLoadURL $tt "$hv($tt,form,$n,action)" "$query"}
    }
}

proc HVReset {tt n} {
    global hv
    global http
    global debug

    if {$debug(tcl,hv)} {
	puts "HVReset $n"
    }

    foreach x [array names hv] {
	set f [split $x ,]
	if {[lindex $f 0] == $tt && 
	    [lindex $f 1] == "init" &&
	    [lindex $f 2] == $n} {
	    set hv($tt,var,$n,[lindex $f 3]) $hv($x)
	}
    }

    #update single select
    foreach x [array names hv] {
	set f [split $x ,]
	if {[lindex $f 0] == $tt && 
	    [lindex $f 1] == "singleinit" && 
	    [lindex $f 2] == $n} {
	    set id [lindex $f 3]
	    set hv($tt,single,$n,$id) $hv($x)
	}
    }

    # update multiple select
    foreach x [array names hv] {
	set f [split $x ,]
	if {[lindex $f 0] == $tt && 
	    [lindex $f 1] == "multiinit" && 
	    [lindex $f 2] == $n} {
	    set id [lindex $f 3]
	    set path $hv($tt,multiple,$n,$id)
	    $path.list selection clear 0
	    foreach ii $hv($x) {
		$path.list selection set $ii
	    }
	}
    }

    # update textareas
    foreach x [array names hv] {
	set f [split $x ,]
	if {[lindex $f 0] == $tt && 
	    [lindex $f 1] == "textarea" && 
	    [lindex $f 2] == $n} {
	    set id [lindex $f 3]
	    set path $hv($x)

	    $path delete 1.0 end
	    $path insert end $hv($tt,init,$n,$id)
	}
    }
}

proc HVInitVar {tt n name def} {
    global hv

    foreach f $hv($tt,init) {
	if {$n == [lindex $f 0] && $name == [lindex $f 1]} {
	    return [lindex $f 2]
	}
    }
    return $def
}

proc HVFixHTMLForm {tt} {
    global hv
    global debug

    if [regexp -nocase {<form [^>]*} $hv($tt,html) r] {
	if {![regexp -nocase {action=} $r]} {
	    if {$debug(tcl,hv)} {
	    puts "HVFixFormHTML action fixed"
	    }
	    
	    set rr "$r action=[$hv($tt,widget) cget -base]"
	    regsub -nocase {<form [^>]*} $hv($tt,html) $rr hv($tt,html)
	}
    }
}
