// Copyright (C) 1999-2004
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __colorbar_h__
#define __colorbar_h__

#include "colorbarbase.h"
#include "colormap.h"
#include "itt.h"

// Colormap(s) are X window Colormap ID's. ColorMapInfo(s) contain a fixed 
// number of real RGB color cells. RGB Values of ColorMapInfo(s) are 
// never altered. Colormap(s) are initialized from ColorMapInfo values. 
// Colormap RGB values will changed, based on user input.
// ITTs (Intensity Transfer Table) are used by RTD based colormaps only.

class Colorbar : public ColorbarBase {
 protected:
  unsigned short* colorIndex;
  ColorMapInfo* cmaps;
  ColorMapInfo* currentcmap;
  ITT* itts;
  ITT* currentitt;

  float bias;
  float contrast;
  int invert;

 private:
  ITT* newITT(const char*);
  ColorMapInfo* newColorMap(const char*, const char*);

 protected:
  void loadDefaultCMaps();
  void reset();
  int calcContrastBias(int);

 public:
  Colorbar(Tcl_Interp*, Tk_Canvas, Tk_Item*);
  virtual ~Colorbar();

  // commands

  void adjustCmd(float, float);
  void getBiasCmd();
  void getColormapCmd();
  void getColormapNameCmd(int);
  void getContrastCmd();
  void getCurrentFileNameCmd();
  void getCurrentIDCmd();
  void getCurrentNameCmd();
  void getInvertCmd();
  void invertCmd(int);
  void ittCmd(const char*);
  void ittCmd(int);
  void listIDCmd();
  void listNameCmd();
  void listITTIDCmd();
  void listITTNameCmd();
  void loadCmd(const char*, const char*);
  void loadITTCmd(const char*);
  void mapCmd(char*);
  void mapCmd(int);
  void saveCmd(const char*);
  void setColormapCmd(char*, float, float, int);
  void setColormapCmd(int, float, float, int);
  virtual void setColormapWindowCmd(char*) {}
};

#endif
