// Copyright (C) 1999-2004
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __fitsmap_h__
#define __fitsmap_h__

#include "file.h"

class FitsMap : public FitsFile {
protected:
  char* mapdata_;
  off_t mapsize_;

public:
  FitsMap();
  virtual ~FitsMap() {}

  char* mapdata() {return mapdata_;}
  int mapsize() {return mapsize_;}
  void found(char*);
  void error();
  char* enddata();
  int endsize();
};

class FitsFitsMap : public virtual FitsMap {
protected:
  void processExact();
  void processRelax();

public:
  FitsFitsMap(ScanMode);
};

class FitsFitsNextMap : public FitsMap {
public:
  FitsFitsNextMap(FitsFile* prev);
};

class FitsArrMap : public virtual FitsMap {
public:
  FitsArrMap();
};

class FitsMosaicMap : public virtual FitsMap {
public:
  FitsMosaicMap();
};

class FitsMosaicNextMap : public FitsMap {
public:
  FitsMosaicNextMap(FitsFile* prev);
};

#endif








