/* headwcs.c
 */

#include <xos.h>
#include <xfile.h>
#include "fitsy.h"

int ft_trxlcs(lcs, x0, y0, x1, y1, direction)
	FITSLinWCS	 lcs;
	double		 x0;
	double		 y0;
	double		*x1;
	double		*y1;
	int              direction;
{
    if ( !lcs->has_wcs ) {
	*x1 = x0;
	*y1 = y0;
	return 0;
    }

    if ( direction ) {
        *x1 = x0 * lcs->fwd[0][0] + y0 * lcs->fwd[1][0] + lcs->fwd[2][0];
        *y1 = x0 * lcs->fwd[0][1] + y0 * lcs->fwd[1][1] + lcs->fwd[2][1];
    } else {
        *x1 = x0 * lcs->rev[0][0] + y0 * lcs->rev[1][0] + lcs->rev[2][0];
        *y1 = x0 * lcs->rev[0][1] + y0 * lcs->rev[1][1] + lcs->rev[2][1];
    }

    return 1;
}

int ft_trxsiz(lcs, x0, y0, x1, y1, direction)
	FITSLinWCS	 lcs;
	double		 x0;
	double		 y0;
	double		*x1;
	double		*y1;
	int		direction;
{
    if ( !lcs->has_wcs ) {
	*x1 = x0;
	*y1 = y0;
	return 0;
    }

    if ( direction ) {
        *x1 = x0 * lcs->fwd[0][0];
        *y1 = y0 * lcs->fwd[1][1];
    } else {
        *x1 = x0 * lcs->rev[0][0];
        *y1 = y0 * lcs->rev[1][1];
    }

    return 1;
}

void ft_loglcs(fits, m11, m12, m21, m22, v1, v2)
	FITSHead	fits;
	double		m11, m12, m21, m22;
	double		v1, v2;
{
	if ( m11 != 1.0 ) ft_headsetr(fits, "LTM1_1", 0, m11, 7, NULL, 1);
	if ( m12 != 0.0 ) ft_headsetr(fits, "LTM1_2", 0, m12, 7, NULL, 1);
	if ( m21 != 0.0 ) ft_headsetr(fits, "LTM2_1", 0, m21, 7, NULL, 1);
	if ( m22 != 1.0 ) ft_headsetr(fits, "LTM2_2", 0, m22, 7, NULL, 1);
	if ( v1  != 0.0 ) ft_headsetr(fits, "LTV1"  , 0, v1,  7, NULL, 1);
	if ( v2  != 0.0 ) ft_headsetr(fits, "LTV2"  , 0, v2,  7, NULL, 1);
}
