// Copyright (C) 1999-2004
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __ruler_h__
#define __ruler_h__

#include "marker.h"

class Ruler : public Marker {
private:
  Vector p1;
  Vector p2;
  Vector p3;
  CoordSystem coordSystem;
  SkyFrame skyFrame;
  CoordSystem distSystem;
  SkyFormat distFormat;
  double dist;
  Tk_Font df;

  void render(Drawable, const Matrix&, double, RenderMode);
  void renderDist(Drawable, Vector);
  void psDist(int, Vector);
  int isOn(const Vector&, const Vector&, const Vector&);

public:
  Ruler(const Ruler&);
  Ruler(FrameBase* parent, const Vector& ctr, const Vector& p, 
	CoordSystem, SkyFrame, CoordSystem, SkyFormat,
	const char* clr, int w, const char* f, 
	const char* t, unsigned short prop, const char* c,
	const List<Tag>& tag);
  ~Ruler();

  Marker* dup() {return new Ruler(*this);}
  void updateBBox();
  void updateCoords(const Matrix&);
  void move(const Vector&);
  void moveTo(const Vector&);
  void edit(const Vector&, int);

  void rotateBegin() {}
  void rotate(const Vector& v, int h) {}
  void rotateEnd() {}

  void ps(int);
  int isIn(const Vector&);

  const Vector& getP1() {return p1;}
  const Vector& getP2() {return p2;}
  const Vector& getP3() {return p3;}
  void setPoints(const Vector&, const Vector&);
  void setCoordSystem(CoordSystem, SkyFrame, CoordSystem, SkyFormat);

  double getAngle();

  void list(ostream&, CoordSystem, SkyFrame, SkyFormat, char);
  void listProperties(ostream&, char);
};

#endif
