#  Copyright (C) 1999-2005
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

proc CircleDialog {frame id} {
    global marker

    set w ".marker$id"

    # see if we already have a header window visible
    if [winfo exist $w] {
	raise $w
	return
    }

    # variables
    set marker($frame,$id,dcoord) $marker(dialog,dist,system)
    set marker($frame,$id,dlabel) $marker(dialog,dist,system)
    set marker($frame,$id,dformat) $marker(dialog,dist,format)

    # base
    MarkerBaseCenterDialog $frame $id 275 150

    # menus
    MarkerBaseDistMenu $frame $id radius Radius CircleDistCB dcoord dformat

    # init
    CircleDistCB $frame $id

    # callbacks
    $frame marker $id callback edit CircleEditCB $frame

    # Radius
    label $w.ref.f.radiusTitle -text "Radius"
    entry $w.ref.f.radius -textvariable marker($frame,$id,radius) -width 13 
    label $w.ref.f.radiusformat -textvariable marker($frame,$id,dlabel) \
	-relief groove -width 9 -padx 4
    grid $w.ref.f.radiusTitle $w.ref.f.radius x $w.ref.f.radiusformat \
	-padx 4 -sticky w
}

# actions

proc CircleClose {frame id} {
    $frame marker $id delete callback edit CircleEditCB
    MarkerBaseCenterClose $frame $id
}

proc CircleApply {frame id} {
    global marker

    $frame marker $id circle radius $marker($frame,$id,radius) \
	$marker($frame,$id,dcoord) $marker($frame,$id,dformat)

    MarkerBaseCenterApply $frame $id
}

# callbacks

proc CircleCoordCB {frame id} {
    MarkerBaseCoordCB $frame $id
    MarkerBaseCenterMoveCB $frame $id
}

proc CircleEditCB {frame id} {
    global marker

    set marker($frame,$id,radius) \
	[$frame get marker $id circle radius \
	     $marker($frame,$id,dcoord) $marker($frame,$id,dformat)]
}

proc CircleDistCB {frame id} {
    MarkerBaseDistCB $frame $id
    CircleEditCB $frame $id
}

proc CircleDefaultDialog {} {
    global marker
    global ed

    set w ".circle"

    set ed(ok) 0
    set ed(radius) $marker(circle,radius)

    DialogCreate $w "Default Circle" -borderwidth 2
    frame $w.ed  -relief groove -borderwidth 2
    frame $w.buttons -relief groove -borderwidth 2
    pack $w.ed $w.buttons -fill x -ipadx 4 -ipady 4

    label $w.ed.title -text "Radius"
    entry $w.ed.radius -textvariable ed(radius) -width 10
    label $w.ed.unit -text "image" -relief groove -width 8
    
    grid $w.ed.title $w.ed.radius $w.ed.unit -padx 4 -sticky w

    button $w.buttons.ok -text "OK" -default active -command {set ed(ok) 1}
    button $w.buttons.cancel -text "Cancel" -command {set ed(ok) 0}
    pack $w.buttons.ok -side left -padx 10
    pack $w.buttons.cancel -side right -padx 10

    bind $w <Return> {set ed(ok) 1}
    bind $w <Alt-o> "tkButtonInvoke $w.buttons.ok"
    bind $w <Alt-c> "tkButtonInvoke $w.buttons.cancel"

    DialogCenter $w 
    $w.ed.radius select range 0 end
    DialogWait $w ed(ok) $w.ed.radius
    DialogDismiss $w

    if {$ed(ok)} {
	set marker(circle,radius) $ed(radius)
    }

    unset ed
}
