#  Copyright (C) 1999-2005
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

proc HVFormCB {varname n cmd args} {
    upvar #0 $varname var
    global $varname

    global debug

    if {$debug(tcl,hv)} {
	puts "HVFormCB $varname $n $cmd $args"
    }

    switch -- [string tolower $cmd] {
	form {HVFormForm $varname $n args}
	flush {HVFormFlush $varname $n args}
	input {HVFormInput $varname $n args}
	select {HVFormSelect $varname $n args}
	textarea {HVFormTextArea $varname $n args}
    }
}

proc HVFormForm {varname n a} {
    upvar #0 $varname var
    global $varname
    upvar $a args

    global debug

    if {$debug(tcl,hv)} {
	puts "HVFormForm $n $args"
    }

    # try to clean up lose vars from previous forms
    HVFormFlush $varname $n {}

    set aa [lindex $args 2]
    set var(form,$n,action) [lindex $args 0]
    set var(form,$n,method) [HVattrs method $aa get]

    if {$debug(tcl,hv)} {
	puts "HVFormForm method $var(form,$n,method)"
	puts "HVFormForm action $var(form,$n,action)"
    }
}

proc HVFormFlush {varname n a} {
    upvar #0 $varname var
    global $varname
    upvar $a args

    global debug
    
    if {$debug(tcl,hv)} {
	puts "HVFormFlush $n"
    }

    # try to unset all var(*,$n,*)
    # this does not work for all -textvariable fields, unless window destroyed
    # becareful not to unset var(index,*)!
    foreach x [array names $varname] {
	set f [split $x ,]
	if {[lindex $f 0] != "index" && [lindex $f 1] == $n} {
	    unset ${varname}($x)
	}
    }
}

proc HVFormInput {varname n a} {
    upvar #0 $varname var
    global $varname
    upvar $a args

    global debug

    set path [lindex $args 0]
    set attrs [lindex $args 1]
    if {$debug(tcl,hv)} {
	puts "HVFormInput $n $path $attrs"
    }

    set id [lindex [split $path .] end]
    set type [HVattrs type $attrs {}]
    set disabled [HVattrs disabled $attrs normal]
    set readonly [HVattrs readonly $attrs normal]

    switch -- [string tolower $type] {
	checkbox {
	    set name [HVattrs name $attrs var]
	    set value [HVattrs value $attrs on]
	    set checked [HVattrs checked $attrs nochecked]

	    set var(name,$n,$id) $name
	    if {$checked != "nochecked"} {
		set var(var,$n,$id) $value
	    } else {
		set var(var,$n,$id) {}
	    }
	    set var(init,$n,$id) $$var(var,$n,$id)

	    checkbutton $path -variable ${varname}(var,$n,$id) \
		-onvalue $value -offvalue {} -state $disabled -bg white
	}
	radio {
	    set name [HVattrs name $attrs var]
	    # we need this so that all share the same variable
	    set id $name
	    set value [HVattrs value $attrs on]
	    set checked [HVattrs checked $attrs nochecked]

	    set var(name,$n,$id) $name
	    if {$checked != "nochecked"} {
		set var(var,$n,$id) $value
		set var(init,$n,$id) $var(var,$n,$id)
	    }

	    # override init value
	    foreach f $var(init) {
		if {$n == [lindex $f 0] && 
		    $name == [lindex $f 1] &&
		    $value == [lindex $f 2]} {

		    set var(var,$n,$id) $value
		    set var(init,$n,$id) $var(var,$n,$id)
		}
	    }

	    radiobutton $path -variable ${varname}(var,$n,$id) \
		-value $value -state $disabled -bg white
	}
	button {
	    set name [HVattrs name $attrs submit]
	    set value [HVattrs value $attrs "Submit"]

	    button $path -text $value \
		-command "HVSubmit $varname $n \{$name\} \{$value\}"
	}
	submit {
	    set name [HVattrs name $attrs submit]
	    set value [HVattrs value $attrs "Submit"]

	    button $path -text $value \
		-command "HVSubmit $varname $n \{$name\} \{$value\}"
	}
	reset {
	    set name [HVattrs name $attrs reset]
	    set value [HVattrs value $attrs "Reset"]

	    button $path -text $value -command "HVReset $varname $n"
	}
	image {
	    set name [HVattrs name $attrs submit]
	    set value [HVattrs value $attrs "Submit"]
	    set src [HVattrs src $attrs {}]

	    set img [HVImageCB $varname [$var(widget) resolve $src]]
	    if {$img != "$var(img,gray)"} {
		button $path -image $img \
		    -command "HVSubmit $varname $n \{$name\} \{$value\}"
	    } else {
		button $path -text $value -state $disabled \
		    -command "HVSubmit $varname $n \{$name\} \{$value\}"
	    }
	    return
	}
	hidden {
	    set name [HVattrs name $attrs var]
	    set value [HVattrs value $attrs {}]

	    set var(name,$n,$id) $name
	    set var(var,$n,$id) $value
	}
	password {
	    set name [HVattrs name $attrs var]
	    set value [HVattrs value $attrs {}]
	    set size [HVattrs size $attrs 20]

	    set var(name,$n,$id) $name
	    set var(var,$n,$id) $value
	    set var(init,$n,$id) $var(var,$n,$id)

	    entry $path -textvariable ${varname}(var,$n,$id) \
		-width $size -show "*" -state $readonly
	}
	file {
	    set name [HVattrs name $attrs var]
	    set value [HVattrs value $attrs {}]
	    set size [HVattrs size $attrs 20]

	    set var(name,$n,$id) $name
	    set var(var,$n,$id) [HVInitVar $varname $n $name $value]
	    set var(init,$n,$id) $var(var,$n,$id)

	    entry $path -textvariable ${varname}(var,$n,$id) \
		-width $size -state $readonly
	}
	text -
	default {
	    set name [HVattrs name $attrs var]
	    set value [HVattrs value $attrs {}]
	    set size [HVattrs size $attrs 20]

	    set var(name,$n,$id) $name
	    set var(var,$n,$id) [HVInitVar $varname $n $name $value]
	    set var(init,$n,$id) $var(var,$n,$id)

	    entry $path -textvariable ${varname}(var,$n,$id) \
		-width $size -state $readonly
	}
    }
}

proc HVFormSelect {varname n a} {
    upvar #0 $varname var
    global $varname
    upvar $a args

    global debug

    set path [lindex $args 0]
    set attrs [lindex $args 1]
    set choices [lindex $args 2]
    set initial [lindex $args 3]
    if {$debug(tcl,hv)} {
	puts "HVFormSelect :$n:$path:$attrs:$choices:$initial:"
    }

    set id [lindex [split $path .] end]
    set name [HVattrs name $attrs var]

    set size [HVattrs size $attrs 0]
    set multiple [HVattrs multiple $attrs single]
    if {[string length $multiple] == 0} {
	set multiple multiple
    }

    switch -- $multiple {
	single {
	    set var(name,$n,$id) $name

	    menubutton $path -textvariable ${varname}(single,$n,$id) \
		-menu $path.m -relief raised -bd 2 
	    menu $path.m -tearoff 0

	    set l 0
	    set first 1
	    foreach f $choices {
		set i [lindex $f 0]
		set v [lindex $f 1]
		set m [lindex $f 2]
		if {[string length $v] == 0} {
		    set v $m
		}

		if {$i || $first} {
		    set var(var,$n,$id) $v
		    set var(init,$n,$id) $v
		    set var(single,$n,$id) $m
		    set var(singleinit,$n,$id) $m
		    set first 0
		}
		
		if {[string length $m]>$l} {
		    set l [string length $m]
		}
		$path.m add command -label $m -command \
		    "upvar #0 $varname var; set var(var,$n,$id) \"$v\"; set var(single,$n,$id) \"$m\""
	    }

	    # override init value
	    foreach f $var(init) {
		if {$n == [lindex $f 0] && $name == [lindex $f 1]} {
		    set v [lindex $f 2]
		    set m [lindex $f 3]

		    set var(var,$n,$id) $v
		    set var(init,$n,$id) $v
		    set var(single,$n,$id) $m
		    set var(singleinit,$n,$id) $m
		}
	    }

	    $path configure -width $l
	}
	multiple {
	    set var(name,$n,$id) $name
	    set var(multivar,$n,$id) {}
	    set var(multiinit,$n,$id) {}
	    set var(multimenu,$n,$id) {}

	    set l 0
	    set long {}
	    set ii 0
	    foreach f $choices {
		if [lindex $f 0] {
		    lappend var(multiinit,$n,$id) $ii
		}
		set foo [lindex $f 1]
		if {[string length $foo] == 0} {
		    set foo [lindex $f 2]
		}
		lappend var(multivar,$n,$id) $foo
		lappend var(multimenu,$n,$id) [lindex $f 2]

		set m [lindex $f 2]
		if {[string length $m]>$l} {
		    set long $m
		    set l [string length $m]
		}
		incr ii
	    }
	    set var(multiple,$n,$id) $path

	    # we have a problem
	    # the frame we create will not resize itself based on the
	    # interior size of the listbox and the scrollbar
	    # so, we need to set the frame size by hand

	    set font {Helvetica 10}
#	    set font {Helvetica 12}
	    frame $path
	    scrollbar $path.scroll -command "$path.list yview" \
		-width 10
	    listbox $path.list -selectmode multiple \
		-width 0 -height $size \
		-listvar ${varname}(multimenu,$n,$id) \
		-font $font \
		-yscroll "$path.scroll set" \
		-exportselection false

	    set w [expr [font measure $font $long]+30]
	    set h [expr $size*[font metrics $font -linespace]]
	    $path configure -width $w -height $h

	    pack $path.list $path.scroll -side left -fill y -expand 1

	    foreach ii $var(multiinit,$n,$id) {
		$path.list selection set $ii
	    }
	}
    }
}

proc HVFormTextArea {varname n a} {
    upvar #0 $varname var
    global $varname
    upvar $a args

    global debug

    set path [lindex $args 0]
    set attrs [lindex $args 1]
    set initial [string range [lindex $args 2] 1 end]
    
    if {$debug(tcl,hv)} {
	puts "HVFormTextArea $n $path $attrs $initial"
    }

    set id [lindex [split $path .] end]
    set name [HVattrs name $attrs var]

    set rows [HVattrs rows $attrs 4]
    set cols [HVattrs cols $attrs 20]
    set readonly [HVattrs disabled $attrs normal]

    # update initial
    set initial [HVInitVar $varname $n $name $initial]

    text $path -height $rows -width $cols -wrap none -state $readonly
    $path insert end $initial

    set var(name,$n,$id) $name
    set var(var,$n,$id) $initial
    set var(init,$n,$id) $var(var,$n,$id)
    set var(textarea,$n,$id) $path
}

proc HVattrs {k l def} {
    # break list up into key/value pairs
    set key {}
    set value {}
    set w 1
    foreach f $l {
	if {$w} {
	    lappend key [string tolower $f]
	    set w 0
	} else {
	    lappend value $f
	    set w 1
	}
    }
    set a [lsearch -exact $key [string tolower $k]]
    if {$a>=0} {
	return [lindex $value $a]
    } else {
	return $def
    }
}

proc HVSubmit {varname n name value} {
    upvar #0 $varname var
    global $varname

    global http
    global debug

    if {$debug(tcl,hv)} {
	puts "HVSubmit $n"
    }

    # update textareas
    foreach x [array names $varname] {
	set f [split $x ,]
	if {[lindex $f 0] == "textarea" && [lindex $f 1] == $n} {
	    set id [lindex $f 2]
	    set path $var($x)
	    set var(var,$n,$id) [$path get 1.0 end]
	}
    }

    set query {}
    # append button name=value
    append query "[http::formatQuery $name]=[http::formatQuery $value]&"

    # append normal vars
    foreach x [array names $varname] {
	set f [split $x ,]
	if {[lindex $f 0] == "var" && [lindex $f 1] == $n} {
	    set id [lindex $f 2]
	    set v [string trim $var(var,$n,$id)]
	    if {[string length $v] != 0} {
		append query "[http::formatQuery $var(name,$n,$id)]=[http::formatQuery $v]&"
	    }
	}
    }

    # append multiple select
    foreach x [array names $varname] {
	set f [split $x ,]
	if {[lindex $f 0] == "multiple" && [lindex $f 1] == $n} {
	    set id [lindex $f 2]
	    set path $var($x)
	    set iii [$path.list curselection]
	    foreach ii $iii {
		set v [string trim [lindex $var(multivar,$n,$id) $ii]]
		if {[string length $v] != 0} {
		    append query "[http::formatQuery $var(name,$n,$id)]=[http::formatQuery $v]&"
		}
	    }
	}
    }

    # remove last '&'
    set query [string trimright $query &]

    HVClearIndex $varname $var(index)

    # clear previous
    set var(previous) {}

    # and do it
    # already resolved
    switch -- [string tolower $var(form,$n,method)] {
	get {HVLoadURL $varname "$var(form,$n,action)?$query" {}}
	post {HVLoadURL $varname "$var(form,$n,action)" "$query"}
    }
}

proc HVReset {varname n} {
    upvar #0 $varname var
    global $varname

    global http
    global debug

    if {$debug(tcl,hv)} {
	puts "HVReset $n"
    }

    foreach x [array names $varname] {
	set f [split $x ,]
	if {[lindex $f 0] == "init" && [lindex $f 1] == $n} {
	    set var(var,$n,[lindex $f 2]) $var($x)
	}
    }

    #update single select
    foreach x [array names $varname] {
	set f [split $x ,]
	if {[lindex $f 0] == "singleinit" && [lindex $f 1] == $n} {
	    set id [lindex $f 2]
	    set var(single,$n,$id) $var($x)
	}
    }

    # update multiple select
    foreach x [array names $varname] {
	set f [split $x ,]
	if {[lindex $f 0] == "multiinit" &&  [lindex $f 1] == $n} {
	    set id [lindex $f 2]
	    set path $var(multiple,$n,$id)
	    $path.list selection clear 0
	    foreach ii $var($x) {
		$path.list selection set $ii
	    }
	}
    }

    # update textareas
    foreach x [array names $varname] {
	set f [split $x ,]
	if {[lindex $f 0] == "textarea" && [lindex $f 1] == $n} {
	    set id [lindex $f 2]
	    set path $var($x)

	    $path delete 1.0 end
	    $path insert end $var(init,$n,$id)
	}
    }
}

proc HVInitVar {varname n name def} {
    upvar #0 $varname var
    global $varname

    foreach f $var(init) {
	if {$n == [lindex $f 0] && $name == [lindex $f 1]} {
	    return [lindex $f 2]
	}
    }
    return $def
}

proc HVFixHTMLForm {varname} {
    upvar #0 $varname var
    global $varname

    global debug

    if [regexp -nocase {<form [^>]*} $var(html) r] {
	if {![regexp -nocase {action=} $r]} {
	    if {$debug(tcl,hv)} {
	    puts "HVFixFormHTML action fixed"
	    }
	    
	    set rr "$r action=[$var(widget) cget -base]"
	    regsub -nocase {<form [^>]*} $var(html) $rr var(html)
	}
    }
}
