#  Copyright (C) 1999-2005
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

proc MarkerBaseAnnulusDialog {frame id width height} {
    global marker
    global ds9

    set w ".marker$id"
    set mb ".mb$id"

    set t [$frame get marker $id type]
    switch -- $t {
	ellipseannulus {
	    set type "Ellipse Annulus"
	    set which "EllipseAnnulus"
	}
	boxannulus {
	    set type "Box Annulus"
	    set which "BoxAnnulus"
	}
	default {
	    set type [string totitle $t]
	    set which $type
	}
    }

    # variables
    set marker($frame,$id,which) $which
    set marker($frame,$id,system) $marker(dialog,system)
    set marker($frame,$id,clabel) $marker($frame,$id,system)
    set marker($frame,$id,sky) $marker(dialog,sky)
    set marker($frame,$id,skyformat) $marker(dialog,skyformat)
    set marker($frame,$id,x) 0
    set marker($frame,$id,y) 0

    # init
    MarkerBaseTextCB $frame $id
    MarkerBaseColorCB $frame $id
    MarkerBaseLineWidthCB $frame $id
    MarkerBasePropertyCB $frame $id
    MarkerBaseFontCB $frame $id
    ${which}CoordCB $frame $id

    MarkerBaseCenterMoveCB $frame $id

    # callbacks
    $frame marker $id callback delete MarkerBaseDeleteCB $frame
    $frame marker $id callback text MarkerBaseTextCB $frame
    $frame marker $id callback color MarkerBaseColorCB $frame
    $frame marker $id callback width MarkerBaseLineWidthCB $frame
    $frame marker $id callback property MarkerBasePropertyCB $frame
    $frame marker $id callback font MarkerBaseFontCB $frame

    $frame marker $id callback move MarkerBaseCenterMoveCB $frame

    # menus
    MarkerBaseMenu $frame $id
    MarkerBaseAnnulusFileMenu $frame $id
    MarkerBaseColorMenu $frame $id
    MarkerBaseWidthMenu $frame $id
    MarkerBasePropertyMenu $frame $id
    MarkerBaseFontMenu $frame $id
    MarkerBaseCoordMenu $frame $id

    # window
    toplevel $w -colormap $ds9(main)
    wm title $w $type
    wm iconname $w $type
    wm group $w $ds9(top)
    wm protocol $w WM_DELETE_WINDOW "${which}Close $frame $id"
    $w configure -menu $mb
    wm minsize $w $width $height

    # dialog
    frame $w.ref
    frame $w.buttons -relief groove -borderwidth 2
    pack $w.ref -fill x
    pack $w.buttons -fill x -ipadx 4 -ipady 4

    frame $w.ref.left
    frame $w.ref.right -relief groove -borderwidth 2
    pack $w.ref.left $w.ref.right -side left -fill y

    frame $w.ref.left.top -relief groove -borderwidth 2
    frame $w.ref.left.top.f
    frame $w.ref.left.bottom -relief groove -borderwidth 2
    frame $w.ref.left.bottom.f
    pack $w.ref.left.top.f $w.ref.left.bottom.f -anchor w -padx 4 -pady 4
    pack $w.ref.left.top $w.ref.left.bottom -fill both -expand true

    # ID
    label $w.ref.left.top.f.idTitle -text "Id"
    label $w.ref.left.top.f.idValue -text "$id"

    # Text
    label $w.ref.left.top.f.textTitle -text "Text"
    entry $w.ref.left.top.f.textValue -textvariable marker($frame,$id,text) \
	-width 40

    grid $w.ref.left.top.f.idTitle $w.ref.left.top.f.idValue -padx 4 -sticky w
    grid $w.ref.left.top.f.textTitle $w.ref.left.top.f.textValue \
	-padx 4 -sticky w

    # Center

    label $w.ref.left.bottom.f.centerTitle -text "Center"
    entry $w.ref.left.bottom.f.centerX -textvariable marker($frame,$id,x) \
	-width 13
    entry $w.ref.left.bottom.f.centerY -textvariable marker($frame,$id,y) \
	-width 13
    label $w.ref.left.bottom.f.centerCoord -relief groove -width 9 \
	-padx 4 -textvariable marker($frame,$id,clabel)
    grid $w.ref.left.bottom.f.centerTitle $w.ref.left.bottom.f.centerX \
    $w.ref.left.bottom.f.centerY $w.ref.left.bottom.f.centerCoord \
	-padx 4 -sticky w

    # Buttons
    button $w.buttons.apply -text Apply -command "${which}Apply $frame $id"
    button $w.buttons.generate -text Generate \
	-command "${which}Generate $frame $id"
    button $w.buttons.close -text Close	-command "${which}Close $frame $id"
    pack $w.buttons.apply $w.buttons.generate $w.buttons.close \
	-side left -padx 10 -expand true

    bind $w <Return> "${which}Apply $frame $id"

    # some window managers need a hint
    raise $w
}

proc MarkerBaseAnnulusFileMenu {frame id} {
    global menu
    global marker

    set mb ".mb$id"
    set which $marker($frame,$id,which)

    menu $mb.file -tearoff 0 -selectcolor $menu(selectcolor)
    $mb.file add command -label Apply -command "${which}Apply $frame $id"
    $mb.file add command -label Generate -command "${which}Generate $frame $id"
    $mb.file add separator
    $mb.file add command -label Close -command "${which}Close $frame $id"
}

proc MarkerBaseAnnulusMethodMenu {frame id} {
    global menu
    global marker

    set mb ".mb$id"

    $mb add cascade -label Method -menu $mb.method
    menu $mb.method -tearoff 0 -selectcolor $menu(selectcolor)
    $mb.method add radiobutton -label "Equal Distance" \
	-variable marker($frame,$id,method) -value dist
    $mb.method add radiobutton -label "Equal Area" \
	-variable marker($frame,$id,method) -value area
}

proc MarkerBaseAnnulusGenerateCircle {frame id} {
    global marker

    $marker($frame,$id,annulitxt) delete 1.0 end

    if {$marker($frame,$id,annuli) < 1} {
	set marker($frame,$id,annuli) 1
    }

    set inner $marker($frame,$id,inner)
    set outer $marker($frame,$id,outer)
    set annuli $marker($frame,$id,annuli)

    if {($inner != "") && ($outer != "") && ($annuli != "")} {
	switch -- $marker($frame,$id,method) {
	    dist {
		for {set i 0} {$i<=$annuli} {incr i} {
		    $marker($frame,$id,annulitxt) insert end \
 		    "[expr ((($outer-$inner)/double($annuli))*$i)+$inner]\n"
		}
	    }

	    area {
		set pi 3.14159265358979323846
		set area [expr $pi*(($outer*$outer)-($inner*$inner))/$annuli]

		set r0 $inner
		$marker($frame,$id,annulitxt) insert end "$r0\n"
		for {set i 0} {$i<$annuli} {incr i} {
		    set r1 [expr sqrt(($area+($pi*$r0*$r0))/$pi)]
		    $marker($frame,$id,annulitxt) insert end \
			[format "%.4f\n" $r1]
		    set r0 $r1
		}
	    }
	}
    }
}

proc MarkerBaseAnnulusGenerateEllipse {frame id} {
    global marker

    $marker($frame,$id,annulitxt) delete 1.0 end

    if {$marker($frame,$id,annuli) < 1} {
	set marker($frame,$id,annuli) 1
    }

    set radius1 $marker($frame,$id,radius1)
    set radius2 $marker($frame,$id,radius2)
    set radius3 $marker($frame,$id,radius3)
    set annuli $marker($frame,$id,annuli)

    if {($radius1 != "") && ($radius2 != "") && \
        ($radius3 != "") && ($annuli != "")} {

	switch -- $marker($frame,$id,method) {
	    dist {
		for {set i 0} {$i<=$annuli} {incr i} {
		    set major [expr ((($radius1-$radius3)/double($annuli))*$i)\
				   +$radius3]
		    set minor [expr $major*$radius2/$radius1]
		    $marker($frame,$id,annulitxt) insert end "$major $minor\n"
		}
	    }

	    area {
		set pi 3.14159265358979323846
		set r [expr double($radius2)/$radius1]
		set area [expr $pi*(($radius1*$radius2)-($radius3*$radius3*$r))\
			      /$annuli]

		set major0 $radius3
		set minor0 [expr $radius3*$r]
		$marker($frame,$id,annulitxt) insert end "$major0 $minor0\n"
		for {set i 0} {$i<$annuli} {incr i} {
		    set major1 [expr sqrt(($area+($pi*$major0*$minor0)) / \
					      ($pi*$r))]
		    set minor1 [expr $major1*$r]
		    $marker($frame,$id,annulitxt) insert end \
			[format "%.4f %.4f\n" $major1 $minor1]
		    set major0 $major1
		    set minor0 $minor1
		}
	    }
	}
    }
}

proc MarkerBaseAnnulusGenerateBox {frame id} {
    global marker

    $marker($frame,$id,annulitxt) delete 1.0 end

    if {$marker($frame,$id,annuli) < 1} {
	set marker($frame,$id,annuli) 1
    }

    set radius1 $marker($frame,$id,radius1)
    set radius2 $marker($frame,$id,radius2)
    set radius3 $marker($frame,$id,radius3)
    set annuli $marker($frame,$id,annuli)

    if {($radius1 != "") && ($radius2 != "") && \
        ($radius3 != "") && ($annuli != "")} {

	if {$radius1<=0} {
	    set radius1 1
	}
	if {$radius2<=0} {
	    set radius2 1
	}

	switch -- $marker($frame,$id,method) {
	    dist {
		for {set i 0} {$i<=$annuli} {incr i} {
		    set major [expr ((($radius1-$radius3)/$annuli)*$i)+$radius3]
		    set minor [expr $major*$radius2/$radius1]
		    $marker($frame,$id,annulitxt) insert end "$major $minor\n"
		}
	    }

	    area {
		set r [expr double($radius2)/$radius1]
		set area [expr (($radius1*$radius2)-($radius3*$radius3*$r)) \
			      /$annuli]

		set major0 $radius3
		set minor0 [expr $radius3*$r]
		$marker($frame,$id,annulitxt) insert end "$major0 $minor0\n"
		for {set i 0} {$i<$annuli} {incr i} {
		    set major1 [expr sqrt(($area+($major0*$minor0))/$r)]
		    set minor1 [expr $major1*$r]
		    $marker($frame,$id,annulitxt) insert end \
			[format "%.4f %.4f\n" $major1 $minor1]
		    set major0 $major1
		    set minor0 $minor1
		}
	    }
	}
    }
}
