// Copyright (C) 1999-2005
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __colorbarbase_h__
#define __colorbarbase_h__

#include "widget.h"

// ColorbarBase

class ColorbarBase : public Widget {
protected:
  unsigned char* colorCells;
  int colorCount;

  GC borderGC;

protected:
  void renderBorder();

  virtual int initColormap() =0;
  virtual void updateColors() =0;
  virtual int updatePixmap(const BBox&) =0; 
  virtual void reset() =0;

  int postscriptProc(int);   // generate postscript
  virtual void psLevel1(PSColorSpace, int, int, float) =0;
  virtual void psLevel2(PSColorSpace, int, int, float) =0;

public:
  ColorbarBase(Tcl_Interp*, Tk_Canvas, Tk_Item*);
  virtual ~ColorbarBase();

  int parse(istringstream&);
  int configure(int, const char* [], int);

  virtual void adjustCmd(float, float) =0;
  virtual void getBiasCmd() =0;
  virtual void getColormapCmd() =0;
  virtual void getColormapNameCmd(int) =0;
  virtual void getContrastCmd() =0;
  virtual void getCurrentFileNameCmd() =0;
  virtual void getCurrentIDCmd() =0;
  virtual void getCurrentNameCmd() =0;
  virtual void getInvertCmd() =0;
};

#endif

