// Copyright (C) 1999-2005
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#include <stdlib.h>
#include <limits.h>

#include "tcl.h"
#include <Xlib.h>
#include <Xutil.h>

#include "colorbartrue.h"
#include "util.h"

ColorbarTrueColor::ColorbarTrueColor(Tcl_Interp* i,Tk_Canvas c,Tk_Item* item) 
  : Colorbar(i, c, item)
{
  colorCount = 0;
  xmap = NULL;
}

ColorbarTrueColor::~ColorbarTrueColor()
{
  if (xmap)
    XDestroyImage(xmap);
}

void ColorbarTrueColor::invalidPixmap()
{
  Widget::invalidPixmap();

  if (xmap)
    XDestroyImage(xmap);
  xmap = NULL;
}

int ColorbarTrueColor::updatePixmap(const BBox& bb)
{
  // create a valid pixmap if needed
  // bb is in canvas coords

  if (!pixmap || !xmap) {
    int& width = options->width;
    int& height = options->height;
    
    // pixmap

    if (!pixmap)
      if (!(pixmap = Tk_GetPixmap(display, Tk_WindowId(tkwin), 
				  width, height, depth))) {
	cerr << "ColorbarTrueColor Internal Error: Unable to Create Pixmap" 
	     << endl;
	exit(1);
      }

    // xmap

    if (!xmap) {
      if (!(xmap = XGETIMAGE(display, pixmap, 0, 0, width, height, 
			     AllPlanes, ZPixmap))){
	cerr << "ColorbarTrueColor Internal Error: Unable to Create XImage" 
	     << endl;
	exit(1);
      }

      updateColors();
    }
  }

  return TCL_OK;
}

int ColorbarTrueColor::initColormapForReal()
{
  colorIndex = new unsigned short[colorCount];
  for (int i=0; i<colorCount; i++)
    colorIndex[i] = i;
  colorCells = new unsigned char[colorCount*3];

  return TCL_OK;
}

void ColorbarTrueColor::updateColorCells()
{
  // fill rgb table
  // note: its filled bgr to match XImage

  if (currentcmap)
    for(int i=0, j=colorCount-1; i<colorCount; i++, j--) {
      int index = invert ? calcContrastBias(j) : calcContrastBias(i);
      colorCells[i*3] = currentcmap->getBlueChar(index, colorCount);
      colorCells[i*3+1] = currentcmap->getGreenChar(index, colorCount);
      colorCells[i*3+2] = currentcmap->getRedChar(index, colorCount);
    }
}
