// Copyright (C) 1999-2005
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __fitssmap_h__
#define __fitssmap_h__

#include "file.h"

class FitsSMap : public FitsFile {
protected:
  char* hmapdata_;
  off_t hmapsize_;

  char* mapdata_;
  off_t mapsize_;

public:
  FitsSMap();
  virtual ~FitsSMap() {}

  char* mapdata() {return mapdata_;}
  int mapsize() {return mapsize_;}
};

class FitsFitsSMap : public virtual FitsSMap {
public:
  FitsFitsSMap(FitsHead::Memory);
};

class FitsFitsNextSMap : public FitsSMap {
public:
  FitsFitsNextSMap(FitsFile* prev);
};

#endif








