// Copyright (C) 1999-2005
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __cpanda_h__
#define __cpanda_h__

#include "basepanda.h"
#include "baseellipse.h"

class Cpanda : public BasePanda, public BaseEllipse {
 private:
  void updateHandles();
  void render(Drawable, const Matrix&, RenderMode);

  void listA(ostream&, CoordSystem, SkyFrame, SkyFormat, int, int);
  void listB(ostream&, CoordSystem, SkyFrame, SkyFormat, int, int);

 public:
  Cpanda(const Cpanda&);
  Cpanda(FrameBase* p, const Vector& ctr, 
	double a1, double a2, int an,
	double r1, double r2, int rn,
	const char* clr, int wth, const char* fnt, const char* txt, 
	unsigned short prop, const char* cmt, 
	const List<Tag>& tg, const List<CallBack>& cb);

  Cpanda(FrameBase* p, const Vector& ctr, 
	int an, double* a,
	int rn, double* r,
	const char* clr, int wth, const char* fnt, const char* txt, 
	unsigned short prop, const char* cmt, 
	const List<Tag>& tg, const List<CallBack>& cb);

  Marker* dup() {return new Cpanda(*this);}
  void ps(int);

  void edit(const Vector&, int);
  void editEnd();

  void rotateBegin() {}
  void rotate(const Vector& v, int h) {}
  void rotateEnd() {}

  int addAnnuli(const Vector&);
  int addAngles(const Vector&);
  void setAnglesAnnuli(double, double, int, Vector, Vector, int);
  void setAnglesAnnuli(const double*, int, const Vector*, int);
  void deleteAnglesAnnuli(int h);

  void list(ostream&, CoordSystem, SkyFrame, SkyFormat, int, int);
  void listCiao(ostream&, CoordSystem, int, int);

  // special composite funtionality
  void setComposite(const Matrix&, double);
};

#endif
