// Copyright (C) 1999-2005
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __ruler_h__
#define __ruler_h__

#include "baseline.h"

class Ruler : public BaseLine {
private:
  Vector p3;
  CoordSystem coordSystem;
  SkyFrame skyFrame;
  CoordSystem distSystem;
  SkyFormat distFormat;
  double dist;

  void render(Drawable, const Matrix&, RenderMode);
  void renderDist(Drawable, Vector, RenderMode);
  void psDist(int, Vector);
  int isOn(const Vector&, const Vector&, const Vector&);
  void distToStr(ostream&);

public:
  Ruler(const Ruler&);
  Ruler(FrameBase* p, const Vector& ptr1, const Vector& ptr2,
	CoordSystem sys, SkyFrame sky, 
	CoordSystem distsys, SkyFormat distfor,
	const char* clr, int wth, const char* fnt, const char* txt, 
	unsigned short prop, const char* cmt,
	const List<Tag>& tg, const List<CallBack>& cb);

  Marker* dup() {return new Ruler(*this);}

  void updateBBox();
  void updateCoords(const Matrix&);

  void ps(int);
  int isIn(const Vector&);

  const Vector& getP1() {return p1;}
  const Vector& getP2() {return p2;}
  const Vector& getP3() {return p3;}
  void setCoordSystem(CoordSystem, SkyFrame, CoordSystem, SkyFormat);

  CoordSystem getSystem() {return coordSystem;}
  SkyFrame getSkyFrame() {return skyFrame;}

  CoordSystem getDistSystem() {return distSystem;}
  SkyFormat getDistFormat() {return distFormat;}

  void list(ostream&, CoordSystem, SkyFrame, SkyFormat, int, int);
  void listPost(ostream&, int, int);
};

#endif
