// Copyright (C) 1999-2005
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __xxlib_h__
#define __xxlib_h__

#include <tcl.h>
#include <Xlib.h>

extern "C" {
  void XPutImage(Display* display, Drawable d, GC gc, XImage* image,
		 int src_x, int src_y, int dest_x, int dest_y,
		 unsigned int width, unsigned int height);

  void XClearArea(Display* display, Window w, int x, int y,
		  unsigned int width, unsigned int height, Bool exposures);

  void XSetClipRectangles(Display* display, GC gc, int clip_x_origin,
			  int  clip_y_origin, XRectangle* r,
			  int  n, int  ordering);

  Status XAllocColorCells(Display* display, Colormap xcmap, Bool contig,
			  unsigned long *planes_mask, unsigned int nplanes,
			  unsigned long *pixels, unsigned int ncolors);

  void XStoreColors(Display* display,Colormap xcmap,XColor* color,int ncolors);

  void XInstallColormap(Display* display, Colormap colormap);

  void XDrawString(Display* display, Drawable drawable, GC gc, int x, int y,
		   _Xconst char* str, int length);

  Pixmap XCreatePixmap(Display* display, Drawable drawable, 
		       unsigned int width, unsigned int height,
		       unsigned int depth);

  void XFreePixmap(Display* display, Pixmap pixmap);

  Status XGetGCValues(Display* disp,GC gc, unsigned long mask, XGCValues* ret);

  void XCopyGC(Display* display, GC src, unsigned long mask, GC dest);

  void XXDrawLines(Display* display, Drawable d, GC gc, 
		   XPoint* points, int npoints, int mode);

  void XXDrawLine(Display* display, Drawable d, GC gc, 
		  int x1, int y1, int x2, int y2);

  void XXDrawArc(Display* display, Drawable d, GC gc, int x, int y, 
		 unsigned int width, unsigned int height, int start, 
		 int extent);

  void XXDrawRectangle(Display* display, Drawable d, GC gc, int x, int y, 
		       unsigned int width, unsigned int height);

  void XXFillPolygon(Display* display, Drawable d, GC gc, XPoint* points,
		     int npoints, int shape, int mode);

  void XXFillArc(Display* display, Drawable d, GC gc, int x, int y, 
		 unsigned int width, unsigned int height, int start, 
		 int extent);

  void XXWarpPointer(Display* display, Window src_w, Window dest_w,
		     int src_x, int src_y,
		     unsigned int src_width, unsigned int src_height,
		     int dest_x, int dest_y);

  XImage* XXGetImage(Display*, Drawable, int x, int y,
		     unsigned int w, unsigned int h,
		     unsigned long plane, int format);
}
#endif
