// Copyright (C) 1999-2012
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __frametrue_h__
#define __frametrue_h__

#include "framebase.h"

class FrameTrue : public virtual FrameBase {
 protected:
  XImage* colormapXM;      // rotate dest ximage
  Pixmap colormapPM;       // rotate pixmap
  GC colormapGCXOR;        // GC for interactive rotation

  int byteorder_;
  int bitsperpixel_;

 protected:
  void encodeTrueColor(int oo, int bb) {byteorder_ = oo; bitsperpixel_ = bb;}
  virtual void encodeTrueColor(XColor*, char*) =0;
  virtual void encodeTrueColor(unsigned char*, XImage*) =0;
  void rotateMotion();

 public:
  FrameTrue(Tcl_Interp*, Tk_Canvas, Tk_Item*);
  virtual ~FrameTrue();
};

#endif
